/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.settings;

import com.datastax.oss.dsbulk.workflow.api.utils.WorkflowUtils;
import com.datastax.oss.dsbulk.workflow.commons.settings.BatchSettings;
import com.datastax.oss.dsbulk.workflow.commons.settings.CodecSettings;
import com.datastax.oss.dsbulk.workflow.commons.settings.ConnectorSettings;
import com.datastax.oss.dsbulk.workflow.commons.settings.DriverSettings;
import com.datastax.oss.dsbulk.workflow.commons.settings.EngineSettings;
import com.datastax.oss.dsbulk.workflow.commons.settings.ExecutorSettings;
import com.datastax.oss.dsbulk.workflow.commons.settings.LogSettings;
import com.datastax.oss.dsbulk.workflow.commons.settings.MonitoringSettings;
import com.datastax.oss.dsbulk.workflow.commons.settings.SchemaGenerationStrategy;
import com.datastax.oss.dsbulk.workflow.commons.settings.SchemaSettings;
import com.datastax.oss.dsbulk.workflow.commons.settings.StatsSettings;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;

public class SettingsManager {
    private final Config config;
    private String executionId;
    private DriverSettings driverSettings;
    private ConnectorSettings connectorSettings;
    private SchemaSettings schemaSettings;
    private BatchSettings batchSettings;
    private ExecutorSettings executorSettings;
    private LogSettings logSettings;
    private CodecSettings codecSettings;
    private MonitoringSettings monitoringSettings;
    private EngineSettings engineSettings;
    private StatsSettings statsSettings;

    public SettingsManager(Config config) {
        this.config = config;
    }

    public void init(String operationTitle, boolean configureConnectorForReads, SchemaGenerationStrategy schemaGenerationStrategy) {
        this.engineSettings = new EngineSettings(this.config.getConfig("dsbulk.engine"));
        this.engineSettings.init();
        this.executionId = this.engineSettings.getCustomExecutionIdTemplate().map(template -> WorkflowUtils.newCustomExecutionId((String)template, (String)operationTitle)).orElse(WorkflowUtils.newDefaultExecutionId((String)operationTitle));
        this.logSettings = new LogSettings(this.config.getConfig("dsbulk.log"), this.executionId);
        this.driverSettings = new DriverSettings(this.config.getConfig("dsbulk.driver"), this.config.getConfig("dsbulk.executor.continuousPaging"), this.config.getConfig("datastax-java-driver"));
        this.connectorSettings = new ConnectorSettings(this.config.getConfig("dsbulk.connector"), configureConnectorForReads);
        this.batchSettings = new BatchSettings(this.config.getConfig("dsbulk.batch"));
        this.executorSettings = new ExecutorSettings(this.config.getConfig("dsbulk.executor"));
        this.codecSettings = new CodecSettings(this.config.getConfig("dsbulk.codec"));
        this.schemaSettings = new SchemaSettings(this.config.getConfig("dsbulk.schema"), schemaGenerationStrategy);
        this.monitoringSettings = new MonitoringSettings(this.config.getConfig("dsbulk.monitoring"), this.executionId);
        this.statsSettings = new StatsSettings(this.config.getConfig("dsbulk.stats"));
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public DriverSettings getDriverSettings() {
        return this.driverSettings;
    }

    public ConnectorSettings getConnectorSettings() {
        return this.connectorSettings;
    }

    public SchemaSettings getSchemaSettings() {
        return this.schemaSettings;
    }

    public BatchSettings getBatchSettings() {
        return this.batchSettings;
    }

    public ExecutorSettings getExecutorSettings() {
        return this.executorSettings;
    }

    public LogSettings getLogSettings() {
        return this.logSettings;
    }

    public CodecSettings getCodecSettings() {
        return this.codecSettings;
    }

    public MonitoringSettings getMonitoringSettings() {
        return this.monitoringSettings;
    }

    public EngineSettings getEngineSettings() {
        return this.engineSettings;
    }

    public StatsSettings getStatsSettings() {
        return this.statsSettings;
    }

    public Config getEffectiveBulkLoaderConfig() {
        Config dsbulkConfig = this.config.getConfig("dsbulk").withoutPath("metaSettings").withoutPath("connector");
        if (this.connectorSettings.getConnectorConfig() != null) {
            dsbulkConfig = dsbulkConfig.withFallback((ConfigMergeable)this.connectorSettings.getConnectorConfig().atPath("connector." + this.connectorSettings.getConnectorName())).withoutPath("config");
        }
        return dsbulkConfig;
    }
}

