/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.settings;

import com.datastax.dse.driver.api.core.metadata.schema.DseEdgeMetadata;
import com.datastax.dse.driver.api.core.metadata.schema.DseGraphKeyspaceMetadata;
import com.datastax.dse.driver.api.core.metadata.schema.DseGraphTableMetadata;
import com.datastax.dse.driver.api.core.metadata.schema.DseTableMetadata;
import com.datastax.dse.driver.api.core.metadata.schema.DseVertexMetadata;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.IndexMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.base.Predicates;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableCollection;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSetMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.LinkedHashMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecFactory;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.datastax.oss.dsbulk.connectors.api.Field;
import com.datastax.oss.dsbulk.connectors.api.RecordMetadata;
import com.datastax.oss.dsbulk.mapping.CQLFragment;
import com.datastax.oss.dsbulk.mapping.CQLRenderMode;
import com.datastax.oss.dsbulk.mapping.CQLWord;
import com.datastax.oss.dsbulk.mapping.DefaultMapping;
import com.datastax.oss.dsbulk.mapping.FunctionCall;
import com.datastax.oss.dsbulk.mapping.IndexedMappingField;
import com.datastax.oss.dsbulk.mapping.MappedMappingField;
import com.datastax.oss.dsbulk.mapping.Mapping;
import com.datastax.oss.dsbulk.mapping.MappingField;
import com.datastax.oss.dsbulk.mapping.MappingInspector;
import com.datastax.oss.dsbulk.mapping.MappingPreference;
import com.datastax.oss.dsbulk.partitioner.TokenRangeReadStatementGenerator;
import com.datastax.oss.dsbulk.workflow.commons.schema.DefaultReadResultCounter;
import com.datastax.oss.dsbulk.workflow.commons.schema.DefaultReadResultMapper;
import com.datastax.oss.dsbulk.workflow.commons.schema.DefaultRecordMapper;
import com.datastax.oss.dsbulk.workflow.commons.schema.QueryInspector;
import com.datastax.oss.dsbulk.workflow.commons.schema.ReadResultCounter;
import com.datastax.oss.dsbulk.workflow.commons.schema.ReadResultMapper;
import com.datastax.oss.dsbulk.workflow.commons.schema.RecordMapper;
import com.datastax.oss.dsbulk.workflow.commons.settings.RowType;
import com.datastax.oss.dsbulk.workflow.commons.settings.SchemaGenerationStrategy;
import com.datastax.oss.dsbulk.workflow.commons.settings.StatsSettings;
import com.datastax.oss.dsbulk.workflow.commons.utils.GraphUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URI;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaSettings.class);
    private static final String NULL_TO_UNSET = "nullToUnset";
    private static final String KEYSPACE = "keyspace";
    private static final String GRAPH = "graph";
    private static final String TABLE = "table";
    private static final String VERTEX = "vertex";
    private static final String EDGE = "edge";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String MAPPING = "mapping";
    private static final String ALLOW_EXTRA_FIELDS = "allowExtraFields";
    private static final String ALLOW_MISSING_FIELDS = "allowMissingFields";
    private static final String QUERY = "query";
    private static final String QUERY_TTL = "queryTtl";
    private static final String QUERY_TIMESTAMP = "queryTimestamp";
    private static final String PRESERVE_TIMESTAMP = "preserveTimestamp";
    private static final String PRESERVE_TTL = "preserveTtl";
    private static final String CORE = "Core";
    private static final String SPLITS = "splits";
    private static final Predicate<FunctionCall> WRITETIME_OR_TTL = fc -> fc.getFunctionName().equals((Object)MappingInspector.WRITETIME) || fc.getFunctionName().equals((Object)MappingInspector.TTL);
    private final Config config;
    private final SchemaGenerationStrategy schemaGenerationStrategy;
    private boolean nullToUnset;
    private boolean allowExtraFields;
    private boolean allowMissingFields;
    private int splits;
    private MappingInspector mapping;
    private int ttlSeconds;
    private long timestampMicros;
    private boolean preserveTimestamp;
    private boolean preserveTtl;
    private RelationMetadata table;
    private KeyspaceMetadata keyspace;
    private CQLWord keyspaceName;
    private CQLWord tableName;
    private String query;
    private QueryInspector queryInspector;
    private PreparedStatement preparedStatement;
    private MappingPreference mappingPreference;

    public SchemaSettings(Config config, SchemaGenerationStrategy schemaGenerationStrategy) {
        this.config = config;
        this.schemaGenerationStrategy = schemaGenerationStrategy;
    }

    public void init(CqlSession session, boolean indexedMappingSupported, boolean mappedMappingSupported) {
        try {
            if (this.config.hasPath(KEYSPACE) && this.config.hasPath(GRAPH)) {
                throw new IllegalArgumentException("Settings schema.keyspace and schema.graph are mutually exclusive");
            }
            if (this.config.hasPath(TABLE) && this.config.hasPath(VERTEX)) {
                throw new IllegalArgumentException("Settings schema.table and schema.vertex are mutually exclusive");
            }
            if (this.config.hasPath(TABLE) && this.config.hasPath(EDGE)) {
                throw new IllegalArgumentException("Settings schema.table and schema.edge are mutually exclusive");
            }
            if (this.config.hasPath(VERTEX) && this.config.hasPath(EDGE)) {
                throw new IllegalArgumentException("Settings schema.vertex and schema.edge are mutually exclusive");
            }
            if (this.config.hasPath(EDGE)) {
                if (!this.config.hasPath(FROM)) {
                    throw new IllegalArgumentException("Setting schema.from is required when schema.edge is specified");
                }
                if (!this.config.hasPath(TO)) {
                    throw new IllegalArgumentException("Setting schema.to is required when schema.edge is specified");
                }
            }
            if (this.config.hasPath(QUERY) && (this.config.hasPath(TABLE) || this.config.hasPath(VERTEX) || this.config.hasPath(EDGE))) {
                throw new IllegalArgumentException("Setting schema.query must not be defined if schema.table, schema.vertex or schema.edge are defined");
            }
            if (!this.config.hasPath(KEYSPACE) && !this.config.hasPath(GRAPH) && (this.config.hasPath(TABLE) || this.config.hasPath(VERTEX) || this.config.hasPath(EDGE))) {
                throw new IllegalArgumentException("Settings schema.keyspace or schema.graph must be defined if schema.table, schema.vertex or schema.edge are defined");
            }
            if (this.config.hasPath(KEYSPACE)) {
                this.keyspace = this.locateKeyspace(session.getMetadata(), this.config.getString(KEYSPACE));
            } else if (this.config.hasPath(GRAPH)) {
                this.keyspace = this.locateKeyspace(session.getMetadata(), this.config.getString(GRAPH));
            }
            if (this.keyspace != null) {
                if (this.config.hasPath(TABLE)) {
                    this.table = this.locateTable(this.keyspace, this.config.getString(TABLE));
                } else if (this.config.hasPath(VERTEX)) {
                    this.table = this.locateVertexTable(this.keyspace, this.config.getString(VERTEX));
                } else if (this.config.hasPath(EDGE)) {
                    this.table = this.locateEdgeTable(this.keyspace, this.config.getString(EDGE), this.config.getString(FROM), this.config.getString(TO));
                }
            }
            this.ttlSeconds = this.config.getInt(QUERY_TTL);
            if (this.config.hasPath(QUERY_TIMESTAMP)) {
                String timestampStr = this.config.getString(QUERY_TIMESTAMP);
                try {
                    Instant instant = ZonedDateTime.parse(timestampStr).toInstant();
                    this.timestampMicros = CodecUtils.instantToNumber((Instant)instant, (TimeUnit)TimeUnit.MICROSECONDS, (Instant)Instant.EPOCH);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Expecting schema.queryTimestamp to be in ISO_ZONED_DATE_TIME format but got '%s'", timestampStr));
                }
            } else {
                this.timestampMicros = -1L;
            }
            this.preserveTimestamp = this.config.getBoolean(PRESERVE_TIMESTAMP);
            this.preserveTtl = this.config.getBoolean(PRESERVE_TTL);
            if (this.config.hasPath(QUERY)) {
                this.query = this.config.getString(QUERY);
                this.queryInspector = new QueryInspector(this.query);
                if (this.queryInspector.getKeyspaceName().isPresent()) {
                    if (this.keyspace != null) {
                        throw new IllegalArgumentException("Setting schema.keyspace must not be provided when schema.query contains a keyspace-qualified statement");
                    }
                    CQLWord keyspaceName = this.queryInspector.getKeyspaceName().get();
                    this.keyspace = session.getMetadata().getKeyspace(keyspaceName.asIdentifier()).orElse(null);
                    if (this.keyspace == null) {
                        throw new IllegalArgumentException(String.format("Value for schema.query references a non-existent keyspace: %s", keyspaceName.render(CQLRenderMode.VARIABLE)));
                    }
                } else if (this.keyspace == null) {
                    throw new IllegalArgumentException("Setting schema.keyspace must be provided when schema.query does not contain a keyspace-qualified statement");
                }
                CQLWord tableName = this.queryInspector.getTableName();
                this.table = this.keyspace.getTable(tableName.asIdentifier()).orElse(null);
                if (this.table == null) {
                    this.table = this.keyspace.getView(tableName.asIdentifier()).orElse(null);
                    if (this.table == null) {
                        throw new IllegalArgumentException(String.format("Value for schema.query references a non-existent table or materialized view: %s", tableName.render(CQLRenderMode.VARIABLE)));
                    }
                }
                if (this.timestampMicros != -1L || this.ttlSeconds != -1) {
                    throw new IllegalArgumentException("Setting schema.query must not be defined if schema.queryTtl or schema.queryTimestamp is defined");
                }
            } else if (this.keyspace == null || this.table == null) {
                throw new IllegalArgumentException("When schema.query is not defined, then either schema.keyspace or schema.graph must be defined, and either schema.table, schema.vertex or schema.edge must be defined");
            }
            assert (this.keyspace != null);
            assert (this.table != null);
            this.keyspaceName = CQLWord.fromCqlIdentifier((CqlIdentifier)this.keyspace.getName());
            this.tableName = CQLWord.fromCqlIdentifier((CqlIdentifier)this.table.getName());
            if (indexedMappingSupported && mappedMappingSupported) {
                this.mappingPreference = MappingPreference.MAPPED_OR_INDEXED;
            } else if (indexedMappingSupported) {
                this.mappingPreference = MappingPreference.INDEXED_ONLY;
            } else if (mappedMappingSupported) {
                this.mappingPreference = MappingPreference.MAPPED_ONLY;
            } else if (this.schemaGenerationStrategy.isMapping()) {
                throw new IllegalArgumentException("Connector must support at least one of indexed or mapped mappings");
            }
            if (this.config.hasPath(MAPPING)) {
                MappingInspector mapping;
                if (!this.schemaGenerationStrategy.isMapping()) {
                    throw new IllegalArgumentException("Setting schema.mapping must not be defined when counting rows in a table");
                }
                Supplier<CQLWord> usingTimestampVariable = null;
                Supplier<CQLWord> usingTTLVariable = null;
                if (this.queryInspector != null) {
                    usingTimestampVariable = this.queryInspector.getUsingTimestampVariable()::get;
                    usingTTLVariable = this.queryInspector.getUsingTTLVariable()::get;
                }
                this.mapping = mapping = new MappingInspector(this.config.getString(MAPPING), this.schemaGenerationStrategy.isWriting(), this.mappingPreference, usingTimestampVariable, usingTTLVariable);
                ImmutableSet fields = mapping.getExplicitMappings().keySet();
                ImmutableCollection variables = mapping.getExplicitMappings().values();
                if (this.schemaGenerationStrategy.isWriting()) {
                    if (SchemaSettings.containsFunctionCalls(variables, WRITETIME_OR_TTL.negate())) {
                        throw new IllegalArgumentException("Misplaced function call detected on the right side of a mapping entry; please review your schema.mapping setting");
                    }
                    if (this.query != null && SchemaSettings.containsFunctionCalls(variables, WRITETIME_OR_TTL)) {
                        throw new IllegalArgumentException("Setting schema.query must not be defined when loading if schema.mapping contains a writetime or ttl function on the right side of a mapping entry");
                    }
                    if (this.query != null && SchemaSettings.containsFunctionCalls(fields)) {
                        throw new IllegalArgumentException("Setting schema.query must not be defined when loading if schema.mapping contains a function on the left side of a mapping entry");
                    }
                }
                if (this.schemaGenerationStrategy.isReading()) {
                    if (SchemaSettings.containsFunctionCalls(fields)) {
                        throw new IllegalArgumentException("Misplaced function call detected on the left side of a mapping entry; please review your schema.mapping setting");
                    }
                    if (this.query != null && SchemaSettings.containsFunctionCalls(variables)) {
                        throw new IllegalArgumentException("Setting schema.query must not be defined when unloading if schema.mapping contains a function on the right side of a mapping entry");
                    }
                }
            } else {
                this.mapping = new MappingInspector("*=*", this.schemaGenerationStrategy.isWriting(), this.mappingPreference);
            }
            this.nullToUnset = this.config.getBoolean(NULL_TO_UNSET);
            this.allowExtraFields = this.config.getBoolean(ALLOW_EXTRA_FIELDS);
            this.allowMissingFields = this.config.getBoolean(ALLOW_MISSING_FIELDS);
            this.splits = ConfigUtils.getThreads((Config)this.config, (String)SPLITS);
            if (SchemaSettings.hasGraphOptions(this.config)) {
                GraphUtils.checkGraphCompatibility((Session)session);
                if (!SchemaSettings.isGraph(this.keyspace)) {
                    throw new IllegalStateException("Graph operations requested but provided keyspace is not a graph: " + this.keyspaceName);
                }
                if (!SchemaSettings.isSupportedGraph(this.keyspace)) {
                    assert (((DseGraphKeyspaceMetadata)this.keyspace).getGraphEngine().isPresent());
                    throw new IllegalStateException(String.format("Graph operations requested but provided graph %s was created with an unsupported graph engine: %s", this.keyspaceName, ((DseGraphKeyspaceMetadata)this.keyspace).getGraphEngine().get()));
                }
            } else if (SchemaSettings.isGraph(this.keyspace)) {
                if (SchemaSettings.isSupportedGraph(this.keyspace)) {
                    if (this.config.hasPath(KEYSPACE) || this.config.hasPath(TABLE)) {
                        LOGGER.warn("Provided keyspace is a graph; instead of schema.keyspace and schema.table, please use graph-specific options such as schema.graph, schema.vertex, schema.edge, schema.from and schema.to.");
                    }
                } else if (this.schemaGenerationStrategy == SchemaGenerationStrategy.MAP_AND_WRITE) {
                    LOGGER.warn("Provided keyspace is a graph created with a legacy graph engine: " + (String)((DseGraphKeyspaceMetadata)this.keyspace).getGraphEngine().get() + "; attempting to load data into such a keyspace is not supported and may put the graph in an inconsistent state.");
                }
            }
        }
        catch (ConfigException e) {
            throw ConfigUtils.convertConfigException((ConfigException)e, (String)"dsbulk.schema");
        }
    }

    public RecordMapper createRecordMapper(CqlSession session, RecordMetadata recordMetadata, ConvertingCodecFactory codecFactory) throws IllegalArgumentException {
        if (!this.schemaGenerationStrategy.isWriting() || !this.schemaGenerationStrategy.isMapping()) {
            throw new IllegalStateException("Cannot create record mapper when schema generation strategy is " + (Object)((Object)this.schemaGenerationStrategy));
        }
        Mapping mapping = this.prepareStatementAndCreateMapping(session, codecFactory, EnumSet.noneOf(StatsSettings.StatisticsMode.class));
        ProtocolVersion protocolVersion = session.getContext().getProtocolVersion();
        if (protocolVersion.getCode() < DefaultProtocolVersion.V4.getCode() && this.nullToUnset) {
            LOGGER.warn(String.format("Protocol version in use (%s) does not support unset bound variables; forcing schema.nullToUnset to false", protocolVersion));
            this.nullToUnset = false;
        }
        return new DefaultRecordMapper(this.preparedStatement, this.partitionKeyVariables(), this.mutatesOnlyStaticColumns() ? Collections.emptySet() : this.clusteringColumnVariables(), protocolVersion, mapping, recordMetadata, this.nullToUnset, this.allowExtraFields, this.allowMissingFields);
    }

    public ReadResultMapper createReadResultMapper(CqlSession session, RecordMetadata recordMetadata, ConvertingCodecFactory codecFactory, boolean retainRecordSources) {
        if (!this.schemaGenerationStrategy.isReading() || !this.schemaGenerationStrategy.isMapping()) {
            throw new IllegalStateException("Cannot create read result mapper when schema generation strategy is " + (Object)((Object)this.schemaGenerationStrategy));
        }
        Mapping mapping = this.prepareStatementAndCreateMapping(session, codecFactory, EnumSet.noneOf(StatsSettings.StatisticsMode.class));
        return new DefaultReadResultMapper(mapping, recordMetadata, this.getTargetTableURI(), retainRecordSources);
    }

    public ReadResultCounter createReadResultCounter(CqlSession session, ConvertingCodecFactory codecFactory, EnumSet<StatsSettings.StatisticsMode> modes, int numPartitions) {
        if (!this.schemaGenerationStrategy.isReading() || !this.schemaGenerationStrategy.isCounting()) {
            throw new IllegalStateException("Cannot create read result counter when schema generation strategy is " + (Object)((Object)this.schemaGenerationStrategy));
        }
        this.prepareStatementAndCreateMapping(session, null, modes);
        if (modes.contains((Object)StatsSettings.StatisticsMode.partitions) && this.table.getClusteringColumns().isEmpty()) {
            throw new IllegalArgumentException(String.format("Cannot count partitions for table %s: it has no clustering column.", this.tableName.render(CQLRenderMode.VARIABLE)));
        }
        return new DefaultReadResultCounter(this.keyspace.getName(), session.getMetadata(), modes, numPartitions, session.getContext().getProtocolVersion(), codecFactory);
    }

    public List<Statement<?>> createReadStatements(CqlSession session) {
        ColumnDefinitions variables = this.preparedStatement.getVariableDefinitions();
        if (variables.size() == 0) {
            return Collections.singletonList(this.preparedStatement.bind(new Object[0]));
        }
        boolean ok = true;
        Optional<CQLWord> start = this.queryInspector.getTokenRangeRestrictionStartVariable();
        Optional<CQLWord> end = this.queryInspector.getTokenRangeRestrictionEndVariable();
        if (!start.isPresent() || !end.isPresent()) {
            ok = false;
        }
        if (start.isPresent() && end.isPresent()) {
            Optional<CQLWord> unrecognized = StreamSupport.stream(variables.spliterator(), false).map(columnDefinition -> columnDefinition.getName().asInternal()).map(CQLWord::fromInternal).filter(name -> !name.equals(start.get()) && !name.equals(end.get())).findAny();
            boolean bl = ok = !unrecognized.isPresent();
        }
        if (!ok) {
            throw new IllegalArgumentException("The provided statement (schema.query) contains unrecognized WHERE restrictions; the WHERE clause is only allowed to contain one token range restriction of the form: WHERE token(...) > ? AND token(...) <= ?");
        }
        Metadata metadata = session.getMetadata();
        TokenRangeReadStatementGenerator generator = new TokenRangeReadStatementGenerator(this.table, metadata);
        List statements = generator.generate(this.splits, range -> (BoundStatement)((BoundStatement)this.preparedStatement.bind(new Object[0]).setToken(this.queryInspector.getTokenRangeRestrictionStartVariableIndex(), range.getStart())).setToken(this.queryInspector.getTokenRangeRestrictionEndVariableIndex(), range.getEnd()));
        LOGGER.debug("Generated {} bound statements", (Object)statements.size());
        Collections.shuffle(statements);
        return statements;
    }

    @NonNull
    public RowType getRowType() {
        DseGraphTableMetadata mtable;
        boolean isTable = this.table instanceof DseTableMetadata;
        DseGraphTableMetadata dseGraphTableMetadata = mtable = isTable ? (DseGraphTableMetadata)this.table : null;
        if (isTable && mtable.getVertex().isPresent()) {
            return RowType.VERTEX;
        }
        if (isTable && mtable.getEdge().isPresent()) {
            return RowType.EDGE;
        }
        return RowType.REGULAR;
    }

    @NonNull
    public RelationMetadata getTargetTable() {
        return Objects.requireNonNull(this.table, "Cannot call this method before init()");
    }

    @NonNull
    @VisibleForTesting
    URI getTargetTableURI() {
        return URI.create("cql://" + this.keyspace.getName().asInternal() + '/' + this.table.getName().asInternal());
    }

    public boolean isAllowExtraFields() {
        return this.allowExtraFields;
    }

    public boolean isAllowMissingFields() {
        return this.allowMissingFields;
    }

    public boolean isSearchQuery() {
        return this.queryInspector.hasSearchClause();
    }

    public boolean isBatchQuery() {
        return this.queryInspector.isBatch();
    }

    @NonNull
    private Mapping prepareStatementAndCreateMapping(CqlSession session, ConvertingCodecFactory codecFactory, EnumSet<StatsSettings.StatisticsMode> modes) {
        ImmutableMultimap<MappingField, CQLFragment> fieldsToVariables = null;
        if (!this.config.hasPath(QUERY)) {
            List<CQLFragment> columns = this.table.getColumns().values().stream().filter(col -> !this.isDSESearchPseudoColumn((ColumnMetadata)col)).flatMap(column -> {
                CQLWord colName = CQLWord.fromCqlIdentifier((CqlIdentifier)column.getName());
                ArrayList cols = Lists.newArrayList((Object[])new CQLFragment[]{colName});
                if (!this.isCounterTable() && this.schemaGenerationStrategy.isMapping() && !this.table.getPrimaryKey().contains(column)) {
                    if (this.preserveTimestamp) {
                        cols.add(new FunctionCall(null, MappingInspector.WRITETIME, new CQLFragment[]{colName}));
                    }
                    if (this.preserveTtl) {
                        cols.add(new FunctionCall(null, MappingInspector.TTL, new CQLFragment[]{colName}));
                    }
                }
                return cols.stream();
            }).collect(Collectors.toList());
            fieldsToVariables = this.createFieldsToVariablesMap(columns);
            if (this.schemaGenerationStrategy.isWriting()) {
                this.query = this.isCounterTable() ? this.inferUpdateCounterQuery(fieldsToVariables) : (SchemaSettings.requiresBatchInsertQuery(fieldsToVariables) ? this.inferBatchInsertQuery(fieldsToVariables) : this.inferInsertQuery(fieldsToVariables));
            } else if (this.schemaGenerationStrategy.isReading() && this.schemaGenerationStrategy.isMapping()) {
                this.query = this.inferReadQuery(fieldsToVariables);
            } else if (this.schemaGenerationStrategy.isReading() && this.schemaGenerationStrategy.isCounting()) {
                this.query = this.inferCountQuery(modes);
            } else {
                throw new IllegalStateException("Unsupported schema generation strategy: " + (Object)((Object)this.schemaGenerationStrategy));
            }
            LOGGER.debug("Inferred query: {}", (Object)this.query);
            this.queryInspector = new QueryInspector(this.query);
            if (this.schemaGenerationStrategy.isWriting()) {
                this.validatePrimaryKeyPresent(fieldsToVariables);
            }
        }
        assert (this.query != null);
        assert (this.queryInspector != null);
        if (!this.queryInspector.getKeyspaceName().isPresent()) {
            session.execute("USE " + this.keyspaceName);
        }
        if (this.config.hasPath(QUERY)) {
            if (this.schemaGenerationStrategy.isReading() && this.queryInspector.isParallelizable()) {
                int whereClauseIndex = this.queryInspector.getFromClauseEndIndex() + 1;
                StringBuilder sb = new StringBuilder(this.query.substring(0, whereClauseIndex));
                this.appendTokenRangeRestriction(sb);
                this.query = sb.append(this.query.substring(whereClauseIndex)).toString();
            }
            if (this.schemaGenerationStrategy.isCounting()) {
                if (modes.contains((Object)StatsSettings.StatisticsMode.partitions) || modes.contains((Object)StatsSettings.StatisticsMode.ranges) || modes.contains((Object)StatsSettings.StatisticsMode.hosts)) {
                    throw new IllegalArgumentException(String.format("Cannot count with stats.modes = %s when schema.query is provided; only stats.modes = [global] is allowed", modes));
                }
                StringBuilder sb = new StringBuilder("SELECT ");
                sb.append(this.getGlobalCountSelector());
                this.query = sb.append(' ').append(this.query.substring(this.queryInspector.getFromClauseStartIndex())).toString();
            }
            this.queryInspector = new QueryInspector(this.query);
        }
        this.preparedStatement = session.prepare(this.query);
        if (this.config.hasPath(QUERY)) {
            ColumnDefinitions variables = this.getVariables();
            fieldsToVariables = this.createFieldsToVariablesMap(StreamSupport.stream(variables.spliterator(), false).map(columnDefinition -> columnDefinition.getName().asInternal()).map(CQLWord::fromInternal).collect(Collectors.toList()));
            if (this.schemaGenerationStrategy.isWriting()) {
                if (this.mutatesOnlyStaticColumns()) {
                    this.validatePartitionKeyPresent(fieldsToVariables);
                } else {
                    this.validatePrimaryKeyPresent(fieldsToVariables);
                }
            }
        }
        assert (fieldsToVariables != null);
        return new DefaultMapping(SchemaSettings.transformFieldsToVariables(fieldsToVariables), codecFactory, SchemaSettings.transformWriteTimeVariables(this.queryInspector.getWriteTimeVariables()));
    }

    private boolean isDSESearchPseudoColumn(ColumnMetadata col) {
        return col.getName().asInternal().equals("solr_query") && col.getType() == DataTypes.TEXT && this.tableHasDSESearchIndex();
    }

    private boolean tableHasDSESearchIndex() {
        if (this.table instanceof TableMetadata) {
            for (IndexMetadata index : ((TableMetadata)this.table).getIndexes().values()) {
                if (!"com.datastax.bdp.search.solr.Cql3SolrSecondaryIndex".equals(index.getClassName().orElse(null))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCounterTable() {
        return this.table.getColumns().values().stream().anyMatch(c -> c.getType().equals(DataTypes.COUNTER));
    }

    private ColumnDefinitions getVariables() {
        if (this.schemaGenerationStrategy.isWriting()) {
            return this.preparedStatement.getVariableDefinitions();
        }
        assert (this.schemaGenerationStrategy.isReading());
        return this.preparedStatement.getResultSetDefinitions();
    }

    private ImmutableMultimap<MappingField, CQLFragment> createFieldsToVariablesMap(Collection<CQLFragment> columnsOrVariables) throws IllegalArgumentException {
        ImmutableMultimap fieldsToVariables = this.mapping.isInferring() ? this.inferFieldsToVariablesMap(columnsOrVariables) : ImmutableMultimap.of();
        ImmutableMultimap explicitMappings = this.mapping.getExplicitMappings();
        if (!explicitMappings.isEmpty()) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (Map.Entry entry : explicitMappings.entries()) {
                builder.put((Object)((MappingField)entry.getKey()), (Object)((CQLFragment)entry.getValue()));
            }
            for (Map.Entry entry : fieldsToVariables.entries()) {
                if (explicitMappings.containsKey(entry.getKey()) || explicitMappings.containsValue(entry.getValue())) continue;
                builder.put((Object)((MappingField)entry.getKey()), (Object)((CQLFragment)entry.getValue()));
            }
            fieldsToVariables = builder.build();
        }
        Preconditions.checkState((!fieldsToVariables.isEmpty() ? 1 : 0) != 0, (Object)"Mapping was absent and could not be inferred, please provide an explicit mapping");
        this.validateAllFieldsPresent(fieldsToVariables, columnsOrVariables);
        return fieldsToVariables;
    }

    private KeyspaceMetadata locateKeyspace(Metadata metadata, String keyspaceNameInternal) {
        CqlIdentifier keyspaceName = CqlIdentifier.fromInternal((String)keyspaceNameInternal);
        KeyspaceMetadata keyspace = metadata.getKeyspace(keyspaceName).orElse(null);
        if (keyspace == null) {
            Optional<KeyspaceMetadata> match = metadata.getKeyspaces().values().stream().filter(k -> k.getName().asInternal().equalsIgnoreCase(keyspaceNameInternal)).findFirst();
            if (match.isPresent()) {
                String similarName = match.get().getName().asCql(true);
                throw new IllegalArgumentException(String.format("Keyspace %s does not exist, however a keyspace %s was found. Did you mean to use -k %s?", keyspaceName.asCql(true), similarName, similarName));
            }
            throw new IllegalArgumentException(String.format("Keyspace %s does not exist", keyspaceName.asCql(true)));
        }
        return keyspace;
    }

    @NonNull
    private RelationMetadata locateTable(KeyspaceMetadata keyspace, String tableNameInternal) {
        CqlIdentifier tableName = CqlIdentifier.fromInternal((String)tableNameInternal);
        RelationMetadata table = keyspace.getTable(tableName).orElse(null);
        if (table == null) {
            if (this.schemaGenerationStrategy.isReading()) {
                table = keyspace.getView(tableName).orElse(null);
                if (table == null) {
                    Optional<ViewMetadata> match = keyspace.getViews().values().stream().filter(t -> t.getName().asInternal().equalsIgnoreCase(tableNameInternal)).findFirst();
                    if (match.isPresent()) {
                        String similarName = match.get().getName().asCql(true);
                        throw new IllegalArgumentException(String.format("Table or materialized view %s does not exist, however a materialized view %s was found. Did you mean to use -t %s?", tableName.asCql(true), similarName, similarName));
                    }
                    throw new IllegalArgumentException(String.format("Table or materialized view %s does not exist", tableName.asCql(true)));
                }
            } else {
                Optional<TableMetadata> match = keyspace.getTables().values().stream().filter(t -> t.getName().asInternal().equalsIgnoreCase(tableNameInternal)).findFirst();
                if (match.isPresent()) {
                    String similarName = match.get().getName().asCql(true);
                    throw new IllegalArgumentException(String.format("Table %s does not exist, however a table %s was found. Did you mean to use -t %s?", tableName.asCql(true), similarName, similarName));
                }
                throw new IllegalArgumentException(String.format("Table %s does not exist", tableName.asCql(true)));
            }
        }
        return table;
    }

    @NonNull
    private TableMetadata locateVertexTable(KeyspaceMetadata keyspace, String vertexLabelInternal) {
        CqlIdentifier vertexLabel = CqlIdentifier.fromInternal((String)vertexLabelInternal);
        Optional<DseGraphTableMetadata> vertex = SchemaSettings.allVertexTables(keyspace).filter(table -> ((DseVertexMetadata)table.getVertex().get()).getLabelName().equals((Object)vertexLabel)).findFirst();
        if (!vertex.isPresent()) {
            Optional<DseVertexMetadata> match = SchemaSettings.allVertexTables(keyspace).filter(table -> ((DseVertexMetadata)table.getVertex().get()).getLabelName().asInternal().equalsIgnoreCase(vertexLabelInternal)).map(t -> (DseVertexMetadata)t.getVertex().get()).findFirst();
            if (match.isPresent()) {
                String similarName = match.get().getLabelName().asCql(true);
                throw new IllegalArgumentException(String.format("Vertex label %s does not exist, however a vertex label %s was found. Did you mean to use -v %s?", vertexLabel.asCql(true), similarName, similarName));
            }
            throw new IllegalArgumentException(String.format("Vertex label %s does not exist", vertexLabel.asCql(true)));
        }
        return (TableMetadata)vertex.get();
    }

    @NonNull
    private TableMetadata locateEdgeTable(KeyspaceMetadata keyspace, String edgeLabelInternal, String fromVertexInternal, String toVertexInternal) {
        CqlIdentifier edgeLabel = CqlIdentifier.fromInternal((String)edgeLabelInternal);
        CqlIdentifier fromVertex = CqlIdentifier.fromInternal((String)fromVertexInternal);
        CqlIdentifier toVertex = CqlIdentifier.fromInternal((String)toVertexInternal);
        Optional<DseGraphTableMetadata> edge = SchemaSettings.allEdgeTables(keyspace).filter(table -> ((DseEdgeMetadata)table.getEdge().get()).getLabelName().equals((Object)edgeLabel)).filter(table -> ((DseEdgeMetadata)table.getEdge().get()).getFromLabel().equals((Object)fromVertex)).filter(table -> ((DseEdgeMetadata)table.getEdge().get()).getToLabel().equals((Object)toVertex)).findFirst();
        if (!edge.isPresent()) {
            Optional<DseEdgeMetadata> match = SchemaSettings.allEdgeTables(keyspace).map(DseGraphTableMetadata::getEdge).filter(e -> ((DseEdgeMetadata)e.get()).getLabelName().asInternal().equalsIgnoreCase(edgeLabelInternal)).filter(e -> ((DseEdgeMetadata)e.get()).getFromLabel().asInternal().equalsIgnoreCase(fromVertexInternal)).filter(e -> ((DseEdgeMetadata)e.get()).getToLabel().asInternal().equalsIgnoreCase(toVertexInternal)).map(Optional::get).findFirst();
            if (match.isPresent()) {
                DseEdgeMetadata edgeMetadata = match.get();
                String similarLabel = edgeMetadata.getLabelName().asCql(true);
                String similarFrom = edgeMetadata.getFromLabel().asCql(true);
                String similarTo = edgeMetadata.getToLabel().asCql(true);
                throw new IllegalArgumentException(String.format("Edge label %s from %s to %s does not exist, however an edge label %s from %s to %s was found. Did you mean to use -e %s -from %s -to %s?", edgeLabel.asCql(true), fromVertex.asCql(true), toVertex.asCql(true), similarLabel, similarFrom, similarTo, similarLabel, similarFrom, similarTo));
            }
            throw new IllegalArgumentException(String.format("Edge label %s from %s to %s does not exist", edgeLabel.asCql(true), fromVertex.asCql(true), toVertex.asCql(true)));
        }
        return (TableMetadata)edge.get();
    }

    @NonNull
    private static Stream<DseGraphTableMetadata> allVertexTables(KeyspaceMetadata keyspace) {
        return keyspace.getTables().values().stream().filter(DseGraphTableMetadata.class::isInstance).map(DseGraphTableMetadata.class::cast).filter(dseTableMetadata -> dseTableMetadata.getVertex().isPresent());
    }

    @NonNull
    private static Stream<DseGraphTableMetadata> allEdgeTables(KeyspaceMetadata keyspace) {
        return keyspace.getTables().values().stream().filter(DseGraphTableMetadata.class::isInstance).map(DseGraphTableMetadata.class::cast).filter(dseTableMetadata -> dseTableMetadata.getEdge().isPresent());
    }

    private void validateAllFieldsPresent(ImmutableMultimap<MappingField, CQLFragment> fieldsToVariables, Collection<CQLFragment> columns) {
        fieldsToVariables.forEach((key, value) -> {
            if (value instanceof CQLWord && !columns.contains(value)) {
                if (!this.config.hasPath(QUERY)) {
                    throw new IllegalArgumentException(String.format("Schema mapping entry %s doesn't match any column found in table %s", value.render(CQLRenderMode.VARIABLE), this.tableName.render(CQLRenderMode.VARIABLE)));
                }
                assert (this.query != null);
                throw new IllegalArgumentException(String.format("Schema mapping entry %s doesn't match any bound variable found in query: '%s'", value.render(CQLRenderMode.VARIABLE), this.query));
            }
        });
    }

    private boolean mutatesOnlyStaticColumns() {
        assert (!this.queryInspector.getAssignments().isEmpty());
        for (CQLWord column : this.queryInspector.getAssignments().keySet()) {
            ColumnMetadata col = (ColumnMetadata)this.table.getColumn(column.asIdentifier()).orElseThrow(() -> new IllegalStateException("Column does not exist: " + column));
            if (this.table.getPartitionKey().contains(col) || col.isStatic()) continue;
            return false;
        }
        return true;
    }

    private void validatePrimaryKeyPresent(ImmutableMultimap<MappingField, CQLFragment> fieldsToVariables) {
        this.validateKeyPresent(fieldsToVariables, this.table.getPrimaryKey());
    }

    private void validatePartitionKeyPresent(ImmutableMultimap<MappingField, CQLFragment> fieldsToVariables) {
        this.validateKeyPresent(fieldsToVariables, this.table.getPartitionKey());
    }

    private void validateKeyPresent(ImmutableMultimap<MappingField, CQLFragment> fieldsToVariables, List<ColumnMetadata> columns) {
        ImmutableCollection mappingVariables = fieldsToVariables.values();
        ImmutableMap<CQLWord, CQLFragment> queryVariables = this.queryInspector.getAssignments();
        for (ColumnMetadata pk : columns) {
            CQLWord pkVariable = CQLWord.fromCqlIdentifier((CqlIdentifier)pk.getName());
            CQLFragment queryVariable = (CQLFragment)queryVariables.get(pkVariable);
            if (queryVariable == null) {
                throw new IllegalArgumentException("Missing required primary key column " + pkVariable.render(CQLRenderMode.VARIABLE) + " from schema.mapping or schema.query");
            }
            if (!(queryVariable instanceof CQLWord) || mappingVariables.contains(queryVariable)) continue;
            throw new IllegalArgumentException("Missing required primary key column " + pkVariable.render(CQLRenderMode.VARIABLE) + " from schema.mapping");
        }
    }

    private ImmutableMultimap<MappingField, CQLFragment> inferFieldsToVariablesMap(Collection<CQLFragment> columns) {
        ImmutableMultimap.Builder fieldsToVariables = ImmutableMultimap.builder();
        ArrayList<FunctionCall> excludedVariables = new ArrayList<FunctionCall>(this.mapping.getExcludedVariables());
        if (!this.isCounterTable() && this.schemaGenerationStrategy.isMapping()) {
            for (CQLWord variable : this.mapping.getExcludedVariables()) {
                if (this.preserveTimestamp) {
                    excludedVariables.add(new FunctionCall(null, MappingInspector.WRITETIME, new CQLFragment[]{variable}));
                }
                if (!this.preserveTtl) continue;
                excludedVariables.add(new FunctionCall(null, MappingInspector.TTL, new CQLFragment[]{variable}));
            }
        }
        int i = 0;
        for (CQLFragment colName : columns) {
            if (!excludedVariables.contains(colName)) {
                if (this.mappingPreference == MappingPreference.INDEXED_ONLY) {
                    fieldsToVariables.put((Object)new IndexedMappingField(i), (Object)colName);
                } else {
                    fieldsToVariables.put((Object)new MappedMappingField(colName.render(CQLRenderMode.INTERNAL)), (Object)colName);
                }
            }
            ++i;
        }
        return fieldsToVariables.build();
    }

    private String inferInsertQuery(ImmutableMultimap<MappingField, CQLFragment> fieldsToVariables) {
        ImmutableMultimap.Builder regularFieldsToVariablesBuilder = ImmutableMultimap.builder();
        FunctionCall writetime = null;
        FunctionCall ttl = null;
        for (Map.Entry entry : fieldsToVariables.entries()) {
            if (entry.getValue() instanceof FunctionCall) {
                FunctionCall functionCall = (FunctionCall)entry.getValue();
                if (functionCall.getFunctionName().equals((Object)MappingInspector.WRITETIME)) {
                    assert (writetime == null);
                    writetime = functionCall;
                    continue;
                }
                if (!functionCall.getFunctionName().equals((Object)MappingInspector.TTL)) continue;
                assert (ttl == null);
                ttl = functionCall;
                continue;
            }
            regularFieldsToVariablesBuilder.put(entry);
        }
        ImmutableMultimap regularFieldsToVariables = regularFieldsToVariablesBuilder.build();
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(this.keyspaceName.render(CQLRenderMode.VARIABLE)).append('.').append(this.tableName.render(CQLRenderMode.VARIABLE)).append(" (");
        this.appendColumnNames((ImmutableMultimap<MappingField, CQLFragment>)regularFieldsToVariables, sb, CQLRenderMode.VARIABLE);
        sb.append(") VALUES (");
        Set<CQLFragment> cols = this.maybeSortCols((ImmutableMultimap<MappingField, CQLFragment>)regularFieldsToVariables);
        Iterator<CQLFragment> it = cols.iterator();
        while (it.hasNext()) {
            CQLFragment col = it.next();
            MappingField field = (MappingField)fieldsToVariables.inverse().get((Object)col).iterator().next();
            if (field instanceof FunctionCall) {
                sb.append(((FunctionCall)field).render(CQLRenderMode.NAMED_ASSIGNMENT));
            } else {
                sb.append(col.render(CQLRenderMode.NAMED_ASSIGNMENT));
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
        this.appendWriteTimeAndTTL(sb, writetime, ttl);
        return sb.toString();
    }

    private String inferBatchInsertQuery(ImmutableMultimap<MappingField, CQLFragment> fieldsToVariables) {
        List<CQLWord> pks = this.primaryKeyColumns();
        LinkedHashSet<Object> allSpecificVariables = new LinkedHashSet<Object>();
        LinkedHashMap<CQLWord, WriteTimeAndTTL> specificWriteTimesAndTTLs = new LinkedHashMap<CQLWord, WriteTimeAndTTL>();
        boolean hasGlobalWritetime = false;
        boolean hasGlobalTTL = false;
        for (CQLFragment variable2 : fieldsToVariables.values()) {
            CQLWord col;
            if (!(variable2 instanceof FunctionCall)) continue;
            FunctionCall functionCall = (FunctionCall)variable2;
            if (functionCall.getFunctionName().equals((Object)MappingInspector.WRITETIME)) {
                for (CQLFragment arg : functionCall.getArgs()) {
                    if (arg.equals(MappingInspector.STAR)) {
                        if (this.preserveTimestamp) {
                            throw new IllegalStateException("Invalid mapping: writetime(*) is not allowed when schema.preserveTimestamp is true.");
                        }
                        hasGlobalWritetime = true;
                        continue;
                    }
                    col = (CQLWord)arg;
                    if (pks.contains(col)) {
                        throw new IllegalStateException("Invalid mapping: writetime() function arg must be either '*' or a non-primary key column name.");
                    }
                    if (fieldsToVariables.containsValue((Object)col)) {
                        allSpecificVariables.add(col);
                        allSpecificVariables.add(functionCall);
                        specificWriteTimesAndTTLs.compute((CQLWord)arg, (k, v) -> {
                            if (v == null) {
                                v = new WriteTimeAndTTL();
                            }
                            ((WriteTimeAndTTL)v).writetime = functionCall;
                            return v;
                        });
                        continue;
                    }
                    throw new IllegalStateException(String.format("Invalid mapping: target column %s must be present if %s is also present.", col.render(CQLRenderMode.VARIABLE), functionCall.render(CQLRenderMode.INTERNAL)));
                }
                continue;
            }
            if (!functionCall.getFunctionName().equals((Object)MappingInspector.TTL)) continue;
            for (CQLFragment arg : functionCall.getArgs()) {
                if (arg.equals(MappingInspector.STAR)) {
                    if (this.preserveTtl) {
                        throw new IllegalStateException("Invalid mapping: ttl(*) is not allowed when schema.preserveTtl is true.");
                    }
                    hasGlobalTTL = true;
                    continue;
                }
                col = (CQLWord)arg;
                if (pks.contains(col)) {
                    throw new IllegalStateException("Invalid mapping: ttl() function arg must be either '*' or a non-primary key column name.");
                }
                if (fieldsToVariables.containsValue((Object)col)) {
                    allSpecificVariables.add(col);
                    allSpecificVariables.add(functionCall);
                    specificWriteTimesAndTTLs.compute((CQLWord)arg, (k, v) -> {
                        if (v == null) {
                            v = new WriteTimeAndTTL();
                        }
                        ((WriteTimeAndTTL)v).ttl = functionCall;
                        return v;
                    });
                    continue;
                }
                throw new IllegalStateException(String.format("Invalid mapping: target column %s must be present if %s is also present.", col.render(CQLRenderMode.VARIABLE), functionCall.render(CQLRenderMode.INTERNAL)));
            }
        }
        ImmutableMultimap.Builder defaultFieldsToVariablesBuilder = ImmutableMultimap.builder();
        for (Map.Entry entry : fieldsToVariables.entries()) {
            CQLFragment variable3 = (CQLFragment)entry.getValue();
            if (allSpecificVariables.contains(variable3)) continue;
            defaultFieldsToVariablesBuilder.put(entry);
        }
        ImmutableMultimap defaultFieldsToVariables = defaultFieldsToVariablesBuilder.build();
        boolean hasRegularColumnsWithoutSpecificWritetimeAndTTL = defaultFieldsToVariables.values().stream().filter(CQLWord.class::isInstance).map(CQLWord.class::cast).anyMatch(variable -> !pks.contains(variable));
        if (!hasRegularColumnsWithoutSpecificWritetimeAndTTL) {
            if (hasGlobalWritetime) {
                throw new IllegalStateException("Invalid mapping: writetime(*) function has no target column.");
            }
            if (hasGlobalTTL) {
                throw new IllegalStateException("Invalid mapping: ttl(*) function has no target column.");
            }
        }
        StringBuilder sb = new StringBuilder();
        if (!hasRegularColumnsWithoutSpecificWritetimeAndTTL && specificWriteTimesAndTTLs.size() == 1) {
            Map.Entry entry = specificWriteTimesAndTTLs.entrySet().iterator().next();
            this.appendBatchChildQuery(sb, (CQLWord)entry.getKey(), ((WriteTimeAndTTL)entry.getValue()).writetime, ((WriteTimeAndTTL)entry.getValue()).ttl, pks);
        } else {
            sb.append("BEGIN UNLOGGED BATCH ");
            if (hasRegularColumnsWithoutSpecificWritetimeAndTTL) {
                sb.append(this.inferInsertQuery((ImmutableMultimap<MappingField, CQLFragment>)defaultFieldsToVariables)).append("; ");
            }
            for (Map.Entry entry : specificWriteTimesAndTTLs.entrySet()) {
                this.appendBatchChildQuery(sb, (CQLWord)entry.getKey(), ((WriteTimeAndTTL)entry.getValue()).writetime, ((WriteTimeAndTTL)entry.getValue()).ttl, pks);
                sb.append("; ");
            }
            sb.append("APPLY BATCH");
        }
        return sb.toString();
    }

    private void appendBatchChildQuery(StringBuilder sb, CQLWord variable, @Nullable FunctionCall writetime, @Nullable FunctionCall ttl, List<CQLWord> pks) {
        sb.append("INSERT INTO ").append(this.keyspaceName.render(CQLRenderMode.VARIABLE)).append('.').append(this.tableName.render(CQLRenderMode.VARIABLE)).append(" (");
        for (CQLWord pk : pks) {
            sb.append(pk.render(CQLRenderMode.VARIABLE));
            sb.append(", ");
        }
        sb.append(variable.render(CQLRenderMode.VARIABLE)).append(") VALUES (");
        for (CQLWord pk : pks) {
            sb.append(pk.render(CQLRenderMode.NAMED_ASSIGNMENT));
            sb.append(", ");
        }
        sb.append(variable.render(CQLRenderMode.NAMED_ASSIGNMENT)).append(")");
        this.appendWriteTimeAndTTL(sb, writetime, ttl);
    }

    private String inferUpdateCounterQuery(ImmutableMultimap<MappingField, CQLFragment> fieldsToVariables) {
        StringBuilder sb = new StringBuilder("UPDATE ");
        sb.append(this.keyspaceName.render(CQLRenderMode.VARIABLE)).append('.').append(this.tableName.render(CQLRenderMode.VARIABLE));
        this.appendWriteTimeAndTTL(sb, null, null);
        sb.append(" SET ");
        Set<CQLFragment> cols = this.maybeSortCols(fieldsToVariables);
        Iterator<CQLFragment> colsIterator = cols.iterator();
        boolean isFirst = true;
        List<CQLWord> pks = this.primaryKeyColumns();
        while (colsIterator.hasNext()) {
            CQLFragment col = colsIterator.next();
            if (col instanceof CQLWord && pks.contains(col)) continue;
            if (col instanceof FunctionCall) {
                throw new IllegalArgumentException("Invalid mapping: function calls are not allowed when updating a counter table.");
            }
            MappingField field = (MappingField)fieldsToVariables.inverse().get((Object)col).iterator().next();
            if (field instanceof FunctionCall) {
                throw new IllegalArgumentException("Invalid mapping: function calls are not allowed when updating a counter table.");
            }
            if (!isFirst) {
                sb.append(", ");
            }
            isFirst = false;
            sb.append(col.render(CQLRenderMode.VARIABLE)).append(" = ").append(col.render(CQLRenderMode.VARIABLE)).append(" + ").append(col.render(CQLRenderMode.NAMED_ASSIGNMENT));
        }
        sb.append(" WHERE ");
        Iterator<CQLWord> pksIterator = pks.iterator();
        while (pksIterator.hasNext()) {
            CQLFragment col = (CQLFragment)pksIterator.next();
            sb.append(col.render(CQLRenderMode.VARIABLE)).append(" = ").append(col.render(CQLRenderMode.NAMED_ASSIGNMENT));
            if (!pksIterator.hasNext()) continue;
            sb.append(" AND ");
        }
        return sb.toString();
    }

    private void appendWriteTimeAndTTL(StringBuilder sb, @Nullable FunctionCall writetime, @Nullable FunctionCall ttl) {
        boolean hasTimestamp;
        boolean hasTtl = this.ttlSeconds != -1 || ttl != null;
        boolean bl = hasTimestamp = this.timestampMicros != -1L || writetime != null;
        if (hasTtl || hasTimestamp) {
            if (this.isCounterTable()) {
                throw new IllegalArgumentException("Cannot set TTL or timestamp when updating a counter table.");
            }
            sb.append(" USING ");
            if (hasTtl) {
                sb.append("TTL ");
                if (this.ttlSeconds != -1) {
                    sb.append(this.ttlSeconds);
                } else {
                    assert (ttl != null);
                    sb.append(':').append(ttl.render(CQLRenderMode.VARIABLE));
                }
                if (hasTimestamp) {
                    sb.append(" AND ");
                }
            }
            if (hasTimestamp) {
                sb.append("TIMESTAMP ");
                if (this.timestampMicros != -1L) {
                    sb.append(this.timestampMicros);
                } else {
                    assert (writetime != null);
                    sb.append(':').append(writetime.render(CQLRenderMode.VARIABLE));
                }
            }
        }
    }

    private String inferReadQuery(ImmutableMultimap<MappingField, CQLFragment> fieldsToVariables) {
        StringBuilder sb = new StringBuilder("SELECT ");
        this.appendColumnNames(fieldsToVariables, sb, CQLRenderMode.ALIASED_SELECTOR);
        sb.append(" FROM ").append(this.keyspaceName.render(CQLRenderMode.VARIABLE)).append('.').append(this.tableName.render(CQLRenderMode.VARIABLE));
        this.appendTokenRangeRestriction(sb);
        return sb.toString();
    }

    private void appendTokenRangeRestriction(StringBuilder sb) {
        sb.append(" WHERE ");
        this.appendTokenFunction(sb);
        sb.append(" > ");
        sb.append(":start");
        sb.append(" AND ");
        this.appendTokenFunction(sb);
        sb.append(" <= ");
        sb.append(":end");
    }

    private String inferCountQuery(EnumSet<StatsSettings.StatisticsMode> modes) {
        StringBuilder sb = new StringBuilder("SELECT ");
        List partitionKey = this.table.getPartitionKey();
        if (modes.contains((Object)StatsSettings.StatisticsMode.ranges) || modes.contains((Object)StatsSettings.StatisticsMode.hosts) || modes.contains((Object)StatsSettings.StatisticsMode.partitions)) {
            if (modes.contains((Object)StatsSettings.StatisticsMode.partitions)) {
                Iterator it = partitionKey.iterator();
                while (it.hasNext()) {
                    ColumnMetadata col = (ColumnMetadata)it.next();
                    sb.append(col.getName().asCql(true));
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
            } else {
                this.appendTokenFunction(sb);
            }
        } else {
            String selector = this.getGlobalCountSelector();
            sb.append(selector);
        }
        sb.append(" FROM ").append(this.keyspaceName.render(CQLRenderMode.VARIABLE)).append('.').append(this.tableName.render(CQLRenderMode.VARIABLE));
        this.appendTokenRangeRestriction(sb);
        return sb.toString();
    }

    @NonNull
    private String getGlobalCountSelector() {
        return ((ColumnMetadata)this.table.getPartitionKey().get(0)).getName().asCql(true);
    }

    @NonNull
    private List<CQLWord> primaryKeyColumns() {
        return this.table.getPrimaryKey().stream().map(ColumnMetadata::getName).map(CQLWord::fromCqlIdentifier).collect(Collectors.toList());
    }

    @NonNull
    private Set<CQLWord> partitionKeyVariables() {
        return this.columnsToVariables(this.table.getPartitionKey());
    }

    @NonNull
    private Set<CQLWord> clusteringColumnVariables() {
        return this.columnsToVariables(this.table.getClusteringColumns().keySet());
    }

    @NonNull
    private Set<CQLWord> columnsToVariables(Collection<ColumnMetadata> columns) {
        ImmutableMap<CQLWord, CQLFragment> boundVariables = this.queryInspector.getAssignments();
        HashSet<CQLWord> variables = new HashSet<CQLWord>(columns.size());
        for (ColumnMetadata column : columns) {
            CQLFragment variable = (CQLFragment)boundVariables.get(CQLWord.fromCqlIdentifier((CqlIdentifier)column.getName()));
            if (!(variable instanceof CQLWord)) continue;
            variables.add((CQLWord)variable);
        }
        return variables;
    }

    private void appendColumnNames(ImmutableMultimap<MappingField, CQLFragment> fieldsToVariables, StringBuilder sb, CQLRenderMode mode) {
        Set<CQLFragment> cols = this.maybeSortCols(fieldsToVariables);
        Iterator<CQLFragment> it = cols.iterator();
        while (it.hasNext()) {
            CQLFragment col = it.next();
            sb.append(col.render(mode));
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
    }

    private void appendTokenFunction(StringBuilder sb) {
        List partitionKey = this.table.getPartitionKey();
        sb.append("token(");
        Iterator pks = partitionKey.iterator();
        while (pks.hasNext()) {
            ColumnMetadata pk = (ColumnMetadata)pks.next();
            sb.append(pk.getName().asCql(true));
            if (!pks.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
    }

    @NonNull
    private Set<CQLFragment> maybeSortCols(ImmutableMultimap<MappingField, CQLFragment> fieldsToVariables) {
        LinkedHashSet<Object> cols;
        if (this.mappingPreference == MappingPreference.INDEXED_ONLY) {
            LinkedHashMultimap sorted = MappingInspector.sortFieldsByIndex(fieldsToVariables);
            cols = new LinkedHashSet(sorted.values());
            cols.addAll((Collection<CQLFragment>)fieldsToVariables.values());
        } else {
            cols = new LinkedHashSet<CQLFragment>((Collection<CQLFragment>)fieldsToVariables.values());
        }
        return cols;
    }

    private static boolean requiresBatchInsertQuery(ImmutableMultimap<MappingField, CQLFragment> fieldsToVariables) {
        Optional<FunctionCall> nonGlobalWriteTimes = fieldsToVariables.values().stream().filter(FunctionCall.class::isInstance).map(FunctionCall.class::cast).filter(fc -> fc.getFunctionName().equals((Object)MappingInspector.WRITETIME)).filter(fc -> !fc.getArgs().contains((Object)MappingInspector.STAR)).findAny();
        if (nonGlobalWriteTimes.isPresent()) {
            return true;
        }
        Optional<FunctionCall> nonGlobalTTLs = fieldsToVariables.values().stream().filter(FunctionCall.class::isInstance).map(FunctionCall.class::cast).filter(fc -> fc.getFunctionName().equals((Object)MappingInspector.TTL)).filter(fc -> !fc.getArgs().contains((Object)MappingInspector.STAR)).findAny();
        return nonGlobalTTLs.isPresent();
    }

    @NonNull
    private static ImmutableSetMultimap<Field, CQLWord> transformFieldsToVariables(ImmutableMultimap<MappingField, CQLFragment> fieldsToVariables) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Map.Entry entry : fieldsToVariables.entries()) {
            if (entry.getKey() instanceof FunctionCall) continue;
            builder.put((Object)((Field)entry.getKey()), (Object)SchemaSettings.toCQLWord((CQLFragment)entry.getValue()));
        }
        return builder.build();
    }

    @NonNull
    private static ImmutableSet<CQLWord> transformWriteTimeVariables(ImmutableSet<CQLFragment> writeTimeVariables) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (CQLFragment fragment : writeTimeVariables) {
            builder.add((Object)SchemaSettings.toCQLWord(fragment));
        }
        return builder.build();
    }

    private static CQLWord toCQLWord(CQLFragment fragment) {
        if (fragment instanceof CQLWord) {
            return (CQLWord)fragment;
        }
        String internal = fragment.render(CQLRenderMode.INTERNAL);
        return CQLWord.fromInternal((String)internal);
    }

    private static boolean containsFunctionCalls(Collection<?> coll) {
        return SchemaSettings.containsFunctionCalls(coll, (Predicate<? super FunctionCall>)Predicates.alwaysTrue());
    }

    private static boolean containsFunctionCalls(Collection<?> coll, Predicate<? super FunctionCall> predicate) {
        return coll.stream().filter(FunctionCall.class::isInstance).map(FunctionCall.class::cast).anyMatch(predicate);
    }

    private static boolean hasGraphOptions(Config config) {
        return config.hasPath(GRAPH) || config.hasPath(VERTEX) || config.hasPath(EDGE) || config.hasPath(FROM) || config.hasPath(TO);
    }

    private static boolean isGraph(KeyspaceMetadata keyspace) {
        return keyspace instanceof DseGraphKeyspaceMetadata && ((DseGraphKeyspaceMetadata)keyspace).getGraphEngine().isPresent();
    }

    private static boolean isSupportedGraph(KeyspaceMetadata keyspace) {
        return keyspace instanceof DseGraphKeyspaceMetadata && ((DseGraphKeyspaceMetadata)keyspace).getGraphEngine().filter(e -> e.equals(CORE)).isPresent();
    }

    private static class WriteTimeAndTTL {
        private FunctionCall writetime;
        private FunctionCall ttl;

        private WriteTimeAndTTL() {
        }
    }
}

