/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.settings;

import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.datastax.oss.dsbulk.workflow.api.config.ConfigPostProcessor;
import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Console;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordPrompter
implements ConfigPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordPrompter.class);
    private static final String DEFAULT_ENABLEMENT_PATH = "dsbulk.runner.promptForPasswords";
    private static final Map<String, String> DEFAULT_PATHS_TO_CHECK = ImmutableMap.builder().put((Object)"dsbulk.driver.auth.username", (Object)"dsbulk.driver.auth.password").put((Object)"dsbulk.driver.ssl.trustore.path", (Object)"dsbulk.driver.ssl.trustore.password").put((Object)"dsbulk.driver.ssl.keystore.path", (Object)"dsbulk.driver.ssl.keystore.password").put((Object)"datastax-java-driver.advanced.auth-provider.username", (Object)"datastax-java-driver.advanced.auth-provider.password").put((Object)"datastax-java-driver.advanced.ssl-engine-factory.truststore-path", (Object)"datastax-java-driver.advanced.ssl-engine-factory.truststore-password").put((Object)"datastax-java-driver.advanced.ssl-engine-factory.keystore-path", (Object)"datastax-java-driver.advanced.ssl-engine-factory.keystore-password").build();
    private final Map<String, String> pathsToCheck;
    private final Console console;
    private final Function<Config, Boolean> enablementSupplier;

    public PasswordPrompter() {
        this(DEFAULT_PATHS_TO_CHECK, System.console(), config -> config.getBoolean(DEFAULT_ENABLEMENT_PATH));
    }

    @VisibleForTesting
    PasswordPrompter(@NonNull Map<String, String> pathsToCheck, @Nullable Console console, @NonNull Function<Config, Boolean> enablementSupplier) {
        this.pathsToCheck = ImmutableMap.copyOf(pathsToCheck);
        this.console = console;
        this.enablementSupplier = enablementSupplier;
    }

    @NonNull
    public Config postProcess(@NonNull Config config) {
        boolean passwordPromptingEnabled = this.enablementSupplier.apply(config);
        if (passwordPromptingEnabled) {
            if (this.console != null) {
                for (Map.Entry<String, String> entry : this.pathsToCheck.entrySet()) {
                    String pathToPrompt;
                    String pathToCheck = entry.getKey();
                    if (!ConfigUtils.isPathPresentAndNotEmpty((Config)config, (String)pathToCheck) || config.hasPath(pathToPrompt = entry.getValue())) continue;
                    config = ConfigUtils.readPassword((Config)config, (String)pathToPrompt, (Console)this.console);
                }
            } else {
                LOGGER.debug("Standard input not available.");
            }
        } else {
            LOGGER.debug("Password prompting disabled in configuration.");
        }
        return config;
    }
}

