/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.settings;

import com.codahale.metrics.MetricRegistry;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.ThreadFactoryBuilder;
import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.datastax.oss.dsbulk.workflow.commons.metrics.MetricsManager;
import com.datastax.oss.dsbulk.workflow.commons.settings.LogSettings;
import com.datastax.oss.dsbulk.workflow.commons.settings.RowType;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitoringSettings.class);
    private static final String RATE_UNIT = "rateUnit";
    private static final String DURATION_UNIT = "durationUnit";
    private static final String REPORT_RATE = "reportRate";
    private static final String EXPECTED_WRITES = "expectedWrites";
    private static final String EXPECTED_READS = "expectedReads";
    private static final String TRACK_BYTES = "trackBytes";
    private static final String JMX = "jmx";
    private static final String CSV = "csv";
    private static final String CONSOLE = "console";
    private final Config config;
    private final String executionId;
    private TimeUnit rateUnit;
    private TimeUnit durationUnit;
    private Duration reportRate;
    private long expectedWrites;
    private long expectedReads;
    private boolean trackBytes;
    private boolean jmx;
    private boolean csv;
    private boolean console;

    public MonitoringSettings(Config config, String executionId) {
        this.config = config;
        this.executionId = executionId;
    }

    public void init() {
        try {
            this.rateUnit = (TimeUnit)this.config.getEnum(TimeUnit.class, RATE_UNIT);
            this.durationUnit = (TimeUnit)this.config.getEnum(TimeUnit.class, DURATION_UNIT);
            this.reportRate = this.config.getDuration(REPORT_RATE);
            if (this.reportRate.getSeconds() == 0L) {
                LOGGER.warn("Invalid value for dsbulk.monitoring.{}: expecting duration >= 1 second, got '{}' \u2013 will use 1 second instead", (Object)REPORT_RATE, (Object)this.config.getString(REPORT_RATE));
                this.reportRate = Duration.ofSeconds(1L);
            }
            this.expectedWrites = this.config.getLong(EXPECTED_WRITES);
            this.expectedReads = this.config.getLong(EXPECTED_READS);
            this.trackBytes = this.config.getBoolean(TRACK_BYTES);
            this.jmx = this.config.getBoolean(JMX);
            this.csv = this.config.getBoolean(CSV);
            this.console = this.config.getBoolean(CONSOLE);
        }
        catch (ConfigException e) {
            throw ConfigUtils.convertConfigException((ConfigException)e, (String)"dsbulk.monitoring");
        }
    }

    public MetricsManager newMetricsManager(boolean monitorWrites, boolean batchingEnabled, Path operationDirectory, LogSettings.Verbosity verbosity, MetricRegistry registry, ProtocolVersion protocolVersion, CodecRegistry codecRegistry, RowType rowType) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("reporter-%d").setPriority(1).build();
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, threadFactory);
        return new MetricsManager(registry, monitorWrites, this.executionId, scheduler, this.rateUnit, this.durationUnit, this.expectedWrites, this.expectedReads, this.trackBytes, this.jmx, this.csv, this.console, operationDirectory, verbosity, this.reportRate, batchingEnabled, protocolVersion, codecRegistry, rowType);
    }
}

