/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.settings;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Joiner;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.datastax.oss.dsbulk.format.row.RowFormatter;
import com.datastax.oss.dsbulk.format.statement.StatementFormatVerbosity;
import com.datastax.oss.dsbulk.format.statement.StatementFormatter;
import com.datastax.oss.dsbulk.format.statement.StatementPrinter;
import com.datastax.oss.dsbulk.workflow.api.error.ErrorThreshold;
import com.datastax.oss.dsbulk.workflow.api.log.OperationDirectory;
import com.datastax.oss.dsbulk.workflow.api.log.OperationDirectoryResolver;
import com.datastax.oss.dsbulk.workflow.api.utils.WorkflowUtils;
import com.datastax.oss.dsbulk.workflow.commons.format.statement.MappedBoundStatementPrinter;
import com.datastax.oss.dsbulk.workflow.commons.log.LogManager;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LogSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogSettings.class);
    private static final String CONSOLE_APPENDER = "CONSOLE";
    private static final int MIN_SAMPLE = 100;
    private static final String MAIN_LOG_FILE_APPENDER = "FILE";
    private static final String MAIN_LOG_FILE_NAME = "operation.log";
    public static final ImmutableList<String> STACK_TRACE_PRINTER_OPTIONS = ImmutableList.of((Object)"10", (Object)"reactor.core", (Object)"com.datastax.oss.driver.shaded", (Object)"io.netty", (Object)"java.util.concurrent");
    private static final String LAYOUT_PATTERN = "%date{yyyy-MM-dd HH:mm:ss,UTC} %-5level %msg%n%ex{" + Joiner.on((char)',').join(STACK_TRACE_PRINTER_OPTIONS) + "}";
    private static final Comparator<Map.Entry<String, ConfigValue>> BASIC_SETTINGS_FIRST = Comparator.comparing(entry -> ((String)entry.getKey()).replaceFirst("basic\\.", "0.").replaceFirst("advanced\\.", "1."));
    private static final List<String> PATHS_TO_OBFUSCATE = ImmutableList.of((Object)"advanced.auth-provider.password", (Object)"advanced.ssl-engine-factory.truststore-password", (Object)"advanced.ssl-engine-factory.keystore-password");
    private static final String STMT = "stmt";
    private static final String ROW = "row";
    private static final String MAX_QUERY_STRING_LENGTH = "stmt.maxQueryStringLength";
    private static final String MAX_BOUND_VALUE_LENGTH = "stmt.maxBoundValueLength";
    private static final String MAX_BOUND_VALUES = "stmt.maxBoundValues";
    private static final String MAX_INNER_STATEMENTS = "stmt.maxInnerStatements";
    private static final String MAX_RESULT_SET_VALUE_LENGTH = "row.maxResultSetValueLength";
    private static final String MAX_RESULT_SET_VALUES = "row.maxResultSetValues";
    private static final String LEVEL = "stmt.level";
    private static final String MAX_ERRORS = "maxErrors";
    private static final String MAX_QUERY_WARNINGS = "maxQueryWarnings";
    private static final String VERBOSITY = "verbosity";
    private static final String SOURCES = "sources";
    private final Config config;
    private final String executionId;
    private Path operationDirectory;
    private int maxQueryStringLength;
    private int maxBoundValueLength;
    private int maxBoundValues;
    private int maxResultSetValueLength;
    private int maxResultSetValues;
    private int maxInnerStatements;
    private StatementFormatVerbosity level;
    @VisibleForTesting
    ErrorThreshold errorThreshold;
    @VisibleForTesting
    ErrorThreshold queryWarningsThreshold;
    private Verbosity verbosity;
    private boolean sources;

    public LogSettings(Config config, String executionId) {
        this.config = config;
        this.executionId = executionId;
    }

    public void init() throws IOException {
        try {
            this.operationDirectory = new OperationDirectoryResolver(ConfigUtils.getPath((Config)this.config, (String)"directory"), this.executionId).resolve();
            OperationDirectory.setCurrentOperationDirectory((Path)this.operationDirectory);
            this.maxQueryStringLength = this.config.getInt(MAX_QUERY_STRING_LENGTH);
            this.maxBoundValueLength = this.config.getInt(MAX_BOUND_VALUE_LENGTH);
            this.maxBoundValues = this.config.getInt(MAX_BOUND_VALUES);
            this.maxInnerStatements = this.config.getInt(MAX_INNER_STATEMENTS);
            this.level = (StatementFormatVerbosity)this.config.getEnum(StatementFormatVerbosity.class, LEVEL);
            this.maxResultSetValueLength = this.config.getInt(MAX_RESULT_SET_VALUE_LENGTH);
            this.maxResultSetValues = this.config.getInt(MAX_RESULT_SET_VALUES);
            String maxErrorString = this.config.getString(MAX_ERRORS);
            if (LogSettings.isPercent(maxErrorString)) {
                float maxErrorsRatio = Float.parseFloat(maxErrorString.replaceAll("\\s*%", "")) / 100.0f;
                LogSettings.validatePercentageRange(maxErrorsRatio);
                this.errorThreshold = ErrorThreshold.forRatio((float)maxErrorsRatio, (long)100L);
            } else {
                long maxErrors = this.config.getLong(MAX_ERRORS);
                this.errorThreshold = maxErrors < 0L ? ErrorThreshold.unlimited() : ErrorThreshold.forAbsoluteValue((long)maxErrors);
            }
            long maxQueryWarnings = this.config.getLong(MAX_QUERY_WARNINGS);
            this.queryWarningsThreshold = maxQueryWarnings < 0L ? ErrorThreshold.unlimited() : ErrorThreshold.forAbsoluteValue((long)maxQueryWarnings);
            Path mainLogFile = this.operationDirectory.resolve(MAIN_LOG_FILE_NAME).normalize().toAbsolutePath();
            LogSettings.installJavaLoggingToSLF4JBridge();
            int verbosity = this.config.getInt(VERBOSITY);
            LogSettings.validateVerbosity(verbosity);
            if (verbosity == 0 || verbosity == 2) {
                // empty if block
            }
            this.verbosity = Verbosity.values()[verbosity];
            this.sources = this.config.getBoolean(SOURCES);
        }
        catch (ConfigException e) {
            throw ConfigUtils.convertConfigException((ConfigException)e, (String)"dsbulk.log");
        }
    }

    public void logEffectiveSettings(Config dsbulkConfig, Config driverConfig) {
        LOGGER.debug("{} starting.", (Object)WorkflowUtils.getBulkLoaderNameAndVersion());
        Objects.requireNonNull(Session.OSS_DRIVER_COORDINATES);
        LOGGER.debug("Available processors: {}.", (Object)Runtime.getRuntime().availableProcessors());
        LOGGER.info("Operation directory: {}", (Object)this.operationDirectory);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("DataStax Bulk Loader Effective settings:");
            this.dumpConfig(dsbulkConfig.withoutPath("driver"), Map.Entry.comparingByKey());
            LOGGER.debug("DataStax Java Driver Effective settings:");
            this.dumpConfig(driverConfig, BASIC_SETTINGS_FIRST);
        }
    }

    private void dumpConfig(Config config, Comparator<Map.Entry<String, ConfigValue>> comparator) {
        TreeSet<Map.Entry<String, ConfigValue>> entries = new TreeSet<Map.Entry<String, ConfigValue>>(comparator);
        entries.addAll(config.entrySet());
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            String value = PATHS_TO_OBFUSCATE.contains(key) ? "***************" : ((ConfigValue)entry.getValue()).render(ConfigRenderOptions.concise());
            LOGGER.debug(String.format("- %s = %s", key, value));
        }
    }

    public LogManager newLogManager(CqlSession session, boolean trackPositions) {
        StatementFormatter statementFormatter = StatementFormatter.builder().withMaxQueryStringLength(this.maxQueryStringLength).withMaxBoundValueLength(this.maxBoundValueLength).withMaxBoundValues(this.maxBoundValues).withMaxInnerStatements(this.maxInnerStatements).addStatementPrinters(new StatementPrinter[]{new MappedBoundStatementPrinter()}).build();
        RowFormatter rowFormatter = new RowFormatter(this.maxResultSetValueLength, this.maxResultSetValues);
        return new LogManager(session, this.operationDirectory, this.errorThreshold, this.queryWarningsThreshold, trackPositions, statementFormatter, this.level, rowFormatter);
    }

    public Verbosity getVerbosity() {
        return this.verbosity;
    }

    public boolean isSources() {
        return this.sources;
    }

    private static void installJavaLoggingToSLF4JBridge() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    private static boolean isPercent(String maxErrors) {
        return maxErrors.contains("%");
    }

    private static void validatePercentageRange(float maxErrorRatio) {
        if (maxErrorRatio <= 0.0f || maxErrorRatio >= 1.0f) {
            throw new IllegalArgumentException("maxErrors must either be a number, or percentage between 0 and 100 exclusive.");
        }
    }

    private static void validateVerbosity(int verbosity) {
        if (verbosity < 0 || verbosity > 2) {
            throw new IllegalArgumentException("verbosity must either be 0 (quiet), 1 (normal) or 2 (verbose).");
        }
    }

    public static enum Verbosity {
        quiet,
        normal,
        verbose;

    }
}

