/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.settings;

import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.datastax.oss.dsbulk.executor.api.BulkExecutor;
import com.datastax.oss.dsbulk.executor.api.BulkExecutorBuilder;
import com.datastax.oss.dsbulk.executor.api.BulkExecutorBuilderFactory;
import com.datastax.oss.dsbulk.executor.api.listener.ExecutionListener;
import com.datastax.oss.dsbulk.executor.api.listener.MetricsCollectingExecutionListener;
import com.datastax.oss.dsbulk.executor.api.reader.BulkReader;
import com.datastax.oss.dsbulk.executor.api.writer.BulkWriter;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorSettings.class);
    private final Config config;
    private int maxPerSecond;
    private int maxInFlight;
    private boolean continuousPagingEnabled;

    ExecutorSettings(Config config) {
        this.config = config;
    }

    public void init() {
        try {
            this.maxPerSecond = this.config.getInt("maxPerSecond");
            this.maxInFlight = this.config.getInt("maxInFlight");
        }
        catch (ConfigException e) {
            throw ConfigUtils.convertConfigException((ConfigException)e, (String)"dsbulk.executor");
        }
        Config continuousPagingConfig = this.config.getConfig("continuousPaging");
        try {
            this.continuousPagingEnabled = continuousPagingConfig.getBoolean("enabled");
            if (this.continuousPagingEnabled && ConfigUtils.hasUserOverride((Config)this.config, (String)"continuousPaging.maxConcurrentQueries")) {
                LOGGER.warn("Setting executor.continuousPaging.maxConcurrentQueries has been removed and is not honored anymore; please remove it from your configuration. To configure query concurrency, please use --dsbulk.engine.maxConcurrentQueries instead.");
            }
        }
        catch (ConfigException e) {
            throw ConfigUtils.convertConfigException((ConfigException)e, (String)"dsbulk.executor.continuousPaging");
        }
    }

    @NonNull
    public BulkWriter newWriteExecutor(@NonNull CqlSession session, @NonNull ExecutionListener executionListener) {
        return this.newBulkExecutor(session, executionListener, false, false);
    }

    @NonNull
    public BulkReader newReadExecutor(@NonNull CqlSession session, @NonNull MetricsCollectingExecutionListener executionListener, boolean searchQuery) {
        return this.newBulkExecutor(session, (ExecutionListener)executionListener, true, searchQuery);
    }

    @NonNull
    protected BulkExecutor newBulkExecutor(@NonNull CqlSession session, @NonNull ExecutionListener executionListener, boolean read, boolean searchQuery) {
        boolean useContinuousPagingForReads = read && this.checkContinuousPaging(session, searchQuery);
        ServiceLoader<BulkExecutorBuilderFactory> loader = ServiceLoader.load(BulkExecutorBuilderFactory.class);
        BulkExecutorBuilderFactory builderFactory = loader.iterator().next();
        BulkExecutorBuilder builder = builderFactory.create(session, useContinuousPagingForReads);
        builder.withExecutionListener(executionListener).withMaxInFlightRequests(this.maxInFlight).withMaxRequestsPerSecond(this.maxPerSecond).failSafe();
        return builder.build();
    }

    protected boolean checkContinuousPaging(@NonNull CqlSession session, boolean searchQuery) {
        if (this.continuousPagingEnabled) {
            boolean isContinuousPagingEnabledByUser = ConfigUtils.hasUserOverride((Config)this.config, (String)"continuousPaging.enabled");
            if (searchQuery) {
                if (isContinuousPagingEnabledByUser) {
                    LOGGER.warn("Continuous paging is enabled but is not compatible with search queries; disabling.");
                }
                return false;
            }
            if (this.isOssCassandra(session)) {
                if (isContinuousPagingEnabledByUser) {
                    LOGGER.warn("Continuous paging is enabled but is not compatible with OSS Cassandra; disabling.");
                }
                return false;
            }
            if (this.continuousPagingAvailable(session)) {
                return true;
            }
            LOGGER.warn("Continuous paging is not available, read performance will not be optimal. Check your remote DSE cluster configuration, and ensure that the configured consistency level is either ONE or LOCAL_ONE.");
        } else {
            LOGGER.debug("Continuous paging was disabled by configuration.");
        }
        return false;
    }

    protected boolean isOssCassandra(CqlSession session) {
        return session.getMetadata().getNodes().values().stream().map(Node::getExtras).noneMatch(extras -> extras.containsKey("DSE_VERSION"));
    }

    protected boolean continuousPagingAvailable(@NonNull CqlSession session) {
        ProtocolVersion protocolVersion = session.getContext().getProtocolVersion();
        if (protocolVersion.getCode() >= DseProtocolVersion.DSE_V1.getCode()) {
            DefaultConsistencyLevel consistencyLevel = DefaultConsistencyLevel.valueOf((String)session.getContext().getConfig().getDefaultProfile().getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY));
            return consistencyLevel == DefaultConsistencyLevel.ONE || consistencyLevel == DefaultConsistencyLevel.LOCAL_ONE;
        }
        return false;
    }
}

