/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.settings;

import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.util.Optional;
import java.util.OptionalInt;

public class EngineSettings {
    private static final String DRY_RUN = "dryRun";
    private static final String EXECUTION_ID = "executionId";
    private static final String MAX_CONCURRENT_QUERIES = "maxConcurrentQueries";
    private static final String DATA_SIZE_SAMPLING_ENABLED = "dataSizeSamplingEnabled";
    private final Config config;
    private boolean dryRun;
    private String executionId;
    private int maxConcurrentQueries;
    private boolean dataSizeSamplingEnabled;

    EngineSettings(Config config) {
        this.config = config;
    }

    public void init() {
        try {
            this.dryRun = this.config.getBoolean(DRY_RUN);
            this.executionId = this.config.hasPath(EXECUTION_ID) ? this.config.getString(EXECUTION_ID) : null;
            this.maxConcurrentQueries = this.config.getString(MAX_CONCURRENT_QUERIES).equalsIgnoreCase("AUTO") ? -1 : ConfigUtils.getThreads((Config)this.config, (String)MAX_CONCURRENT_QUERIES);
            this.dataSizeSamplingEnabled = this.config.getBoolean(DATA_SIZE_SAMPLING_ENABLED);
        }
        catch (ConfigException e) {
            throw ConfigUtils.convertConfigException((ConfigException)e, (String)"dsbulk.engine");
        }
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public Optional<String> getCustomExecutionIdTemplate() {
        return Optional.ofNullable(this.executionId);
    }

    public OptionalInt getMaxConcurrentQueries() {
        return this.maxConcurrentQueries == -1 ? OptionalInt.empty() : OptionalInt.of(this.maxConcurrentQueries);
    }

    public boolean isDataSizeSamplingEnabled() {
        return this.dataSizeSamplingEnabled;
    }
}

