/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.settings;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.session.ProgrammaticArguments;
import com.datastax.oss.driver.api.core.type.codec.registry.MutableCodecRegistry;
import com.datastax.oss.driver.internal.core.auth.PlainTextAuthProvider;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.ssl.JdkSslHandlerFactory;
import com.datastax.oss.driver.internal.core.ssl.SslHandlerFactory;
import com.datastax.oss.driver.internal.core.time.AtomicTimestampGenerator;
import com.datastax.oss.driver.internal.core.time.ServerSideTimestampGenerator;
import com.datastax.oss.driver.internal.core.time.ThreadLocalTimestampGenerator;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Joiner;
import com.datastax.oss.driver.shaded.guava.common.collect.BiMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.datastax.oss.dsbulk.config.shortcuts.ShortcutsFactory;
import com.datastax.oss.dsbulk.workflow.api.utils.WorkflowUtils;
import com.datastax.oss.dsbulk.workflow.commons.auth.AuthProviderFactory;
import com.datastax.oss.dsbulk.workflow.commons.settings.BulkDriverOption;
import com.datastax.oss.dsbulk.workflow.commons.ssl.SslHandlerFactoryFactory;
import com.datastax.oss.dsbulk.workflow.commons.utils.AddressUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValueFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriverSettings.class);
    private static final Duration ONE_MINUTE = Duration.ofSeconds(60L);
    private final Config deprecatedDriverConfig;
    private final Config deprecatedContinuousPagingConfig;
    private final BiMap<String, String> shortcuts;
    private Config newDriverConfig;
    private Config convertedConfig;
    private Config mergedDriverConfig;
    private int defaultPort;
    private AuthProvider authProvider;
    @VisibleForTesting
    SslHandlerFactory sslHandlerFactory;

    public DriverSettings(Config deprecatedDriverConfig, Config deprecatedContinuousPagingConfig, Config newDriverConfig) {
        this.newDriverConfig = newDriverConfig;
        this.deprecatedDriverConfig = deprecatedDriverConfig;
        this.deprecatedContinuousPagingConfig = deprecatedContinuousPagingConfig;
        this.shortcuts = ShortcutsFactory.createShortcutsMap().inverse();
    }

    public void init(boolean write) throws GeneralSecurityException, IOException {
        try {
            this.convertDriverDeprecatedConfig();
        }
        catch (ConfigException e) {
            throw ConfigUtils.convertConfigException((ConfigException)e, (String)"dsbulk.driver");
        }
        try {
            this.convertContinuousPagingDeprecatedConfig(write);
        }
        catch (ConfigException e) {
            throw ConfigUtils.convertConfigException((ConfigException)e, (String)"dsbulk.executor.continuousPaging");
        }
        this.mergedDriverConfig = this.convertedConfig.withFallback((ConfigMergeable)this.newDriverConfig).resolve();
        this.processCloudSettings(write);
        this.processContactPointSettings();
        this.processForcedSettings();
    }

    private void convertDriverDeprecatedConfig() throws GeneralSecurityException, IOException {
        this.convertedConfig = ConfigFactory.empty();
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"port")) {
            this.defaultPort = this.deprecatedDriverConfig.getInt("port");
            this.warnDeprecatedSetting("dsbulk.driver.port", BulkDriverOption.DEFAULT_PORT);
        } else {
            this.defaultPort = this.newDriverConfig.hasPath("basic.default-port") ? this.newDriverConfig.getInt("basic.default-port") : 9042;
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"hosts")) {
            List hosts = this.deprecatedDriverConfig.getStringList("hosts");
            Object contactPoints = hosts.stream().map(host -> host + ':' + this.defaultPort).collect(Collectors.toList());
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DefaultDriverOption.CONTACT_POINTS, contactPoints);
            this.warnDeprecatedSetting("dsbulk.driver.hosts", (DriverOption)DefaultDriverOption.CONTACT_POINTS);
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"protocol.compression")) {
            String compression = this.deprecatedDriverConfig.getString("protocol.compression");
            switch (compression.toLowerCase()) {
                case "lz4": 
                case "snappy": 
                case "none": {
                    this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, compression);
                    this.warnDeprecatedSetting("dsbulk.driver.protocol.compression", (DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Invalid value for dsbulk.driver.protocol.compression, expecting one of NONE, SNAPPY, LZ4, got '%s'", compression));
                }
            }
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"pooling.local.connections")) {
            int localConnections = this.deprecatedDriverConfig.getInt("pooling.local.connections");
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE, localConnections);
            this.warnDeprecatedSetting("dsbulk.driver.pooling.local.connections", (DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE);
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"pooling.remote.connections")) {
            int remoteConnections = this.deprecatedDriverConfig.getInt("pooling.remote.connections");
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE, remoteConnections);
            this.warnDeprecatedSetting("dsbulk.driver.pooling.remote.connections", (DriverOption)DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE);
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"pooling.local.requests")) {
            int localRequests = this.deprecatedDriverConfig.getInt("pooling.local.requests");
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DefaultDriverOption.CONNECTION_MAX_REQUESTS, localRequests);
            this.warnDeprecatedSetting("dsbulk.driver.pooling.local.requests", (DriverOption)DefaultDriverOption.CONNECTION_MAX_REQUESTS);
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"pooling.remote.requests")) {
            this.deprecatedDriverConfig.getInt("pooling.remote.requests");
            this.warnDeprecatedSetting("dsbulk.driver.pooling.remote.requests", (DriverOption)DefaultDriverOption.CONNECTION_MAX_REQUESTS);
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"pooling.heartbeat")) {
            Duration heartbeat = this.deprecatedDriverConfig.getDuration("pooling.heartbeat");
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DefaultDriverOption.HEARTBEAT_INTERVAL, heartbeat);
            this.warnDeprecatedSetting("dsbulk.driver.pooling.heartbeat", (DriverOption)DefaultDriverOption.HEARTBEAT_INTERVAL);
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"query.consistency")) {
            ConsistencyLevel consistency = (ConsistencyLevel)this.deprecatedDriverConfig.getEnum(DefaultConsistencyLevel.class, "query.consistency");
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, consistency.name());
            this.warnDeprecatedSetting("dsbulk.driver.query.consistency", (DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY);
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"query.serialConsistency")) {
            ConsistencyLevel consistency = (ConsistencyLevel)this.deprecatedDriverConfig.getEnum(DefaultConsistencyLevel.class, "query.serialConsistency");
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY, consistency.name());
            this.warnDeprecatedSetting("dsbulk.driver.query.serialConsistency", (DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY);
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"query.fetchSize")) {
            int fetchSize = this.deprecatedDriverConfig.getInt("query.fetchSize");
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, fetchSize);
            this.warnDeprecatedSetting("dsbulk.driver.query.fetchSize", (DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE);
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"query.idempotence")) {
            boolean idempotence = this.deprecatedDriverConfig.getBoolean("query.idempotence");
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE, idempotence);
            this.warnDeprecatedSetting("dsbulk.driver.query.idempotence", (DriverOption)DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE);
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"socket.readTimeout")) {
            Duration readTimeout = this.deprecatedDriverConfig.getDuration("socket.readTimeout");
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, readTimeout);
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DseDriverOption.CONTINUOUS_PAGING_TIMEOUT_FIRST_PAGE, readTimeout);
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DseDriverOption.CONTINUOUS_PAGING_TIMEOUT_OTHER_PAGES, readTimeout);
            this.warnDeprecatedSetting("dsbulk.driver.socket.readTimeout", (DriverOption)DefaultDriverOption.REQUEST_TIMEOUT);
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"auth")) {
            this.authProvider = AuthProviderFactory.createAuthProvider(this.deprecatedDriverConfig.getConfig("auth"));
            this.warnDeprecatedSetting("dsbulk.driver.auth.*", "advanced.auth-provider.*");
        } else if (!this.newDriverConfig.hasPath("advanced.auth-provider.class") && this.newDriverConfig.hasPath("advanced.auth-provider.username") && this.newDriverConfig.hasPath("advanced.auth-provider.password")) {
            LOGGER.info("Username and password provided but auth provider not specified, inferring PlainTextAuthProvider");
            this.newDriverConfig = this.newDriverConfig.withValue("advanced.auth-provider.class", ConfigValueFactory.fromAnyRef((Object)PlainTextAuthProvider.class.getSimpleName()));
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"ssl")) {
            this.sslHandlerFactory = SslHandlerFactoryFactory.createSslHandlerFactory(this.deprecatedDriverConfig.getConfig("ssl"));
            this.warnDeprecatedSetting("dsbulk.driver.ssl.*", "advanced.ssl-engine-factory.*");
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"timestampGenerator")) {
            Class<AtomicTimestampGenerator> generatorClass;
            String generator;
            switch (generator = this.deprecatedDriverConfig.getString("timestampGenerator")) {
                case "AtomicMonotonicTimestampGenerator": {
                    generatorClass = AtomicTimestampGenerator.class;
                    break;
                }
                case "ThreadLocalTimestampGenerator": {
                    generatorClass = ThreadLocalTimestampGenerator.class;
                    break;
                }
                case "ServerSideTimestampGenerator": {
                    generatorClass = ServerSideTimestampGenerator.class;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Invalid value for dsbulk.driver.protocol.timestampGenerator, expecting one of AtomicMonotonicTimestampGenerator, ThreadLocalTimestampGenerator, ServerSideTimestampGenerator, got '%s'", generator));
                }
            }
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DefaultDriverOption.TIMESTAMP_GENERATOR_CLASS, generatorClass.getSimpleName());
            this.warnDeprecatedSetting("dsbulk.driver.timestampGenerator", (DriverOption)DefaultDriverOption.TIMESTAMP_GENERATOR_CLASS);
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"addressTranslator")) {
            String translator = this.deprecatedDriverConfig.getString("addressTranslator");
            if (!translator.equals("IdentityTranslator")) {
                throw new IllegalArgumentException(String.format("Invalid value for dsbulk.driver.protocol.addressTranslator, expecting IdentityTranslator, got '%s'", translator));
            }
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DefaultDriverOption.ADDRESS_TRANSLATOR_CLASS, translator);
            this.warnDeprecatedSetting("dsbulk.driver.addressTranslator", (DriverOption)DefaultDriverOption.ADDRESS_TRANSLATOR_CLASS);
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"policy.maxRetries")) {
            int maxRetries = this.deprecatedDriverConfig.getInt("policy.maxRetries");
            this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, BulkDriverOption.RETRY_POLICY_MAX_RETRIES, maxRetries);
            this.warnDeprecatedSetting("dsbulk.driver.policy.maxRetries", BulkDriverOption.RETRY_POLICY_MAX_RETRIES);
        }
        if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"policy.lbp")) {
            if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"policy.lbp.name")) {
                DriverSettings.warnObsoleteLBPSetting("name");
            }
            if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"policy.lbp.dse.childPolicy")) {
                DriverSettings.warnObsoleteLBPSetting("dse.childPolicy");
            }
            if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"policy.lbp.dcAwareRoundRobin.localDc")) {
                String localDc = this.deprecatedDriverConfig.getString("policy.lbp.dcAwareRoundRobin.localDc");
                this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, localDc);
                this.warnDeprecatedSetting("dsbulk.driver.policy.lbp.dcAwareRoundRobin.localDc", (DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER);
            }
            if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"policy.lbp.dcAwareRoundRobin.allowRemoteDCsForLocalConsistencyLevel")) {
                DriverSettings.warnObsoleteLBPSetting("dcAwareRoundRobin.allowRemoteDCsForLocalConsistencyLevel");
            }
            if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"policy.lbp.dcAwareRoundRobin.usedHostsPerRemoteDc")) {
                DriverSettings.warnObsoleteLBPSetting("dcAwareRoundRobin.usedHostsPerRemoteDc");
            }
            if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"policy.lbp.tokenAware.childPolicy")) {
                DriverSettings.warnObsoleteLBPSetting("tokenAware.childPolicy");
            }
            if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"policy.lbp.tokenAware.replicaOrdering")) {
                DriverSettings.warnObsoleteLBPSetting("tokenAware.replicaOrdering");
            }
            if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"policy.lbp.whiteList.childPolicy")) {
                DriverSettings.warnObsoleteLBPSetting("whiteList.childPolicy");
            }
            if (ConfigUtils.hasUserOverride((Config)this.deprecatedDriverConfig, (String)"policy.lbp.whiteList.hosts")) {
                List whiteList = this.deprecatedDriverConfig.getStringList("policy.lbp.whiteList.hosts");
                this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, BulkDriverOption.LOAD_BALANCING_POLICY_FILTER_ALLOW, whiteList);
                this.warnDeprecatedSetting("dsbulk.driver.policy.lbp.whiteList.hosts", BulkDriverOption.LOAD_BALANCING_POLICY_FILTER_ALLOW);
            }
        }
    }

    private void convertContinuousPagingDeprecatedConfig(boolean write) {
        boolean continuousPagingEnabled;
        if (!write && this.deprecatedContinuousPagingConfig.hasPath("enabled") && (continuousPagingEnabled = this.deprecatedContinuousPagingConfig.getBoolean("enabled"))) {
            if (ConfigUtils.hasUserOverride((Config)this.deprecatedContinuousPagingConfig, (String)"pageSize")) {
                int pageSize = this.deprecatedContinuousPagingConfig.getInt("pageSize");
                this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DseDriverOption.CONTINUOUS_PAGING_PAGE_SIZE, pageSize);
                this.warnDeprecatedSetting("dsbulk.executor.continuousPaging.pageSize", (DriverOption)DseDriverOption.CONTINUOUS_PAGING_PAGE_SIZE);
            }
            if (ConfigUtils.hasUserOverride((Config)this.deprecatedContinuousPagingConfig, (String)"pageUnit")) {
                String pageUnit = this.deprecatedContinuousPagingConfig.getString("pageUnit");
                switch (pageUnit.toLowerCase()) {
                    case "bytes": 
                    case "rows": {
                        this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DseDriverOption.CONTINUOUS_PAGING_PAGE_SIZE_BYTES, "bytes".equalsIgnoreCase(pageUnit));
                        this.warnDeprecatedSetting("dsbulk.executor.continuousPaging.pageUnit", (DriverOption)DseDriverOption.CONTINUOUS_PAGING_PAGE_SIZE_BYTES);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Invalid value for dsbulk.executor.continuousPaging.pageUnit, expecting one of BYTES, ROWS, got '%s'", pageUnit));
                    }
                }
            }
            if (ConfigUtils.hasUserOverride((Config)this.deprecatedContinuousPagingConfig, (String)"maxPages")) {
                int maxPages = this.deprecatedContinuousPagingConfig.getInt("maxPages");
                this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES, maxPages);
                this.warnDeprecatedSetting("dsbulk.executor.continuousPaging.maxPages", (DriverOption)DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES);
            }
            if (ConfigUtils.hasUserOverride((Config)this.deprecatedContinuousPagingConfig, (String)"maxPagesPerSecond")) {
                int maxPagesPerSecond = this.deprecatedContinuousPagingConfig.getInt("maxPagesPerSecond");
                this.convertedConfig = DriverSettings.addConfigValue(this.convertedConfig, (DriverOption)DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND, maxPagesPerSecond);
                this.warnDeprecatedSetting("dsbulk.executor.continuousPaging.maxPagesPerSecond", (DriverOption)DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND);
            }
        }
    }

    private void processCloudSettings(boolean write) throws MalformedURLException {
        boolean cloud = this.mergedDriverConfig.hasPath(DefaultDriverOption.CLOUD_SECURE_CONNECT_BUNDLE.getPath());
        if (cloud) {
            ConsistencyLevel cl;
            URL cloudSecureConnectBundle = ConfigUtils.resolveURL((String)this.mergedDriverConfig.getString(DefaultDriverOption.CLOUD_SECURE_CONNECT_BUNDLE.getPath()));
            this.mergedDriverConfig = this.mergedDriverConfig.withValue(DefaultDriverOption.CLOUD_SECURE_CONNECT_BUNDLE.getPath(), ConfigValueFactory.fromAnyRef((Object)cloudSecureConnectBundle.toExternalForm()));
            if (this.mergedDriverConfig.hasPath(DefaultDriverOption.CONTACT_POINTS.getPath())) {
                if (ConfigUtils.hasReferenceValue((Config)this.mergedDriverConfig, (String)DefaultDriverOption.CONTACT_POINTS.getPath())) {
                    LOGGER.info("A cloud secure connect bundle was provided: ignoring all explicit contact points.");
                } else {
                    List contactPoints = this.mergedDriverConfig.getStringList(DefaultDriverOption.CONTACT_POINTS.getPath());
                    if (!contactPoints.isEmpty()) {
                        LOGGER.warn("Explicit contact points provided together with a cloud secure connect bundle; the following contact points will be ignored: \"{}\"", (Object)Joiner.on((String)"\", \"").join((Iterable)contactPoints));
                    }
                }
                this.mergedDriverConfig = this.mergedDriverConfig.withValue(DefaultDriverOption.CONTACT_POINTS.getPath(), ConfigValueFactory.fromAnyRef(Collections.emptyList()));
            }
            if (this.mergedDriverConfig.hasPath(DefaultDriverOption.REQUEST_CONSISTENCY.getPath()) && !DriverSettings.isCLCloudCompatible(write, cl = (ConsistencyLevel)this.mergedDriverConfig.getEnum(DefaultConsistencyLevel.class, DefaultDriverOption.REQUEST_CONSISTENCY.getPath()))) {
                if (ConfigUtils.hasReferenceValue((Config)this.mergedDriverConfig, (String)DefaultDriverOption.REQUEST_CONSISTENCY.getPath())) {
                    LOGGER.info("A cloud secure connect bundle was provided and selected operation performs writes: changing default consistency level to LOCAL_QUORUM.");
                } else {
                    LOGGER.warn("A cloud secure connect bundle was provided together with consistency level {}, but selected operation performs writes: forcing default consistency level to LOCAL_QUORUM.", (Object)cl);
                }
                this.mergedDriverConfig = this.mergedDriverConfig.withValue(DefaultDriverOption.REQUEST_CONSISTENCY.getPath(), ConfigValueFactory.fromAnyRef((Object)"LOCAL_QUORUM"));
            }
            if (this.sslHandlerFactory != null || this.mergedDriverConfig.hasPath("advanced.ssl-engine-factory.class")) {
                LOGGER.warn("Explicit SSL configuration provided together with a cloud secure connect bundle: SSL settings will be ignored.");
                this.mergedDriverConfig = this.mergedDriverConfig.withoutPath("advanced.ssl-engine-factory");
                this.sslHandlerFactory = null;
            }
        }
    }

    private void processContactPointSettings() {
        if (this.mergedDriverConfig.hasPath(DefaultDriverOption.CONTACT_POINTS.getPath())) {
            List hosts = this.mergedDriverConfig.getStringList(DefaultDriverOption.CONTACT_POINTS.getPath());
            List contactPoints = hosts.stream().map(contactPoint -> AddressUtils.maybeAddPortToHost(contactPoint, this.defaultPort)).collect(Collectors.toList());
            this.mergedDriverConfig = DriverSettings.addConfigValue(this.mergedDriverConfig, (DriverOption)DefaultDriverOption.CONTACT_POINTS, contactPoints);
        }
    }

    private void processForcedSettings() {
        Duration timeout = this.mergedDriverConfig.getDuration("basic.request.timeout");
        if (timeout.compareTo(ONE_MINUTE) < 0) {
            timeout = ONE_MINUTE;
        }
        Config forcedSettings = ConfigFactory.parseMap((Map)ImmutableMap.builder().put((Object)DefaultDriverOption.CONFIG_RELOAD_INTERVAL.getPath(), (Object)0).put((Object)DefaultDriverOption.REQUEST_LOG_WARNINGS.getPath(), (Object)false).put((Object)DefaultDriverOption.REQUEST_WARN_IF_SET_KEYSPACE.getPath(), (Object)false).put((Object)DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT.getPath(), (Object)timeout).put((Object)DefaultDriverOption.CONNECTION_SET_KEYSPACE_TIMEOUT.getPath(), (Object)timeout).put((Object)DefaultDriverOption.CONTROL_CONNECTION_TIMEOUT.getPath(), (Object)timeout).build(), (String)"DSBulk forced driver settings");
        this.mergedDriverConfig = forcedSettings.withFallback((ConfigMergeable)this.mergedDriverConfig);
    }

    public Config getDriverConfig() {
        return this.mergedDriverConfig;
    }

    public CqlSession newSession(String executionId, MutableCodecRegistry codecRegistry) {
        CqlSessionBuilder sessionBuilder = (CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)((CqlSessionBuilder)new BulkLoaderSessionBuilder().withApplicationVersion(WorkflowUtils.getBulkLoaderVersion())).withApplicationName("DataStax Bulk Loader " + executionId)).withClientId(WorkflowUtils.clientId((String)executionId))).withAuthProvider(this.authProvider)).withConfigLoader((DriverConfigLoader)new DefaultDriverConfigLoader(this::getDriverConfig, false))).withCodecRegistry(codecRegistry);
        return (CqlSession)sessionBuilder.build();
    }

    private static Config addConfigValue(Config config, DriverOption option, Object value) {
        return config.withValue(option.getPath(), ConfigValueFactory.fromAnyRef((Object)value, (String)"DSBulk converted driver settings"));
    }

    private void warnDeprecatedSetting(String deprecated, DriverOption replacement) {
        this.warnDeprecatedSetting(deprecated, replacement.getPath());
    }

    private void warnDeprecatedSetting(String deprecated, String replacement) {
        if (this.shortcuts.containsKey((Object)("datastax-java-driver." + replacement))) {
            String shortcut = (String)this.shortcuts.get((Object)("datastax-java-driver." + replacement));
            LOGGER.warn("Setting {} is deprecated and will be removed in a future release; please configure the driver directly using --datastax-java-driver.{} (or -{}) instead.", new Object[]{deprecated, replacement, shortcut});
        } else {
            LOGGER.warn("Setting {} is deprecated and will be removed in a future release; please configure the driver directly using --datastax-java-driver.{} instead.", (Object)deprecated, (Object)replacement);
        }
    }

    private static void warnObsoleteLBPSetting(String deprecated) {
        LOGGER.warn("Setting dsbulk.driver.policy.lbp.{} has been removed and is not honored anymore; please remove it from your configuration. To configure the load balancing policy, use --datastax-java-driver.basic.load-balancing-policy.* instead", (Object)deprecated);
    }

    private static boolean isCLCloudCompatible(boolean write, ConsistencyLevel cl) {
        if (write) {
            int protocolCode = cl.getProtocolCode();
            return protocolCode != 0 && protocolCode != 1 && protocolCode != 10;
        }
        return true;
    }

    private class BulkLoaderSessionBuilder
    extends CqlSessionBuilder {
        private BulkLoaderSessionBuilder() {
        }

        protected DriverContext buildContext(DriverConfigLoader configLoader, ProgrammaticArguments programmaticArguments) {
            return new DefaultDriverContext(configLoader, programmaticArguments){

                protected Optional<SslHandlerFactory> buildSslHandlerFactory() {
                    if (DriverSettings.this.sslHandlerFactory == null) {
                        return this.getSslEngineFactory().map(JdkSslHandlerFactory::new);
                    }
                    return Optional.of(DriverSettings.this.sslHandlerFactory);
                }
            };
        }
    }
}

