/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.settings;

import com.datastax.oss.dsbulk.connectors.api.Connector;
import com.typesafe.config.Config;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ConnectorSettings {
    private final Config config;
    private final boolean read;
    private Connector connector;
    private String connectorName;
    private Config connectorConfig;

    public ConnectorSettings(Config config, boolean read) {
        this.config = config;
        this.read = read;
    }

    public void init(boolean retainRecordSources) {
        this.connectorName = this.config.getString("name");
        this.connector = this.locateConnector(this.connectorName);
        if (!this.config.hasPath(this.connectorName)) {
            throw new IllegalArgumentException(String.format("Cannot find configuration entry for connector '%s'", this.connectorName));
        }
        this.connectorConfig = this.config.getConfig(this.connectorName).withoutPath("metaSettings");
        this.connector.configure(this.connectorConfig, this.read, retainRecordSources);
    }

    public Connector getConnector() throws IllegalArgumentException {
        return this.connector;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public Config getConnectorConfig() {
        return this.connectorConfig;
    }

    protected Connector locateConnector(String name) {
        ServiceLoader<Connector> connectors = ServiceLoader.load(Connector.class);
        for (Connector connector2 : connectors) {
            if (connector2.getClass().getName().equals(name)) {
                return connector2;
            }
            if (!connector2.getClass().getSimpleName().toLowerCase().startsWith(name.toLowerCase())) continue;
            return connector2;
        }
        throw new IllegalArgumentException(String.format("Cannot find connector '%s'; available connectors are: %s", name, StreamSupport.stream(connectors.spliterator(), false).map(connector -> connector.getClass().getName()).collect(Collectors.joining(", "))));
    }
}

