/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.settings;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.dsbulk.codecs.api.CommonConversionContext;
import com.datastax.oss.dsbulk.codecs.api.ConversionContext;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecFactory;
import com.datastax.oss.dsbulk.codecs.api.format.binary.Base64BinaryFormat;
import com.datastax.oss.dsbulk.codecs.api.format.binary.BinaryFormat;
import com.datastax.oss.dsbulk.codecs.api.format.binary.HexBinaryFormat;
import com.datastax.oss.dsbulk.codecs.api.format.geo.GeoFormat;
import com.datastax.oss.dsbulk.codecs.api.format.geo.JsonGeoFormat;
import com.datastax.oss.dsbulk.codecs.api.format.geo.WellKnownBinaryGeoFormat;
import com.datastax.oss.dsbulk.codecs.api.format.geo.WellKnownTextGeoFormat;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import com.datastax.oss.dsbulk.codecs.api.util.OverflowStrategy;
import com.datastax.oss.dsbulk.codecs.api.util.TimeUUIDGenerator;
import com.datastax.oss.dsbulk.codecs.text.TextConversionContext;
import com.datastax.oss.dsbulk.codecs.text.json.JsonCodecUtils;
import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class CodecSettings {
    private static final String LOCALE = "locale";
    private static final String NULL_STRINGS = "nullStrings";
    private static final String BOOLEAN_STRINGS = "booleanStrings";
    private static final String BOOLEAN_NUMBERS = "booleanNumbers";
    private static final String NUMBER = "number";
    private static final String FORMAT_NUMERIC_OUTPUT = "formatNumbers";
    private static final String ROUNDING_STRATEGY = "roundingStrategy";
    private static final String OVERFLOW_STRATEGY = "overflowStrategy";
    private static final String TIME = "time";
    private static final String TIME_ZONE = "timeZone";
    private static final String DATE = "date";
    private static final String TIMESTAMP = "timestamp";
    private static final String NUMERIC_TIMESTAMP_UNIT = "unit";
    private static final String NUMERIC_TIMESTAMP_EPOCH = "epoch";
    private static final String TIME_UUID_GENERATOR = "uuidStrategy";
    private static final String BINARY = "binary";
    private static final String GEO = "geo";
    private final Config config;
    private Locale locale;
    private ImmutableList<String> nullStrings;
    private List<BigDecimal> booleanNumbers;
    private boolean formatNumbers;
    private String numberFormat;
    private RoundingMode roundingMode;
    private OverflowStrategy overflowStrategy;
    private String dateFormat;
    private String timeFormat;
    private String timestampFormat;
    private ObjectMapper objectMapper;
    private ZoneId timeZone;
    private TimeUnit timeUnit;
    private ZonedDateTime epoch;
    private TimeUUIDGenerator generator;
    private Map<String, Boolean> booleanInputWords;
    private Map<Boolean, String> booleanOutputWords;
    private BinaryFormat binaryFormat;
    private GeoFormat geoFormat;

    public CodecSettings(Config config) {
        this.config = config;
    }

    public void init() {
        try {
            this.locale = CodecUtils.parseLocale((String)this.config.getString(LOCALE));
            this.nullStrings = ImmutableList.copyOf((Collection)this.config.getStringList(NULL_STRINGS));
            this.roundingMode = (RoundingMode)this.config.getEnum(RoundingMode.class, ROUNDING_STRATEGY);
            this.overflowStrategy = (OverflowStrategy)this.config.getEnum(OverflowStrategy.class, OVERFLOW_STRATEGY);
            this.formatNumbers = this.config.getBoolean(FORMAT_NUMERIC_OUTPUT);
            this.numberFormat = this.config.getString(NUMBER);
            this.timeZone = ZoneId.of(this.config.getString(TIME_ZONE));
            this.timeUnit = (TimeUnit)this.config.getEnum(TimeUnit.class, NUMERIC_TIMESTAMP_UNIT);
            String epochStr = this.config.getString(NUMERIC_TIMESTAMP_EPOCH);
            try {
                this.epoch = ZonedDateTime.parse(epochStr);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid value for dsbulk.codec.%s, expecting temporal in ISO_ZONED_DATE_TIME format, got '%s'", NUMERIC_TIMESTAMP_EPOCH, epochStr));
            }
            this.dateFormat = this.config.getString(DATE);
            this.timeFormat = this.config.getString(TIME);
            this.timestampFormat = this.config.getString(TIMESTAMP);
            this.booleanNumbers = this.getBooleanNumbers(this.config.getStringList(BOOLEAN_NUMBERS));
            List booleanStrings = this.config.getStringList(BOOLEAN_STRINGS);
            this.booleanInputWords = CodecSettings.getBooleanInputWords(booleanStrings);
            this.booleanOutputWords = CodecSettings.getBooleanOutputWords(booleanStrings);
            this.generator = (TimeUUIDGenerator)this.config.getEnum(TimeUUIDGenerator.class, TIME_UUID_GENERATOR);
            this.objectMapper = JsonCodecUtils.getObjectMapper();
            this.binaryFormat = this.getBinaryFormat();
            this.geoFormat = this.getGeoFormat();
        }
        catch (ConfigException e) {
            throw ConfigUtils.convertConfigException((ConfigException)e, (String)"dsbulk.codec");
        }
    }

    private List<BigDecimal> getBooleanNumbers(List<String> booleanNumbersStr) {
        if (booleanNumbersStr.size() != 2) {
            throw new IllegalArgumentException(String.format("Invalid value for dsbulk.codec.%s, expecting list with two numbers, got '%s'", BOOLEAN_NUMBERS, booleanNumbersStr));
        }
        try {
            return booleanNumbersStr.stream().map(BigDecimal::new).collect(Collectors.toList());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid value for dsbulk.codec.%s, expecting list with two numbers, got '%s'", BOOLEAN_NUMBERS, booleanNumbersStr));
        }
    }

    private BinaryFormat getBinaryFormat() {
        String binaryFormatStr = this.config.getString(BINARY);
        switch (binaryFormatStr.toLowerCase()) {
            case "hex": {
                return HexBinaryFormat.INSTANCE;
            }
            case "base64": {
                return Base64BinaryFormat.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Invalid value for dsbulk.codec.binary, expecting HEX or BASE64, got " + binaryFormatStr);
    }

    private GeoFormat getGeoFormat() {
        String geoFormatStr = this.config.getString(GEO);
        switch (geoFormatStr.toLowerCase()) {
            case "wkt": {
                return WellKnownTextGeoFormat.INSTANCE;
            }
            case "wkb": {
                String binaryFormatStr = this.config.getString(BINARY);
                switch (binaryFormatStr.toLowerCase()) {
                    case "hex": {
                        return WellKnownBinaryGeoFormat.HEX_INSTANCE;
                    }
                    case "base64": {
                        return WellKnownBinaryGeoFormat.BASE64_INSTANCE;
                    }
                }
                break;
            }
            case "json": {
                return JsonGeoFormat.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Invalid value for dsbulk.codec.geo, expecting WKT, WKB or JSON, got " + geoFormatStr);
    }

    public ConvertingCodecFactory createCodecFactory(boolean allowExtraFields, boolean allowMissingFields) {
        CommonConversionContext context = new TextConversionContext().setObjectMapper(this.objectMapper).setLocale(this.locale).setNullStrings(this.nullStrings).setBooleanInputWords(this.booleanInputWords).setBooleanOutputWords(this.booleanOutputWords).setBooleanNumbers(this.booleanNumbers.get(0), this.booleanNumbers.get(1)).setNumberFormat(this.numberFormat).setFormatNumbers(this.formatNumbers).setOverflowStrategy(this.overflowStrategy).setRoundingMode(this.roundingMode).setDateFormat(this.dateFormat).setTimeFormat(this.timeFormat).setTimestampFormat(this.timestampFormat).setTimeZone(this.timeZone).setTimeUnit(this.timeUnit).setEpoch(this.epoch).setTimeUUIDGenerator(this.generator).setBinaryFormat(this.binaryFormat).setGeoFormat(this.geoFormat).setAllowExtraFields(allowExtraFields).setAllowMissingFields(allowMissingFields);
        return new ConvertingCodecFactory((ConversionContext)context);
    }

    public static Map<String, Boolean> getBooleanInputWords(List<String> list) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        list.stream().map(str -> new StringTokenizer((String)str, ":")).forEach(tokenizer -> {
            if (tokenizer.countTokens() != 2) {
                throw new IllegalArgumentException(String.format("Invalid value for dsbulk.codec.booleanStrings, expecting list with at least one true:false pair, got '%s'", list));
            }
            builder.put((Object)tokenizer.nextToken().toLowerCase(), (Object)true);
            builder.put((Object)tokenizer.nextToken().toLowerCase(), (Object)false);
        });
        return builder.build();
    }

    public static Map<Boolean, String> getBooleanOutputWords(List<String> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid value for dsbulk.codec.booleanStrings, expecting list with at least one true:false pair, got '%s'", list));
        }
        StringTokenizer tokenizer = new StringTokenizer(list.get(0), ":");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)true, (Object)tokenizer.nextToken().toLowerCase());
        builder.put((Object)false, (Object)tokenizer.nextToken().toLowerCase());
        return builder.build();
    }
}

