/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.settings;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.DefaultBatchType;
import com.datastax.oss.dsbulk.batcher.api.BatchMode;
import com.datastax.oss.dsbulk.batcher.api.ReactiveStatementBatcher;
import com.datastax.oss.dsbulk.batcher.api.ReactiveStatementBatcherFactory;
import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchSettings.class);
    private static final String MODE = "mode";
    private static final String MAX_BATCH_SIZE = "maxBatchSize";
    private static final String MAX_SIZE_IN_BYTES = "maxSizeInBytes";
    private static final String MAX_BATCH_STATEMENTS = "maxBatchStatements";
    private static final String BUFFER_SIZE = "bufferSize";
    private final Config config;
    private WorkloadBatchMode mode;
    private long maxSizeInBytes;
    private int maxBatchStatements;
    private int bufferSize;

    public BatchSettings(Config config) {
        this.config = config;
    }

    public void init(boolean forceDisabled) {
        try {
            this.mode = (WorkloadBatchMode)this.config.getEnum(WorkloadBatchMode.class, MODE);
            if (this.mode != WorkloadBatchMode.DISABLED && forceDisabled) {
                LOGGER.info("The prepared query for this operation is a BATCH statement: forcibly disabling batching");
                this.mode = WorkloadBatchMode.DISABLED;
            }
            this.maxSizeInBytes = this.config.getLong(MAX_SIZE_IN_BYTES);
            if (this.config.hasPath(MAX_BATCH_SIZE)) {
                if (this.config.hasPath(MAX_BATCH_STATEMENTS)) {
                    throw new IllegalArgumentException("Settings batch.maxBatchStatements and batch.maxBatchSize cannot be both defined; consider using batch.maxBatchStatements exclusively, because batch.maxBatchSize is deprecated.");
                }
                LOGGER.warn("Setting batch.maxBatchSize is deprecated, please use batch.maxBatchStatements instead.");
                this.maxBatchStatements = this.config.getInt(MAX_BATCH_SIZE);
            } else {
                this.maxBatchStatements = this.config.getInt(MAX_BATCH_STATEMENTS);
            }
            if (this.maxSizeInBytes <= 0L && this.maxBatchStatements <= 0) {
                throw new IllegalArgumentException("At least one of batch.maxSizeInBytes or batch.maxBatchStatements must be positive. See settings.md for more information.");
            }
            int bufferConfig = this.config.getInt(BUFFER_SIZE);
            int n = this.bufferSize = bufferConfig > 0 ? bufferConfig : 4 * this.maxBatchStatements;
            if (this.maxBatchStatements <= 0 && this.bufferSize <= 0) {
                throw new IllegalArgumentException(String.format("Value for batch.bufferSize (%d) must be positive if batch.maxBatchStatements is negative or zero. See settings.md for more information.", this.bufferSize));
            }
            if (this.bufferSize < this.maxBatchStatements) {
                throw new IllegalArgumentException(String.format("Value for batch.bufferSize (%d) must be greater than or equal to batch.maxBatchStatements OR batch.maxBatchSize (%d). See settings.md for more information.", this.bufferSize, this.maxBatchStatements));
            }
        }
        catch (ConfigException e) {
            throw ConfigUtils.convertConfigException((ConfigException)e, (String)"dsbulk.batch");
        }
    }

    public boolean isBatchingEnabled() {
        return this.mode != WorkloadBatchMode.DISABLED;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public ReactiveStatementBatcher newStatementBatcher(CqlSession session) {
        ServiceLoader<ReactiveStatementBatcherFactory> loader = ServiceLoader.load(ReactiveStatementBatcherFactory.class);
        ReactiveStatementBatcherFactory factory = loader.iterator().next();
        return factory.create(session, this.mode.asStatementBatcherMode(), (BatchType)DefaultBatchType.UNLOGGED, this.maxBatchStatements, this.maxSizeInBytes);
    }

    private static enum WorkloadBatchMode {
        DISABLED{

            @Override
            BatchMode asStatementBatcherMode() {
                throw new IllegalStateException("Batching is disabled");
            }
        }
        ,
        PARTITION_KEY{

            @Override
            BatchMode asStatementBatcherMode() {
                return BatchMode.PARTITION_KEY;
            }
        }
        ,
        REPLICA_SET{

            @Override
            BatchMode asStatementBatcherMode() {
                return BatchMode.REPLICA_SET;
            }
        };


        abstract BatchMode asStatementBatcherMode();
    }
}

