/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.schema;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.dsbulk.generated.cql3.CqlBaseVisitor;
import com.datastax.oss.dsbulk.generated.cql3.CqlLexer;
import com.datastax.oss.dsbulk.generated.cql3.CqlParser;
import com.datastax.oss.dsbulk.mapping.CQLFragment;
import com.datastax.oss.dsbulk.mapping.CQLLiteral;
import com.datastax.oss.dsbulk.mapping.CQLWord;
import com.datastax.oss.dsbulk.mapping.FunctionCall;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;

public class QueryInspector
extends CqlBaseVisitor<CQLFragment> {
    public static final CQLWord INTERNAL_TIMESTAMP_VARNAME = CQLWord.fromInternal((String)"[timestamp]");
    public static final CQLWord INTERNAL_TTL_VARNAME = CQLWord.fromInternal((String)"[ttl]");
    private static final CQLWord INTERNAL_TOKEN_VARNAME = CQLWord.fromInternal((String)"partition key token");
    private static final CQLWord QUESTION_MARK = CQLWord.fromInternal((String)"?");
    private static final CQLWord WRITETIME = CQLWord.fromInternal((String)"writetime");
    private static final CQLWord TTL = CQLWord.fromInternal((String)"ttl");
    private static final CQLWord SOLR_QUERY = CQLWord.fromInternal((String)"solr_query");
    private final String query;
    private final Map<CQLFragment, CQLFragment> resultSetVariablesBuilder = new LinkedHashMap<CQLFragment, CQLFragment>();
    private final Map<CQLWord, CQLFragment> assignmentsBuilder = new LinkedHashMap<CQLWord, CQLFragment>();
    private final Set<CQLFragment> writeTimeVariablesBuilder = new LinkedHashSet<CQLFragment>();
    private final ImmutableMap<CQLFragment, CQLFragment> resultSetVariables;
    private final ImmutableMap<CQLWord, CQLFragment> assignments;
    private final ImmutableSet<CQLFragment> writeTimeVariables;
    private CQLWord keyspaceName;
    private CQLWord tableName;
    private int fromClauseStartIndex = -1;
    private int fromClauseEndIndex = -1;
    private boolean hasWhereClause = false;
    private CQLWord tokenRangeRestrictionStartVariable;
    private CQLWord tokenRangeRestrictionEndVariable;
    private int tokenRangeRestrictionVariableIndex = 0;
    private int tokenRangeRestrictionStartVariableIndex = -1;
    private int tokenRangeRestrictionEndVariableIndex = -1;
    private boolean selectStar = false;
    private boolean hasUnsupportedSelectors = false;
    private CQLWord usingTimestampVariable;
    private CQLWord usingTTLVariable;
    private boolean hasSearchClause = false;
    private boolean parallelizable = true;
    private boolean batch = false;

    public QueryInspector(final String query) {
        this.query = query;
        CodePointCharStream input = CharStreams.fromString((String)query);
        CqlLexer lexer = new CqlLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        CqlParser parser = new CqlParser((TokenStream)tokens);
        BaseErrorListener listener = new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int col, String msg, RecognitionException e) {
                throw new IllegalArgumentException(String.format("Invalid query: '%s' could not be parsed at line %d:%d: %s", query, line, col, msg), (Throwable)e);
            }
        };
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        CqlParser.CqlStatementContext statement = parser.cqlStatement();
        this.visit((ParseTree)statement);
        this.resultSetVariables = ImmutableMap.copyOf(this.resultSetVariablesBuilder);
        this.assignments = ImmutableMap.copyOf(this.assignmentsBuilder);
        this.writeTimeVariables = ImmutableSet.copyOf(this.writeTimeVariablesBuilder);
    }

    public Optional<CQLWord> getKeyspaceName() {
        return Optional.ofNullable(this.keyspaceName);
    }

    public CQLWord getTableName() {
        return this.tableName;
    }

    public ImmutableMap<CQLWord, CQLFragment> getAssignments() {
        return this.assignments;
    }

    public ImmutableMap<CQLFragment, CQLFragment> getResultSetVariables() {
        return this.resultSetVariables;
    }

    public boolean isSelectStar() {
        return this.selectStar;
    }

    public boolean hasUnsupportedSelectors() {
        return this.hasUnsupportedSelectors;
    }

    public ImmutableSet<CQLFragment> getWriteTimeVariables() {
        return this.writeTimeVariables;
    }

    public Optional<CQLWord> getUsingTimestampVariable() {
        return Optional.ofNullable(this.usingTimestampVariable);
    }

    public Optional<CQLWord> getUsingTTLVariable() {
        return Optional.ofNullable(this.usingTTLVariable);
    }

    public int getFromClauseStartIndex() {
        return this.fromClauseStartIndex;
    }

    public int getFromClauseEndIndex() {
        return this.fromClauseEndIndex;
    }

    public boolean hasWhereClause() {
        return this.hasWhereClause;
    }

    public boolean hasSearchClause() {
        return this.hasSearchClause;
    }

    public Optional<CQLWord> getTokenRangeRestrictionStartVariable() {
        return Optional.ofNullable(this.tokenRangeRestrictionStartVariable);
    }

    public Optional<CQLWord> getTokenRangeRestrictionEndVariable() {
        return Optional.ofNullable(this.tokenRangeRestrictionEndVariable);
    }

    public int getTokenRangeRestrictionStartVariableIndex() {
        return this.tokenRangeRestrictionStartVariableIndex;
    }

    public int getTokenRangeRestrictionEndVariableIndex() {
        return this.tokenRangeRestrictionEndVariableIndex;
    }

    public boolean isParallelizable() {
        return this.parallelizable;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public CQLFragment visitInsertStatement(CqlParser.InsertStatementContext ctx) {
        this.visitColumnFamilyName(ctx.columnFamilyName());
        return (CQLFragment)this.visitChildren((RuleNode)ctx);
    }

    public CQLFragment visitNormalInsertStatement(CqlParser.NormalInsertStatementContext ctx) {
        if (ctx.cident().size() != ctx.term().size()) {
            throw new IllegalArgumentException(String.format("Invalid query: the number of columns to insert (%d) does not match the number of terms (%d): %s.", ctx.cident().size(), ctx.term().size(), this.query));
        }
        for (int i = 0; i < ctx.cident().size(); ++i) {
            CQLWord column = this.visitCident((CqlParser.CidentContext)ctx.cident().get(i));
            CQLFragment variable = this.visitTerm((CqlParser.TermContext)ctx.term().get(i));
            this.assignmentsBuilder.put(column, (CQLFragment)(variable == QUESTION_MARK ? column : variable));
        }
        if (ctx.usingClause() != null) {
            this.visitUsingClause(ctx.usingClause());
        }
        return null;
    }

    public CQLFragment visitJsonInsertStatement(CqlParser.JsonInsertStatementContext ctx) {
        throw new IllegalArgumentException(String.format("Invalid query: INSERT JSON is not supported: %s.", this.query));
    }

    public CQLFragment visitUpdateStatement(CqlParser.UpdateStatementContext ctx) {
        this.visitColumnFamilyName(ctx.columnFamilyName());
        for (CqlParser.ColumnOperationContext op : ctx.columnOperation()) {
            CQLWord column = this.visitCident(op.cident());
            CQLFragment variable = this.visitColumnOperationDifferentiator(op.columnOperationDifferentiator());
            if (variable == null) continue;
            this.assignmentsBuilder.put(column, (CQLFragment)(variable == QUESTION_MARK ? column : variable));
        }
        this.visitWhereClause(ctx.whereClause());
        if (ctx.usingClause() != null) {
            this.visitUsingClause(ctx.usingClause());
        }
        return null;
    }

    public CQLFragment visitColumnOperationDifferentiator(CqlParser.ColumnOperationDifferentiatorContext ctx) {
        if (ctx.normalColumnOperation() != null) {
            return this.visitTerm(ctx.normalColumnOperation().term());
        }
        if (ctx.shorthandColumnOperation() != null) {
            return this.visitTerm(ctx.shorthandColumnOperation().term());
        }
        return null;
    }

    public CQLFragment visitSelectStatement(CqlParser.SelectStatementContext ctx) {
        if (ctx.K_JSON() != null) {
            throw new IllegalArgumentException(String.format("Invalid query: SELECT JSON is not supported: %s.", this.query));
        }
        this.visitColumnFamilyName(ctx.columnFamilyName());
        this.fromClauseStartIndex = ctx.K_FROM().getSymbol().getStartIndex();
        this.fromClauseEndIndex = ctx.columnFamilyName().getStop().getStopIndex();
        if (ctx.whereClause() != null) {
            this.hasWhereClause = true;
            this.parallelizable = false;
            this.visitWhereClause(ctx.whereClause());
        }
        if (!ctx.groupByClause().isEmpty() || !ctx.orderByClause().isEmpty() || ctx.limitClause() != null) {
            this.parallelizable = false;
        }
        return this.visitSelectClause(ctx.selectClause());
    }

    public CQLFragment visitBatchStatement(CqlParser.BatchStatementContext ctx) {
        this.batch = true;
        return (CQLFragment)super.visitBatchStatement(ctx);
    }

    public CQLFragment visitSelectClause(CqlParser.SelectClauseContext ctx) {
        if (ctx.getText().equals("*")) {
            this.selectStar = true;
        }
        return (CQLFragment)super.visitSelectClause(ctx);
    }

    @Nullable
    public CQLFragment visitSelector(CqlParser.SelectorContext ctx) {
        CQLFragment unaliased = this.visitUnaliasedSelector(ctx.unaliasedSelector());
        if (unaliased != null) {
            FunctionCall function;
            boolean hasAlias = ctx.noncolIdent() != null;
            CQLFragment alias = hasAlias ? this.visitNoncolIdent(ctx.noncolIdent()) : unaliased;
            this.resultSetVariablesBuilder.put(unaliased, alias);
            if (unaliased instanceof FunctionCall && (function = (FunctionCall)unaliased).getFunctionName().equals((Object)WRITETIME)) {
                this.writeTimeVariablesBuilder.add(alias);
            }
        } else {
            this.hasUnsupportedSelectors = true;
        }
        return unaliased;
    }

    @Nullable
    public CQLFragment visitUnaliasedSelector(CqlParser.UnaliasedSelectorContext ctx) {
        if (!ctx.fident().isEmpty()) {
            return null;
        }
        if (ctx.getChildCount() == 1 && ctx.cident() != null) {
            return this.visitCident(ctx.cident());
        }
        if (ctx.K_WRITETIME() != null) {
            return new FunctionCall(null, WRITETIME, new CQLFragment[]{this.visitCident(ctx.cident())});
        }
        if (ctx.K_TTL() != null) {
            return new FunctionCall(null, TTL, new CQLFragment[]{this.visitCident(ctx.cident())});
        }
        if (ctx.functionName() != null) {
            CQLWord keyspaceName = null;
            if (ctx.functionName().keyspaceName() != null) {
                keyspaceName = this.visitKeyspaceName(ctx.functionName().keyspaceName());
            }
            CQLWord functionName = this.visitAllowedFunctionName(ctx.functionName().allowedFunctionName());
            ArrayList<CQLFragment> args = new ArrayList<CQLFragment>();
            if (ctx.selectionFunctionArgs() != null) {
                for (CqlParser.UnaliasedSelectorContext arg : ctx.selectionFunctionArgs().unaliasedSelector()) {
                    CQLFragment term = this.visitUnaliasedSelector(arg);
                    if (term != null) {
                        args.add(term);
                        continue;
                    }
                    return null;
                }
            }
            return new FunctionCall(keyspaceName, functionName, args);
        }
        return null;
    }

    @Nullable
    public CQLFragment visitDeleteStatement(CqlParser.DeleteStatementContext ctx) {
        this.visitColumnFamilyName(ctx.columnFamilyName());
        this.visitWhereClause(ctx.whereClause());
        if (ctx.usingClauseDelete() != null) {
            this.visitUsingClauseDelete(ctx.usingClauseDelete());
        }
        return null;
    }

    @Nullable
    public CQLFragment visitRelation(CqlParser.RelationContext ctx) {
        CQLFragment variable;
        while (ctx.relation() != null) {
            ctx = ctx.relation();
        }
        if (ctx.getChildCount() == 3 && ctx.getChild(0) instanceof CqlParser.CidentContext && ctx.getChild(1) instanceof CqlParser.RelationTypeContext && ctx.getChild(2) instanceof CqlParser.TermContext && ctx.getChild(1).getText().equals("=")) {
            CQLFragment variable2;
            CQLWord column = this.visitCident(ctx.cident());
            if (column.equals((Object)SOLR_QUERY)) {
                this.hasSearchClause = true;
            }
            this.assignmentsBuilder.put(column, (CQLFragment)((variable2 = this.visitTerm((CqlParser.TermContext)ctx.term().get(0))).equals(QUESTION_MARK) ? column : variable2));
        } else if (ctx.K_TOKEN() != null && (variable = this.visitTerm((CqlParser.TermContext)ctx.term().get(0))) instanceof CQLWord) {
            if (variable == QUESTION_MARK) {
                variable = INTERNAL_TOKEN_VARNAME;
            }
            if (ctx.relationType().getText().equals(">")) {
                this.tokenRangeRestrictionStartVariable = (CQLWord)variable;
                this.tokenRangeRestrictionStartVariableIndex = this.tokenRangeRestrictionVariableIndex++;
            } else if (ctx.relationType().getText().equals("<=")) {
                this.tokenRangeRestrictionEndVariable = (CQLWord)variable;
                this.tokenRangeRestrictionEndVariableIndex = this.tokenRangeRestrictionVariableIndex++;
            }
        }
        return null;
    }

    @NonNull
    public CQLFragment visitTerm(CqlParser.TermContext ctx) {
        while (ctx.term() != null) {
            ctx = ctx.term();
        }
        if (ctx.value() != null) {
            return this.visitValue(ctx.value());
        }
        assert (ctx.function() != null);
        return this.visitFunction(ctx.function());
    }

    @NonNull
    public FunctionCall visitFunction(CqlParser.FunctionContext ctx) {
        CQLWord keyspaceName = null;
        if (ctx.functionName().keyspaceName() != null) {
            keyspaceName = this.visitKeyspaceName(ctx.functionName().keyspaceName());
        }
        CQLWord functionName = this.visitAllowedFunctionName(ctx.functionName().allowedFunctionName());
        ArrayList<CQLFragment> args = new ArrayList<CQLFragment>();
        if (ctx.functionArgs() != null) {
            for (CqlParser.TermContext arg : ctx.functionArgs().term()) {
                CQLFragment term = this.visitTerm(arg);
                if (term == QUESTION_MARK) {
                    throw new IllegalArgumentException(String.format("Invalid query: positional variables are not allowed as function parameters: %s.", this.query));
                }
                args.add(term);
            }
        }
        return new FunctionCall(keyspaceName, functionName, args);
    }

    @NonNull
    public CQLFragment visitValue(CqlParser.ValueContext ctx) {
        if (ctx.QMARK() != null) {
            return QUESTION_MARK;
        }
        if (ctx.noncolIdent() != null) {
            return this.visitNoncolIdent(ctx.noncolIdent());
        }
        return new CQLLiteral(ctx.getText());
    }

    @NonNull
    public CQLFragment visitColumnFamilyName(CqlParser.ColumnFamilyNameContext ctx) {
        if (ctx.ksName() != null) {
            this.keyspaceName = this.visitKsName(ctx.ksName());
        }
        this.tableName = this.visitCfName(ctx.cfName());
        return this.tableName;
    }

    @NonNull
    public CQLWord visitAllowedFunctionName(CqlParser.AllowedFunctionNameContext ctx) {
        if (ctx.QUOTED_NAME() != null) {
            return CQLWord.fromCql((String)ctx.getText());
        }
        return CQLWord.fromInternal((String)ctx.getText().toLowerCase());
    }

    public CQLWord visitKeyspaceName(CqlParser.KeyspaceNameContext ctx) {
        return this.visitKsName(ctx.ksName());
    }

    @NonNull
    public CQLWord visitKsName(CqlParser.KsNameContext ctx) {
        if (ctx.QUOTED_NAME() != null) {
            return CQLWord.fromCql((String)ctx.getText());
        }
        return CQLWord.fromInternal((String)ctx.getText().toLowerCase());
    }

    @NonNull
    public CQLWord visitCfName(CqlParser.CfNameContext ctx) {
        if (ctx.QUOTED_NAME() != null) {
            return CQLWord.fromCql((String)ctx.getText());
        }
        return CQLWord.fromInternal((String)ctx.getText().toLowerCase());
    }

    @NonNull
    public CQLWord visitCident(CqlParser.CidentContext ctx) {
        if (ctx.QUOTED_NAME() != null) {
            return CQLWord.fromCql((String)ctx.getText());
        }
        return CQLWord.fromInternal((String)ctx.getText().toLowerCase());
    }

    @NonNull
    public CQLWord visitNoncolIdent(CqlParser.NoncolIdentContext ctx) {
        if (ctx.QUOTED_NAME() != null) {
            return CQLWord.fromCql((String)ctx.getText());
        }
        return CQLWord.fromInternal((String)ctx.getText().toLowerCase());
    }

    @Nullable
    public CQLFragment visitUsingClauseObjective(CqlParser.UsingClauseObjectiveContext ctx) {
        if (ctx.K_TIMESTAMP() != null) {
            return this.visitUsingTimestamp(ctx.intValue());
        }
        assert (ctx.K_TTL() != null);
        return this.visitUsingTTL(ctx.intValue());
    }

    @Nullable
    public CQLFragment visitUsingClauseDelete(CqlParser.UsingClauseDeleteContext ctx) {
        return this.visitUsingTimestamp(ctx.intValue());
    }

    @Nullable
    private CQLWord visitUsingTimestamp(CqlParser.IntValueContext intValueContext) {
        if (intValueContext.noncolIdent() != null) {
            CQLWord variable = this.visitNoncolIdent(intValueContext.noncolIdent());
            this.writeTimeVariablesBuilder.add((CQLFragment)variable);
            this.usingTimestampVariable = variable;
        } else if (intValueContext.QMARK() != null) {
            this.writeTimeVariablesBuilder.add((CQLFragment)INTERNAL_TIMESTAMP_VARNAME);
            this.usingTimestampVariable = INTERNAL_TIMESTAMP_VARNAME;
        }
        return this.usingTimestampVariable;
    }

    @Nullable
    private CQLWord visitUsingTTL(CqlParser.IntValueContext intValueContext) {
        if (intValueContext.noncolIdent() != null) {
            this.usingTTLVariable = this.visitNoncolIdent(intValueContext.noncolIdent());
        } else if (intValueContext.QMARK() != null) {
            this.usingTTLVariable = INTERNAL_TTL_VARNAME;
        }
        return this.usingTTLVariable;
    }
}

