/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.dsbulk.connectors.api.Field;
import com.datastax.oss.dsbulk.connectors.api.Record;
import com.datastax.oss.dsbulk.connectors.api.RecordMetadata;
import com.datastax.oss.dsbulk.mapping.CQLWord;
import com.datastax.oss.dsbulk.mapping.Mapping;
import com.datastax.oss.dsbulk.workflow.commons.schema.InvalidMappingException;
import com.datastax.oss.dsbulk.workflow.commons.schema.RecordMapper;
import com.datastax.oss.dsbulk.workflow.commons.statement.MappedBoundStatement;
import com.datastax.oss.dsbulk.workflow.commons.statement.UnmappableStatement;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class DefaultRecordMapper
implements RecordMapper {
    private final PreparedStatement insertStatement;
    private final ImmutableSet<CQLWord> partitionKeyVariables;
    private final ImmutableSet<CQLWord> clusteringColumnVariables;
    private final ProtocolVersion protocolVersion;
    private final Mapping mapping;
    private final RecordMetadata recordMetadata;
    private final boolean nullToUnset;
    private final boolean allowExtraFields;
    private final boolean allowMissingFields;
    private final Function<PreparedStatement, BoundStatementBuilder> boundStatementBuilderFactory;
    private final ImmutableMap<CQLWord, List<Integer>> variablesToIndices;

    public DefaultRecordMapper(PreparedStatement insertStatement, Set<CQLWord> partitionKeyVariables, Set<CQLWord> clusteringColumnVariables, ProtocolVersion protocolVersion, Mapping mapping, RecordMetadata recordMetadata, boolean nullToUnset, boolean allowExtraFields, boolean allowMissingFields) {
        this(insertStatement, partitionKeyVariables, clusteringColumnVariables, protocolVersion, mapping, recordMetadata, nullToUnset, allowExtraFields, allowMissingFields, rec$ -> ((PreparedStatement)rec$).boundStatementBuilder(new Object[0]));
    }

    @VisibleForTesting
    DefaultRecordMapper(PreparedStatement insertStatement, Set<CQLWord> partitionKeyVariables, Set<CQLWord> clusteringColumnVariables, ProtocolVersion protocolVersion, Mapping mapping, RecordMetadata recordMetadata, boolean nullToUnset, boolean allowExtraFields, boolean allowMissingFields, Function<PreparedStatement, BoundStatementBuilder> boundStatementBuilderFactory) {
        this.insertStatement = insertStatement;
        this.partitionKeyVariables = ImmutableSet.copyOf(partitionKeyVariables);
        this.clusteringColumnVariables = ImmutableSet.copyOf(clusteringColumnVariables);
        this.protocolVersion = protocolVersion;
        this.mapping = mapping;
        this.recordMetadata = recordMetadata;
        this.nullToUnset = nullToUnset;
        this.allowExtraFields = allowExtraFields;
        this.allowMissingFields = allowMissingFields;
        this.boundStatementBuilderFactory = boundStatementBuilderFactory;
        this.variablesToIndices = this.buildVariablesToIndices();
    }

    @Override
    @NonNull
    public BatchableStatement<?> map(@NonNull Record record) {
        try {
            if (!this.allowMissingFields) {
                this.ensureAllFieldsPresent(record.fields());
            }
            BoundStatementBuilder builder = this.boundStatementBuilderFactory.apply(this.insertStatement);
            ColumnDefinitions variableDefinitions = this.insertStatement.getVariableDefinitions();
            for (Field field : record.fields()) {
                Set variables = this.mapping.fieldToVariables(field);
                if (!variables.isEmpty()) {
                    for (CQLWord variable : variables) {
                        CqlIdentifier name = variable.asIdentifier();
                        DataType cqlType = variableDefinitions.get(name).getType();
                        GenericType fieldType = this.recordMetadata.getFieldType(field, cqlType);
                        Object raw = record.getFieldValue(field);
                        builder = this.bindColumn(builder, field, variable, raw, cqlType, fieldType);
                    }
                    continue;
                }
                if (this.allowExtraFields) continue;
                throw InvalidMappingException.extraneousField(field);
            }
            this.ensurePrimaryKeySet(builder);
            if (this.protocolVersion.getCode() < DefaultProtocolVersion.V4.getCode()) {
                this.ensureAllVariablesSet(builder);
            }
            record.clear();
            BoundStatement bs = builder.build();
            return new MappedBoundStatement(record, bs);
        }
        catch (Exception e) {
            return new UnmappableStatement(record, e);
        }
    }

    private <T> BoundStatementBuilder bindColumn(BoundStatementBuilder builder, Field field, CQLWord variable, @Nullable T raw, DataType cqlType, GenericType<? extends T> javaType) {
        ByteBuffer bb;
        TypeCodec codec = this.mapping.codec(variable, cqlType, javaType);
        try {
            bb = codec.encode(raw, builder.protocolVersion());
        }
        catch (Exception e) {
            throw InvalidMappingException.encodeFailed(field, variable, javaType, cqlType, raw, e);
        }
        boolean isNull = this.isNull(bb, cqlType);
        if ((isNull || this.isEmpty(bb)) && this.partitionKeyVariables.contains((Object)variable)) {
            throw isNull ? InvalidMappingException.nullPrimaryKey(variable) : InvalidMappingException.emptyPrimaryKey(variable);
        }
        if (isNull) {
            if (this.clusteringColumnVariables.contains((Object)variable)) {
                throw InvalidMappingException.nullPrimaryKey(variable);
            }
            if (this.nullToUnset) {
                return builder;
            }
        }
        Iterator iterator = ((List)this.variablesToIndices.get((Object)variable)).iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            builder = builder.setBytesUnsafe(index, bb);
        }
        return builder;
    }

    private boolean isNull(ByteBuffer bb, DataType cqlType) {
        if (bb == null) {
            return true;
        }
        switch (cqlType.getProtocolCode()) {
            case 1: 
            case 3: 
            case 13: {
                return false;
            }
        }
        return !bb.hasRemaining();
    }

    private boolean isEmpty(ByteBuffer bb) {
        return bb == null || !bb.hasRemaining();
    }

    private void ensureAllFieldsPresent(Set<Field> recordFields) {
        ColumnDefinitions variables = this.insertStatement.getVariableDefinitions();
        for (int i = 0; i < variables.size(); ++i) {
            CQLWord variable = CQLWord.fromCqlIdentifier((CqlIdentifier)variables.get(i).getName());
            Set fields = this.mapping.variableToFields(variable);
            for (Field field : fields) {
                if (recordFields.contains(field)) continue;
                throw InvalidMappingException.missingField(field, variable);
            }
        }
    }

    private void ensurePrimaryKeySet(BoundStatementBuilder bs) {
        int index;
        Iterator iterator;
        for (CQLWord variable : this.partitionKeyVariables) {
            iterator = ((List)this.variablesToIndices.get((Object)variable)).iterator();
            while (iterator.hasNext()) {
                index = (Integer)iterator.next();
                if (bs.isSet(index)) continue;
                throw InvalidMappingException.unsetPrimaryKey(variable);
            }
        }
        for (CQLWord variable : this.clusteringColumnVariables) {
            iterator = ((List)this.variablesToIndices.get((Object)variable)).iterator();
            while (iterator.hasNext()) {
                index = (Integer)iterator.next();
                if (bs.isSet(index)) continue;
                throw InvalidMappingException.unsetPrimaryKey(variable);
            }
        }
    }

    private void ensureAllVariablesSet(BoundStatementBuilder bs) {
        ColumnDefinitions variables = this.insertStatement.getVariableDefinitions();
        for (int i = 0; i < variables.size(); ++i) {
            if (bs.isSet(i)) continue;
            bs = (BoundStatementBuilder)bs.setToNull(i);
        }
    }

    private ImmutableMap<CQLWord, List<Integer>> buildVariablesToIndices() {
        HashMap<CQLWord, List> variablesToIndices = new HashMap<CQLWord, List>();
        ColumnDefinitions variables = this.insertStatement.getVariableDefinitions();
        for (int i = 0; i < variables.size(); ++i) {
            CQLWord name = CQLWord.fromCqlIdentifier((CqlIdentifier)variables.get(i).getName());
            List indices = variablesToIndices.computeIfAbsent(name, k -> new ArrayList());
            indices.add(i);
        }
        return ImmutableMap.copyOf(variablesToIndices);
    }
}

