/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.dsbulk.connectors.api.DefaultErrorRecord;
import com.datastax.oss.dsbulk.connectors.api.DefaultRecord;
import com.datastax.oss.dsbulk.connectors.api.Field;
import com.datastax.oss.dsbulk.connectors.api.Record;
import com.datastax.oss.dsbulk.connectors.api.RecordMetadata;
import com.datastax.oss.dsbulk.executor.api.result.ReadResult;
import com.datastax.oss.dsbulk.mapping.CQLWord;
import com.datastax.oss.dsbulk.mapping.Mapping;
import com.datastax.oss.dsbulk.workflow.commons.schema.ReadResultMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import java.util.Set;

public class DefaultReadResultMapper
implements ReadResultMapper {
    private final Mapping mapping;
    private final RecordMetadata recordMetadata;
    private final URI resource;
    private final boolean retainRecordSources;

    public DefaultReadResultMapper(Mapping mapping, RecordMetadata recordMetadata, URI resource, boolean retainRecordSources) {
        this.mapping = mapping;
        this.recordMetadata = recordMetadata;
        this.resource = resource;
        this.retainRecordSources = retainRecordSources;
    }

    @Override
    @NonNull
    public Record map(@NonNull ReadResult result) {
        ReadResult source = this.retainRecordSources ? result : null;
        try {
            Row row = (Row)result.getRow().orElseThrow(IllegalStateException::new);
            ColumnDefinitions columnDefinitions = row.getColumnDefinitions();
            DefaultRecord record = new DefaultRecord((Object)source, this.resource, -1L);
            for (ColumnDefinition def : columnDefinitions) {
                CQLWord variable = CQLWord.fromInternal((String)def.getName().asInternal());
                CqlIdentifier name = variable.asIdentifier();
                DataType cqlType = def.getType();
                Set fields = this.mapping.variableToFields(variable);
                for (Field field : fields) {
                    GenericType fieldType = null;
                    try {
                        fieldType = this.recordMetadata.getFieldType(field, cqlType);
                        TypeCodec codec = this.mapping.codec(variable, cqlType, fieldType);
                        Object value = row.get(name, codec);
                        record.setFieldValue(field, value);
                    }
                    catch (Exception e) {
                        String msg = String.format("Could not deserialize column %s of type %s as %s", name.asCql(true), cqlType, fieldType);
                        throw new IllegalArgumentException(msg, e);
                    }
                }
            }
            return record;
        }
        catch (Exception e) {
            return new DefaultErrorRecord((Object)source, this.resource, -1L, (Throwable)e);
        }
    }
}

