/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Functions;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecFactory;
import com.datastax.oss.dsbulk.executor.api.result.ReadResult;
import com.datastax.oss.dsbulk.partitioner.utils.TokenUtils;
import com.datastax.oss.dsbulk.workflow.commons.schema.ReadResultCounter;
import com.datastax.oss.dsbulk.workflow.commons.settings.StatsSettings;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class DefaultReadResultCounter
implements ReadResultCounter {
    private static final BiFunction<Long, Long, Long> SUM = Long::sum;
    private final int numPartitions;
    private final ProtocolVersion protocolVersion;
    private final ConvertingCodecFactory codecFactory;
    private final TokenMap tokenMap;
    private final Set<TokenRange> allTokenRanges;
    private final Set<EndPoint> allAddresses;
    private final Token[] ring;
    private final ReplicaSet[] replicaSets;
    private final CopyOnWriteArrayList<DefaultCountingUnit> units = new CopyOnWriteArrayList();
    private final boolean countGlobal;
    private final boolean countNodes;
    private final boolean countRanges;
    private final boolean countPartitions;
    private final boolean multiCount;
    @VisibleForTesting
    long totalRows;
    @VisibleForTesting
    Map<TokenRange, Long> totalsByRange;
    @VisibleForTesting
    Map<EndPoint, Long> totalsByNode;
    @VisibleForTesting
    List<PartitionKeyCount> totalsByPartitionKey;

    public DefaultReadResultCounter(CqlIdentifier keyspace, Metadata metadata, EnumSet<StatsSettings.StatisticsMode> modes, int numPartitions, ProtocolVersion protocolVersion, ConvertingCodecFactory codecFactory) {
        this.tokenMap = (TokenMap)metadata.getTokenMap().orElseThrow(() -> new IllegalStateException("Token metadata not present"));
        this.numPartitions = numPartitions;
        this.protocolVersion = protocolVersion;
        this.codecFactory = codecFactory;
        this.countGlobal = modes.contains((Object)StatsSettings.StatisticsMode.global);
        this.countNodes = modes.contains((Object)StatsSettings.StatisticsMode.hosts);
        this.countRanges = modes.contains((Object)StatsSettings.StatisticsMode.ranges);
        this.countPartitions = modes.contains((Object)StatsSettings.StatisticsMode.partitions);
        boolean bl = this.multiCount = modes.size() > 1;
        if (this.countNodes || this.countRanges) {
            Set ranges = metadata.getTokenMap().map(TokenMap::getTokenRanges).orElse(Collections.emptySet());
            this.ring = new Token[ranges.size()];
            this.replicaSets = new ReplicaSet[ranges.size()];
            int i = 0;
            Map rangesByEndingToken = ranges.stream().collect(Collectors.toMap(TokenRange::getEnd, Functions.identity()));
            for (TokenRange r1 : ranges) {
                this.ring[i] = r1.getStart();
                TokenRange r2 = (TokenRange)rangesByEndingToken.get(r1.getStart());
                this.replicaSets[i] = new ReplicaSet(r2, this.tokenMap.getReplicas(keyspace, r2));
                ++i;
            }
            this.allTokenRanges = this.countRanges ? new TreeSet(ranges) : null;
            if (this.countNodes) {
                this.allAddresses = new TreeSet<EndPoint>(Comparator.comparing(Object::toString));
                metadata.getNodes().values().stream().map(Node::getEndPoint).forEach(this.allAddresses::add);
            } else {
                this.allAddresses = null;
            }
        } else {
            this.ring = null;
            this.replicaSets = null;
            this.allTokenRanges = null;
            this.allAddresses = null;
        }
    }

    @Override
    public DefaultCountingUnit newCountingUnit() {
        DefaultCountingUnit unit = new DefaultCountingUnit();
        this.units.add(unit);
        return unit;
    }

    @Override
    public void close() {
        this.consolidateUnitCounts();
    }

    @VisibleForTesting
    void consolidateUnitCounts() {
        this.totalRows = 0L;
        this.totalsByRange = new HashMap<TokenRange, Long>();
        this.totalsByNode = new HashMap<EndPoint, Long>();
        this.totalsByPartitionKey = new ArrayList<PartitionKeyCount>();
        for (DefaultCountingUnit unit : this.units) {
            unit.close();
            this.totalRows += unit.total;
            unit.totalsByNode.forEach((key, value) -> this.totalsByNode.merge((EndPoint)key, (Long)value, SUM));
            unit.totalsByRange.forEach((key, value) -> this.totalsByRange.merge((TokenRange)key, (Long)value, SUM));
            this.totalsByPartitionKey.addAll(unit.totalsByPartitionKey);
        }
        this.totalsByPartitionKey.sort(Collections.reverseOrder());
        this.totalsByPartitionKey = this.totalsByPartitionKey.size() > this.numPartitions ? this.totalsByPartitionKey.subList(0, this.numPartitions) : this.totalsByPartitionKey;
    }

    @Override
    public void reportTotals() {
        PrintStream out = System.out;
        if (this.countGlobal) {
            if (this.multiCount) {
                out.println("Total rows:");
            }
            out.println(this.totalRows);
        }
        if (this.countNodes) {
            if (this.multiCount) {
                out.println("Total rows per node:");
            }
            this.allAddresses.forEach(node -> {
                long totalPerNode = this.totalsByNode.containsKey(node) ? this.totalsByNode.get(node) : 0L;
                float percentage = (float)totalPerNode / (float)this.totalRows * 100.0f;
                out.printf("%s %d %.2f%n", node, totalPerNode, Float.valueOf(percentage));
            });
        }
        if (this.countRanges) {
            if (this.multiCount) {
                out.println("Total rows per token range:");
            }
            this.allTokenRanges.forEach(range -> {
                long totalPerRange = this.totalsByRange.containsKey(range) ? this.totalsByRange.get(range) : 0L;
                float percentage = (float)totalPerRange / (float)this.totalRows * 100.0f;
                out.printf("%s %s %d %.2f%n", TokenUtils.getTokenValue((Token)range.getStart()), TokenUtils.getTokenValue((Token)range.getEnd()), totalPerRange, Float.valueOf(percentage));
            });
        }
        if (this.countPartitions) {
            if (this.multiCount) {
                out.println("Total rows per partition:");
            }
            this.totalsByPartitionKey.forEach(count -> {
                float percentage = (float)count.count / (float)this.totalRows * 100.0f;
                out.printf("%s %d %.2f%n", count.pk, count.count, Float.valueOf(percentage));
            });
        }
    }

    private static class ReplicaSet {
        final TokenRange range;
        final EndPoint[] addresses;

        ReplicaSet(TokenRange range, Set<Node> addresses) {
            this.range = range;
            this.addresses = (EndPoint[])addresses.stream().map(Node::getEndPoint).toArray(EndPoint[]::new);
        }
    }

    @VisibleForTesting
    static class PartitionKeyCount
    implements Comparable<PartitionKeyCount> {
        final PartitionKey pk;
        final long count;

        PartitionKeyCount(PartitionKey pk, long currentCount) {
            this.pk = pk;
            this.count = currentCount;
        }

        @Override
        public int compareTo(@NonNull PartitionKeyCount that) {
            return Long.compare(this.count, that.count);
        }
    }

    @VisibleForTesting
    class PartitionKey {
        final ByteBuffer[] components;
        final DataType[] types;
        final int hashCode;

        PartitionKey(ColumnDefinitions definitions, ByteBuffer ... components) {
            this.components = components;
            this.hashCode = Arrays.hashCode(components);
            this.types = new DataType[components.length];
            for (int i = 0; i < components.length; ++i) {
                this.types[i] = definitions.get(i).getType();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PartitionKey)) {
                return false;
            }
            PartitionKey that = (PartitionKey)o;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            return Arrays.equals(this.components, that.components);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.components.length; ++i) {
                if (i > 0) {
                    sb.append('|');
                }
                TypeCodec codec = DefaultReadResultCounter.this.codecFactory.getCodecRegistry().codecFor(this.types[i]);
                Object o = codec.decode(this.components[i], DefaultReadResultCounter.this.protocolVersion);
                sb.append(codec.format(o));
            }
            return sb.toString().replace(' ', '_');
        }
    }

    @VisibleForTesting
    class DefaultCountingUnit
    implements ReadResultCounter.CountingUnit {
        long total = 0L;
        final Map<TokenRange, Long> totalsByRange = new HashMap<TokenRange, Long>();
        final Map<EndPoint, Long> totalsByNode = new HashMap<EndPoint, Long>();
        final List<PartitionKeyCount> totalsByPartitionKey = new ArrayList<PartitionKeyCount>(DefaultReadResultCounter.access$000(DefaultReadResultCounter.this) + 1);
        long currentPkCount = 0L;
        PartitionKey currentPk;

        DefaultCountingUnit() {
        }

        @Override
        public void update(ReadResult result) {
            Row row = (Row)result.getRow().orElseThrow(IllegalStateException::new);
            Token token = null;
            PartitionKey pk = null;
            if (DefaultReadResultCounter.this.countPartitions) {
                int size = row.getColumnDefinitions().size();
                ByteBuffer[] bbs = new ByteBuffer[size];
                for (int i = 0; i < size; ++i) {
                    bbs[i] = row.getBytesUnsafe(i);
                }
                if (DefaultReadResultCounter.this.countRanges || DefaultReadResultCounter.this.countNodes) {
                    token = DefaultReadResultCounter.this.tokenMap.newToken(bbs);
                }
                pk = new PartitionKey(row.getColumnDefinitions(), bbs);
            } else if (DefaultReadResultCounter.this.countRanges || DefaultReadResultCounter.this.countNodes) {
                token = row.getToken(0);
            }
            ++this.total;
            if (DefaultReadResultCounter.this.countRanges || DefaultReadResultCounter.this.countNodes) {
                ReplicaSet replicaSet = this.getReplicaSet(token);
                if (DefaultReadResultCounter.this.countRanges) {
                    this.totalsByRange.merge(replicaSet.range, 1L, SUM);
                }
                if (DefaultReadResultCounter.this.countNodes) {
                    for (EndPoint address : replicaSet.addresses) {
                        this.totalsByNode.merge(address, 1L, SUM);
                    }
                }
            }
            if (DefaultReadResultCounter.this.countPartitions) {
                if (this.currentPk == null) {
                    this.currentPk = pk;
                }
                if (!this.currentPk.equals(pk)) {
                    this.rotatePk();
                    this.currentPk = pk;
                    this.currentPkCount = 1L;
                } else {
                    ++this.currentPkCount;
                }
            }
        }

        @Override
        public void close() {
            this.rotatePk();
        }

        private ReplicaSet getReplicaSet(Token token) {
            assert (DefaultReadResultCounter.this.ring != null);
            assert (DefaultReadResultCounter.this.replicaSets != null);
            int i = Arrays.binarySearch(DefaultReadResultCounter.this.ring, token);
            if (i < 0 && (i = -i - 1) >= DefaultReadResultCounter.this.ring.length) {
                i = 0;
            }
            return DefaultReadResultCounter.this.replicaSets[i];
        }

        void rotatePk() {
            if (this.currentPk != null) {
                long lowestPkCount;
                long l = lowestPkCount = this.totalsByPartitionKey.isEmpty() ? 0L : this.totalsByPartitionKey.get((int)0).count;
                if (this.currentPkCount > lowestPkCount || this.totalsByPartitionKey.size() < DefaultReadResultCounter.this.numPartitions) {
                    PartitionKeyCount pkc = new PartitionKeyCount(this.currentPk, this.currentPkCount);
                    int pos = Collections.binarySearch(this.totalsByPartitionKey, pkc);
                    if (pos < 0) {
                        pos = -pos - 1;
                    }
                    this.totalsByPartitionKey.add(pos, pkc);
                    if (this.totalsByPartitionKey.size() > DefaultReadResultCounter.this.numPartitions) {
                        this.totalsByPartitionKey.remove(0);
                    }
                }
                this.currentPk = null;
            }
        }
    }
}

