/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.policies.retry;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.connection.ClosedConnectionException;
import com.datastax.oss.driver.api.core.connection.HeartbeatException;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.ReadFailureException;
import com.datastax.oss.driver.api.core.servererrors.WriteFailureException;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.dsbulk.workflow.commons.settings.BulkDriverOption;
import edu.umd.cs.findbugs.annotations.NonNull;

public class MultipleRetryPolicy
implements RetryPolicy {
    private final int maxRetryCount;

    public MultipleRetryPolicy(DriverContext context, String profileName) {
        this.maxRetryCount = context.getConfig().getProfile(profileName).getInt((DriverOption)BulkDriverOption.RETRY_POLICY_MAX_RETRIES, 10);
    }

    @Deprecated
    public RetryDecision onReadTimeout(@NonNull Request request, @NonNull ConsistencyLevel cl, int blockFor, int received, boolean dataPresent, int retryCount) {
        return retryCount < this.maxRetryCount ? RetryDecision.RETRY_SAME : RetryDecision.RETHROW;
    }

    @Deprecated
    public RetryDecision onWriteTimeout(@NonNull Request request, @NonNull ConsistencyLevel cl, @NonNull WriteType writeType, int blockFor, int received, int retryCount) {
        return retryCount < this.maxRetryCount ? RetryDecision.RETRY_SAME : RetryDecision.RETHROW;
    }

    @Deprecated
    public RetryDecision onUnavailable(@NonNull Request request, @NonNull ConsistencyLevel cl, int required, int alive, int retryCount) {
        return retryCount < this.maxRetryCount ? RetryDecision.RETRY_NEXT : RetryDecision.RETHROW;
    }

    @Deprecated
    public RetryDecision onRequestAborted(@NonNull Request request, @NonNull Throwable error, int retryCount) {
        return error instanceof ClosedConnectionException || error instanceof HeartbeatException ? RetryDecision.RETRY_NEXT : RetryDecision.RETHROW;
    }

    @Deprecated
    public RetryDecision onErrorResponse(@NonNull Request request, @NonNull CoordinatorException error, int retryCount) {
        return error instanceof ReadFailureException || error instanceof WriteFailureException ? RetryDecision.RETHROW : RetryDecision.RETRY_NEXT;
    }

    public void close() {
    }
}

