/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.policies.lbp;

import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.ContactPoints;
import com.datastax.oss.dsbulk.workflow.commons.settings.BulkDriverOption;
import com.datastax.oss.dsbulk.workflow.commons.utils.AddressUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SimpleNodeFilter
implements Predicate<Node> {
    private final Set<EndPoint> includedHosts;
    private final Set<EndPoint> excludedHosts;

    public SimpleNodeFilter(DriverContext context, String profileName) {
        this(SimpleNodeFilter.resolveHosts(context, profileName, BulkDriverOption.LOAD_BALANCING_POLICY_FILTER_ALLOW), SimpleNodeFilter.resolveHosts(context, profileName, BulkDriverOption.LOAD_BALANCING_POLICY_FILTER_DENY));
    }

    public SimpleNodeFilter(Set<EndPoint> includedHosts, Set<EndPoint> excludedHosts) {
        this.includedHosts = includedHosts;
        this.excludedHosts = excludedHosts;
    }

    private static Set<EndPoint> resolveHosts(DriverContext context, String profileName, BulkDriverOption option) {
        DriverExecutionProfile profile = context.getConfig().getProfile(profileName);
        int defaultPort = profile.getInt((DriverOption)BulkDriverOption.DEFAULT_PORT);
        List hosts = profile.getStringList((DriverOption)option).stream().map(host -> AddressUtils.maybeAddPortToHost(host, defaultPort)).collect(Collectors.toList());
        return ContactPoints.merge(Collections.emptySet(), hosts, (boolean)true);
    }

    @Override
    public boolean test(Node node) {
        return this.isIncluded(node) && this.isNotExcluded(node);
    }

    private boolean isIncluded(Node node) {
        return this.includedHosts.isEmpty() || this.includedHosts.contains(node.getEndPoint());
    }

    private boolean isNotExcluded(Node node) {
        return !this.excludedHosts.contains(node.getEndPoint());
    }
}

