/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.datastax.oss.dsbulk.executor.api.listener.LogSink;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RecordReporter
extends ScheduledReporter {
    private final String msg;
    private final long expectedTotal;
    private final LogSink sink;

    RecordReporter(MetricRegistry registry, LogSink sink, TimeUnit rateUnit, ScheduledExecutorService scheduler, long expectedTotal) {
        super(registry, "record-reporter", RecordReporter.createFilter(), rateUnit, TimeUnit.MILLISECONDS, scheduler);
        this.sink = sink;
        this.expectedTotal = expectedTotal;
        if (expectedTotal < 0L) {
            this.msg = "Records: total: %,d, successful: %,d, failed: %,d";
        } else {
            int numDigits = String.format("%,d", expectedTotal).length();
            this.msg = "Records: total: %," + numDigits + "d, successful: %," + numDigits + "d, failed: %,d, progression: %,.0f%%";
        }
    }

    private static MetricFilter createFilter() {
        return (name, metric) -> name.equals("records/total") || name.equals("records/failed");
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        if (!this.sink.isEnabled()) {
            return;
        }
        Counter totalCounter = (Counter)counters.get("records/total");
        Counter failedCounter = (Counter)counters.get("records/failed");
        if (this.expectedTotal < 0L) {
            this.reportWithoutExpectedTotal(totalCounter, failedCounter);
        } else {
            this.reportWithExpectedTotal(totalCounter, failedCounter);
        }
    }

    private void reportWithoutExpectedTotal(Counter totalCounter, Counter failedCounter) {
        long total = totalCounter.getCount();
        long failed = failedCounter.getCount();
        this.sink.accept(String.format(this.msg, total, total - failed, failed), new Object[0]);
    }

    private void reportWithExpectedTotal(Counter totalCounter, Counter failedCounter) {
        long total = totalCounter.getCount();
        long failed = failedCounter.getCount();
        float progression = (float)total / (float)this.expectedTotal * 100.0f;
        this.sink.accept(String.format(this.msg, total, total - failed, failed, Float.valueOf(progression)), new Object[0]);
    }
}

