/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.UniformReservoir;
import com.codahale.metrics.jmx.JmxReporter;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.MoreExecutors;
import com.datastax.oss.dsbulk.connectors.api.ErrorRecord;
import com.datastax.oss.dsbulk.executor.api.listener.AbstractMetricsReportingExecutionListenerBuilder;
import com.datastax.oss.dsbulk.executor.api.listener.LogSink;
import com.datastax.oss.dsbulk.executor.api.listener.MetricsCollectingExecutionListener;
import com.datastax.oss.dsbulk.executor.api.listener.ReadsReportingExecutionListener;
import com.datastax.oss.dsbulk.executor.api.listener.WritesReportingExecutionListener;
import com.datastax.oss.dsbulk.executor.api.result.Result;
import com.datastax.oss.dsbulk.workflow.commons.metrics.BatchReporter;
import com.datastax.oss.dsbulk.workflow.commons.metrics.ConsoleReporter;
import com.datastax.oss.dsbulk.workflow.commons.metrics.MemoryReporter;
import com.datastax.oss.dsbulk.workflow.commons.metrics.RecordReporter;
import com.datastax.oss.dsbulk.workflow.commons.settings.LogSettings;
import com.datastax.oss.dsbulk.workflow.commons.settings.RowType;
import com.datastax.oss.dsbulk.workflow.commons.statement.UnmappableStatement;
import com.datastax.oss.dsbulk.workflow.commons.utils.JMXUtils;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.time.Duration;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.BasicMarkerFactory;
import reactor.core.publisher.Flux;

public class MetricsManager
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsManager.class);
    private static final Marker METRICS_MARKER = new BasicMarkerFactory().getMarker("METRICS");
    private static final String DSBULK_JMX_DOMAIN = "com.datastax.oss.dsbulk";
    private final MetricRegistry registry;
    private final MetricsCollectingExecutionListener listener;
    private final boolean monitorWrites;
    private final String executionId;
    private final ScheduledExecutorService scheduler;
    private final TimeUnit rateUnit;
    private final TimeUnit durationUnit;
    private final long expectedWrites;
    private final long expectedReads;
    private final boolean jmx;
    private final boolean csv;
    private final boolean console;
    private final Path operationDirectory;
    private final Duration reportInterval;
    private final boolean batchingEnabled;
    private final LogSettings.Verbosity verbosity;
    private final RowType rowType;
    private Counter totalItems;
    private Counter failedItems;
    private Histogram batchSize;
    private RecordReporter recordReporter;
    private BatchReporter batchesReporter;
    private MemoryReporter memoryReporter;
    private WritesReportingExecutionListener writesReporter;
    private ReadsReportingExecutionListener readsReporter;
    private JmxReporter jmxReporter;
    private CsvReporter csvReporter;
    private ConsoleReporter consoleReporter;
    private LogSink logSink;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public MetricsManager(MetricRegistry driverRegistry, boolean monitorWrites, String executionId, ScheduledExecutorService scheduler, TimeUnit rateUnit, TimeUnit durationUnit, long expectedWrites, long expectedReads, boolean trackBytes, boolean jmx, boolean csv, boolean console, Path operationDirectory, LogSettings.Verbosity verbosity, Duration reportInterval, boolean batchingEnabled, ProtocolVersion protocolVersion, CodecRegistry codecRegistry, RowType rowType) {
        this.registry = new MetricRegistry();
        driverRegistry.getMetrics().forEach((name, metric) -> this.registry.register("driver/" + name, metric));
        this.monitorWrites = monitorWrites;
        this.listener = new MetricsCollectingExecutionListener(this.registry, protocolVersion, codecRegistry, trackBytes);
        this.executionId = executionId;
        this.scheduler = scheduler;
        this.rateUnit = rateUnit;
        this.durationUnit = durationUnit;
        this.expectedWrites = expectedWrites;
        this.expectedReads = expectedReads;
        this.jmx = jmx;
        this.csv = csv;
        this.console = console;
        this.operationDirectory = operationDirectory;
        this.verbosity = verbosity;
        this.reportInterval = reportInterval;
        this.batchingEnabled = batchingEnabled;
        this.rowType = rowType;
    }

    public void init() {
        this.totalItems = this.registry.counter("records/total");
        this.failedItems = this.registry.counter("records/failed");
        this.batchSize = this.registry.histogram("batches/size", () -> new Histogram((Reservoir)new UniformReservoir()));
        this.createMemoryGauges();
        this.logSink = new LogSink(){

            public boolean isEnabled() {
                return MetricsManager.this.running.get() ? LOGGER.isDebugEnabled() : LOGGER.isInfoEnabled();
            }

            public void accept(String message, Object ... args) {
                if (MetricsManager.this.running.get()) {
                    LOGGER.debug(METRICS_MARKER, message, args);
                } else {
                    LOGGER.info(METRICS_MARKER, message, args);
                }
            }
        };
    }

    public void start() {
        this.running.set(true);
        if (this.jmx) {
            this.startJMXReporter();
        }
        if (this.csv) {
            this.startCSVReporter();
        }
        if (this.verbosity.compareTo(LogSettings.Verbosity.quiet) > 0) {
            if (this.console) {
                this.startConsoleReporter();
            }
            this.startMemoryReporter();
            this.startRecordReporter();
            if (this.monitorWrites) {
                if (this.batchingEnabled) {
                    this.startBatchesReporter();
                }
                this.startWritesReporter();
            } else {
                this.startReadsReporter();
            }
        }
    }

    private void createMemoryGauges() {
        long bytesPerMeg = 0x100000L;
        this.registry.gauge("memory/used", () -> () -> {
            Runtime runtime = Runtime.getRuntime();
            return (runtime.totalMemory() - runtime.freeMemory()) / bytesPerMeg;
        });
        this.registry.gauge("memory/free", () -> () -> {
            Runtime runtime = Runtime.getRuntime();
            return runtime.freeMemory() / bytesPerMeg;
        });
        this.registry.gauge("memory/allocated", () -> () -> {
            Runtime runtime = Runtime.getRuntime();
            return runtime.totalMemory() / bytesPerMeg;
        });
        this.registry.gauge("memory/available", () -> () -> {
            Runtime runtime = Runtime.getRuntime();
            return runtime.maxMemory() / bytesPerMeg;
        });
        this.registry.gauge("memory/gc_count", () -> () -> {
            long total = 0L;
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                long count = gc.getCollectionCount();
                if (count < 0L) continue;
                total += count;
            }
            return total;
        });
        this.registry.gauge("memory/gc_time", () -> () -> {
            long gcTime = 0L;
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                long time = gc.getCollectionTime();
                if (time < 0L) continue;
                gcTime += time;
            }
            return gcTime;
        });
    }

    private void startJMXReporter() {
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.registry).convertDurationsTo(this.durationUnit).convertRatesTo(this.rateUnit).inDomain(DSBULK_JMX_DOMAIN).createsObjectNamesWith((metricsType, jmxDomain, metricName) -> {
            try {
                StringBuilder sb = new StringBuilder(jmxDomain).append(":executionId=").append(JMXUtils.quoteJMXIfNecessary(this.executionId)).append(',');
                StringTokenizer tokenizer = new StringTokenizer(metricName, "/");
                int i = 1;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (tokenizer.hasMoreTokens()) {
                        sb.append("level").append(i++);
                    } else {
                        sb.append("name");
                    }
                    sb.append('=').append(JMXUtils.quoteJMXIfNecessary(token));
                    if (!tokenizer.hasMoreTokens()) continue;
                    sb.append(',');
                }
                return ObjectName.getInstance(sb.toString());
            }
            catch (MalformedObjectNameException e) {
                throw new RuntimeException(e);
            }
        }).build();
        this.jmxReporter.start();
    }

    private void startCSVReporter() {
        this.csvReporter = CsvReporter.forRegistry((MetricRegistry)this.registry).convertDurationsTo(this.durationUnit).convertRatesTo(this.rateUnit).build(this.operationDirectory.toFile());
        this.csvReporter.start(this.reportInterval.getSeconds(), TimeUnit.SECONDS);
    }

    private void startRecordReporter() {
        this.recordReporter = new RecordReporter(this.registry, this.logSink, this.rateUnit, this.scheduler, this.expectedWrites);
        if (this.verbosity.compareTo(LogSettings.Verbosity.normal) > 0) {
            this.recordReporter.start(this.reportInterval.getSeconds(), TimeUnit.SECONDS);
        }
    }

    private void startBatchesReporter() {
        this.batchesReporter = new BatchReporter(this.registry, this.logSink, this.scheduler);
        if (this.verbosity.compareTo(LogSettings.Verbosity.normal) > 0) {
            this.batchesReporter.start(this.reportInterval.getSeconds(), TimeUnit.SECONDS);
        }
    }

    private void startMemoryReporter() {
        this.memoryReporter = new MemoryReporter(this.registry, this.logSink, this.scheduler);
        if (this.verbosity.compareTo(LogSettings.Verbosity.normal) > 0) {
            this.memoryReporter.start(this.reportInterval.getSeconds(), TimeUnit.SECONDS);
        }
    }

    private void startWritesReporter() {
        AbstractMetricsReportingExecutionListenerBuilder builder = WritesReportingExecutionListener.builder().withScheduler(this.scheduler).withLogSink(this.logSink).convertRatesTo(this.rateUnit).convertDurationsTo(this.durationUnit).extractingMetricsFrom(this.listener);
        if (this.expectedWrites > 0L) {
            builder.expectingTotalEvents(this.expectedWrites);
        }
        this.writesReporter = (WritesReportingExecutionListener)builder.build();
        if (this.verbosity.compareTo(LogSettings.Verbosity.normal) > 0) {
            this.writesReporter.start(this.reportInterval.getSeconds(), TimeUnit.SECONDS);
        }
    }

    private void startReadsReporter() {
        AbstractMetricsReportingExecutionListenerBuilder builder = ReadsReportingExecutionListener.builder().withScheduler(this.scheduler).withLogSink(this.logSink).convertRatesTo(this.rateUnit).convertDurationsTo(this.durationUnit).extractingMetricsFrom(this.listener);
        if (this.expectedReads > 0L) {
            builder.expectingTotalEvents(this.expectedReads);
        }
        this.readsReporter = (ReadsReportingExecutionListener)builder.build();
        if (this.verbosity.compareTo(LogSettings.Verbosity.normal) > 0) {
            this.readsReporter.start(this.reportInterval.getSeconds(), TimeUnit.SECONDS);
        }
    }

    private void startConsoleReporter() {
        if (this.monitorWrites) {
            this.registry.counter("records/failed");
            this.consoleReporter = new ConsoleReporter(this.registry, this.running, () -> this.totalItems.getCount(), () -> this.failedItems.getCount(), this.listener.getTotalWritesTimer(), this.listener.getBytesSentMeter().orElse(null), this.batchingEnabled ? this.registry.histogram("batches/size") : null, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, this.expectedWrites, this.scheduler, this.rowType);
        } else {
            this.consoleReporter = new ConsoleReporter(this.registry, this.running, () -> this.totalItems.getCount(), () -> this.failedItems.getCount(), this.listener.getTotalReadsTimer(), this.listener.getBytesReceivedMeter().orElse(null), null, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, this.expectedReads, this.scheduler, this.rowType);
        }
        this.consoleReporter.start(this.reportInterval.getSeconds(), TimeUnit.SECONDS);
    }

    public void stop() {
        if (this.consoleReporter != null) {
            this.consoleReporter.report();
            this.consoleReporter = null;
        }
        this.running.set(false);
    }

    @Override
    public void close() {
        this.stop();
        if (this.consoleReporter != null) {
            this.consoleReporter.close();
        }
        if (this.jmxReporter != null) {
            this.jmxReporter.close();
        }
        if (this.csvReporter != null) {
            this.csvReporter.close();
        }
        if (this.recordReporter != null) {
            this.recordReporter.close();
        }
        if (this.batchesReporter != null) {
            this.batchesReporter.close();
        }
        if (this.memoryReporter != null) {
            this.memoryReporter.close();
        }
        if (this.writesReporter != null) {
            this.writesReporter.close();
        }
        if (this.readsReporter != null) {
            this.readsReporter.close();
        }
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.scheduler, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    public void reportFinalMetrics() {
        if (this.recordReporter != null || this.batchesReporter != null || this.memoryReporter != null || this.writesReporter != null || this.readsReporter != null) {
            LOGGER.info(METRICS_MARKER, "Final stats:");
            if (this.recordReporter != null) {
                this.recordReporter.report();
            }
            if (this.batchesReporter != null) {
                this.batchesReporter.report();
            }
            if (this.memoryReporter != null) {
                this.memoryReporter.report();
            }
            if (this.writesReporter != null) {
                this.writesReporter.report();
            }
            if (this.readsReporter != null) {
                this.readsReporter.report();
            }
        }
    }

    public <T> Function<Flux<T>, Flux<T>> newTotalItemsMonitor() {
        return upstream -> upstream.doOnNext(item -> this.totalItems.inc());
    }

    public <T> Function<Flux<T>, Flux<T>> newFailedItemsMonitor() {
        return upstream -> upstream.doOnNext(item -> {
            if (item instanceof ErrorRecord || item instanceof UnmappableStatement || item instanceof Result && !((Result)item).isSuccess()) {
                this.failedItems.inc();
            }
        });
    }

    public Function<Flux<Statement<?>>, Flux<Statement<?>>> newBatcherMonitor() {
        return upstream -> upstream.doOnNext(stmt -> {
            if (stmt instanceof BatchStatement) {
                this.batchSize.update(((BatchStatement)stmt).size());
            } else {
                this.batchSize.update(1);
            }
        });
    }

    public MetricsCollectingExecutionListener getExecutionListener() {
        return this.listener;
    }
}

