/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.datastax.oss.dsbulk.executor.api.listener.LogSink;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MemoryReporter
extends ScheduledReporter {
    private static final String MSG = "Memory usage: used: %,d MB, free: %,d MB, allocated: %,d MB, available: %,d MB, total gc count: %,d, total gc time: %,d ms";
    private final LogSink sink;

    MemoryReporter(MetricRegistry registry, LogSink sink, ScheduledExecutorService scheduler) {
        super(registry, "memory-reporter", MemoryReporter.createFilter(), TimeUnit.SECONDS, TimeUnit.MILLISECONDS, scheduler);
        this.sink = sink;
    }

    private static MetricFilter createFilter() {
        return (name, metric) -> name.equals("memory/used") || name.equals("memory/free") || name.equals("memory/allocated") || name.equals("memory/available") || name.equals("memory/gc_count") || name.equals("memory/gc_time");
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        if (!this.sink.isEnabled()) {
            return;
        }
        Gauge freeMemoryGauge = (Gauge)gauges.get("memory/free");
        Gauge allocatedMemoryGauge = (Gauge)gauges.get("memory/allocated");
        Gauge usedMemoryGauge = (Gauge)gauges.get("memory/used");
        Gauge availableMemoryGauge = (Gauge)gauges.get("memory/available");
        Gauge gcCountGauge = (Gauge)gauges.get("memory/gc_count");
        Gauge gcTimeGauge = (Gauge)gauges.get("memory/gc_time");
        long usedMemory = (Long)usedMemoryGauge.getValue();
        long freeMemory = (Long)freeMemoryGauge.getValue();
        long allocatedMemory = (Long)allocatedMemoryGauge.getValue();
        long availableMemory = (Long)availableMemoryGauge.getValue();
        long gcCount = (Long)gcCountGauge.getValue();
        long gcTime = (Long)gcTimeGauge.getValue();
        this.sink.accept(String.format(MSG, usedMemory, freeMemory, allocatedMemory, availableMemory, gcCount, gcTime), new Object[0]);
    }
}

