/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.datastax.oss.dsbulk.workflow.api.utils.ConsoleUtils;
import com.datastax.oss.dsbulk.workflow.commons.settings.RowType;
import com.datastax.oss.dsbulk.workflow.commons.utils.StringUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class ConsoleReporter
extends ScheduledReporter {
    private static final String REPORTER_NAME = "console-reporter";
    private static final double BYTES_PER_KB = 1024.0;
    private static final double BYTES_PER_MB = 1048576.0;
    private final long expectedTotal;
    private final AtomicBoolean running;
    private final Supplier<Long> total;
    private final Supplier<Long> failed;
    private final Timer timer;
    @Nullable
    private final Meter bytes;
    @Nullable
    private final Histogram batchSizes;
    private final InterceptingPrintStream stderr;
    private final String rateUnit;
    private final String durationUnit;
    private final RowType rowType;

    ConsoleReporter(MetricRegistry registry, AtomicBoolean running, Supplier<Long> total, Supplier<Long> failed, Timer timer, @Nullable Meter bytes, @Nullable Histogram batchSizes, TimeUnit rateUnit, TimeUnit durationUnit, long expectedTotal, ScheduledExecutorService scheduler, RowType rowType) {
        super(registry, REPORTER_NAME, (name, metric) -> true, rateUnit, durationUnit, scheduler);
        this.running = running;
        this.total = total;
        this.failed = failed;
        this.timer = timer;
        this.bytes = bytes;
        this.batchSizes = batchSizes;
        this.expectedTotal = expectedTotal;
        this.rateUnit = ConsoleReporter.getAbbreviatedUnit(rateUnit);
        this.durationUnit = ConsoleReporter.getAbbreviatedUnit(durationUnit);
        this.rowType = rowType;
        AnsiConsole.systemInstall();
        this.stderr = new InterceptingPrintStream((OutputStream)System.err);
        System.setErr(this.stderr);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        if (!this.running.get()) {
            return;
        }
        new ConsoleReport().print();
    }

    private static String getAbbreviatedUnit(TimeUnit rateUnit) {
        switch (rateUnit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "m";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new IllegalArgumentException();
    }

    private static class InterceptingPrintStream
    extends PrintStream {
        private boolean stale = true;

        private InterceptingPrintStream(OutputStream out) {
            super(out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(String x) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.println(x);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(boolean b) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.print(b);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(char c) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.print(c);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(int i) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.print(i);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(long l) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.print(l);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(float f) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.print(f);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(double d) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.print(d);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(@NonNull char[] s) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.print(s);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(String s) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.print(s);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(Object obj) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.print(obj);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println() {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.println();
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(boolean x) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.println(x);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(char x) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.println(x);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(int x) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.println(x);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(long x) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.println(x);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(float x) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.println(x);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(double x) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.println(x);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(@NonNull char[] x) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.println(x);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void println(Object x) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.println(x);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PrintStream printf(@NonNull String format, Object ... args) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.printf(format, args);
                this.stale = true;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PrintStream printf(Locale l, @NonNull String format, Object ... args) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.printf(l, format, args);
                this.stale = true;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PrintStream format(@NonNull String format, Object ... args) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.format(format, args);
                this.stale = true;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PrintStream format(Locale l, @NonNull String format, Object ... args) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.format(l, format, args);
                this.stale = true;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.write(b);
                this.stale = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(@NonNull byte[] buf, int off, int len) {
            InterceptingPrintStream interceptingPrintStream = this;
            synchronized (interceptingPrintStream) {
                super.write(buf, off, len);
                this.stale = true;
            }
        }
    }

    private class ConsoleReport {
        Ansi header = Ansi.ansi();
        Ansi message = Ansi.ansi();

        private ConsoleReport() {
            long totalSoFar = (Long)ConsoleReporter.this.total.get();
            long failedSoFar = (Long)ConsoleReporter.this.failed.get();
            this.appendTotals(totalSoFar, failedSoFar);
            if (ConsoleReporter.this.expectedTotal != -1L) {
                this.appendPercentageAchieved(totalSoFar);
            }
            if (this.hasMoreSpace()) {
                double throughputInRows = ConsoleReporter.this.timer.getMeanRate();
                this.appendThroughputInRows(throughputInRows);
                if (ConsoleReporter.this.bytes != null) {
                    double throughputInBytes = ConsoleReporter.this.bytes.getMeanRate();
                    this.appendThroughputInBytes(throughputInBytes, throughputInRows);
                }
                if (this.hasMoreSpace()) {
                    this.appendLatencies();
                    if (ConsoleReporter.this.batchSizes != null && this.hasMoreSpace()) {
                        Snapshot snapshot = ConsoleReporter.this.batchSizes.getSnapshot();
                        this.appendBatchSizes(snapshot);
                    }
                }
            }
        }

        private void appendTotals(long total, long failed) {
            String totalStr = String.format("%,d", total);
            String failedStr = String.format("%,d", failed);
            int totalLength = Math.max("total".length(), totalStr.length());
            int failedLength = Math.max("failed".length(), failedStr.length());
            this.header = this.header.a(StringUtils.leftPad("total", totalLength)).a(" | ").a(StringUtils.leftPad("failed", failedLength));
            this.message = this.message.fgCyan().a(StringUtils.leftPad(totalStr, totalLength)).reset().a(" | ").fgCyan().a(StringUtils.leftPad(failedStr, failedLength));
        }

        private void appendPercentageAchieved(float total) {
            float achieved = total / (float)ConsoleReporter.this.expectedTotal * 100.0f;
            String achievedStr = String.format("%,.0f%%", Float.valueOf(achieved));
            int achievedLength = Math.max("achieved".length(), achievedStr.length());
            this.header = this.header.a(" | ").a(StringUtils.leftPad("achieved", achievedLength));
            this.message = this.message.reset().a(" | ").fgCyan().a(StringUtils.leftPad(achievedStr, achievedLength));
        }

        private void appendThroughputInRows(double throughputInRows) {
            double rowsPerUnit = ConsoleReporter.this.convertRate(throughputInRows);
            String rowsPerUnitStr = String.format("%,.0f", rowsPerUnit);
            String rowsPerUnitLabel = ConsoleReporter.this.rowType.plural() + "/" + ConsoleReporter.this.rateUnit;
            int rowsPerUnitLength = Math.max(rowsPerUnitLabel.length(), rowsPerUnitStr.length());
            this.header = this.header.a(" | ").a(StringUtils.leftPad(rowsPerUnitLabel, rowsPerUnitLength));
            this.message = this.message.reset().a(" | ").fgGreen().a(StringUtils.leftPad(rowsPerUnitStr, rowsPerUnitLength));
        }

        private void appendThroughputInBytes(double throughputInBytes, double throughputInRows) {
            double mbPerUnit = ConsoleReporter.this.convertRate(throughputInBytes / 1048576.0);
            double kbPerRow = throughputInRows == 0.0 ? 0.0 : throughputInBytes / 1024.0 / throughputInRows;
            String mbPerUnitStr = String.format("%,.2f", mbPerUnit);
            String kbPerRowStr = String.format("%,.3f", kbPerRow);
            String mbPerRateUnitLabel = "mb/" + ConsoleReporter.this.rateUnit;
            int mbPerUnitLength = Math.max(mbPerRateUnitLabel.length(), mbPerUnitStr.length());
            int kbPerRowLength = Math.max(("kb/" + ConsoleReporter.this.rowType.singular()).length(), kbPerRowStr.length());
            this.header = this.header.a(" | ").a(StringUtils.leftPad(mbPerRateUnitLabel, mbPerUnitLength)).a(" | ").a(StringUtils.leftPad("kb/" + ConsoleReporter.this.rowType.singular(), kbPerRowLength));
            this.message = this.message.reset().a(" | ").fgGreen().a(StringUtils.leftPad(mbPerUnitStr, mbPerUnitLength)).reset().a(" | ").fgGreen().a(StringUtils.leftPad(kbPerRowStr, kbPerRowLength));
        }

        private void appendLatencies() {
            Snapshot latencies = ConsoleReporter.this.timer.getSnapshot();
            double p50 = ConsoleReporter.this.convertDuration(latencies.getMean());
            double p99 = ConsoleReporter.this.convertDuration(latencies.get99thPercentile());
            double p999 = ConsoleReporter.this.convertDuration(latencies.get999thPercentile());
            String p50Str = String.format("%,.2f", p50);
            String p99Str = String.format("%,.2f", p99);
            String p999Str = String.format("%,.2f", p999);
            String p50Label = "p50" + ConsoleReporter.this.durationUnit;
            String p99Label = "p99" + ConsoleReporter.this.durationUnit;
            String p999Label = "p999" + ConsoleReporter.this.durationUnit;
            int p50Length = Math.max(p50Label.length(), p50Str.length());
            int p99Length = Math.max(p99Label.length(), p99Str.length());
            int p999Length = Math.max(p999Label.length(), p999Str.length());
            this.header = this.header.a(" | ").a(StringUtils.leftPad(p50Label, p50Length)).a(" | ").a(StringUtils.leftPad(p99Label, p99Length)).a(" | ").a(StringUtils.leftPad(p999Label, p999Length));
            this.message = this.message.reset().a(" | ").fgYellow().a(StringUtils.leftPad(p50Str, p50Length)).reset().a(" | ").fgYellow().a(StringUtils.leftPad(p99Str, p99Length)).reset().a(" | ").fgYellow().a(StringUtils.leftPad(p999Str, p999Length));
        }

        private void appendBatchSizes(Snapshot snapshot) {
            double avgBatch = snapshot.getMean();
            String avgBatchStr = String.format("%,.2f", avgBatch);
            int avgBatchLength = Math.max("batches".length(), avgBatchStr.length());
            this.header = this.header.a(" | ").a(StringUtils.leftPad("batches", avgBatchLength));
            this.message = this.message.reset().a(" | ").fgMagenta().a(StringUtils.leftPad(avgBatchStr, avgBatchLength));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void print() {
            this.header = this.header.reset().newline();
            this.message = this.message.reset().newline();
            InterceptingPrintStream interceptingPrintStream = ConsoleReporter.this.stderr;
            synchronized (interceptingPrintStream) {
                if (!ConsoleReporter.this.stderr.stale) {
                    System.err.print(Ansi.ansi().cursorUp(1).eraseLine(Ansi.Erase.FORWARD).cursorUp(1).eraseLine(Ansi.Erase.FORWARD));
                }
                System.err.print(this.header);
                System.err.print(this.message);
                ConsoleReporter.this.stderr.stale = false;
            }
        }

        private boolean hasMoreSpace() {
            return this.header.toString().length() < ConsoleUtils.LINE_LENGTH;
        }
    }
}

