/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.datastax.oss.dsbulk.executor.api.listener.LogSink;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class BatchReporter
extends ScheduledReporter {
    private static final String MSG = "Batches: total: %,d, size: %,.2f mean, %d min, %d max";
    private final LogSink sink;

    BatchReporter(MetricRegistry registry, LogSink sink, ScheduledExecutorService scheduler) {
        super(registry, "batch-reporter", BatchReporter.createFilter(), TimeUnit.SECONDS, TimeUnit.MILLISECONDS, scheduler);
        this.sink = sink;
    }

    private static MetricFilter createFilter() {
        return (name, metric) -> name.equals("batches/size");
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        if (!this.sink.isEnabled()) {
            return;
        }
        Histogram size = (Histogram)histograms.get("batches/size");
        Snapshot snapshot = size.getSnapshot();
        this.sink.accept(String.format(MSG, size.getCount(), snapshot.getMean(), snapshot.getMin(), snapshot.getMax()), new Object[0]);
    }
}

