/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.log;

import com.datastax.oss.dsbulk.workflow.commons.log.Range;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class PositionsTracker {
    private final Map<URI, List<Range>> positions = new HashMap<URI, List<Range>>();

    public Map<URI, List<Range>> getPositions() {
        return this.positions;
    }

    public boolean isEmpty() {
        return this.positions.isEmpty();
    }

    public void update(URI resource, long position) {
        if (position > 0L) {
            this.positions.compute(resource, (res, positions) -> {
                if (positions == null) {
                    positions = new ArrayList<Range>(100);
                    positions.add(new Range(position));
                    return positions;
                }
                return PositionsTracker.addPosition((List<Range>)positions, position);
            });
        }
    }

    @NonNull
    private static List<Range> addPosition(@NonNull List<Range> positions, long position) {
        ListIterator<Range> iterator = positions.listIterator();
        while (iterator.hasNext()) {
            Range range = iterator.next();
            if (range.contains(position)) {
                return positions;
            }
            if (range.getUpper() + 1L == position) {
                range.setUpper(position);
                if (iterator.hasNext()) {
                    Range next = iterator.next();
                    if (range.getUpper() == next.getLower() - 1L) {
                        iterator.remove();
                        range = iterator.previous();
                        range.setUpper(next.getUpper());
                    }
                }
                return positions;
            }
            if (range.getLower() - 1L == position) {
                range.setLower(position);
                return positions;
            }
            if (position >= range.getLower()) continue;
            iterator.previous();
            iterator.add(new Range(position));
            return positions;
        }
        iterator.add(new Range(position));
        return positions;
    }
}

