/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.commons.auth;

import com.datastax.dse.driver.api.core.auth.DseGssApiAuthProviderBase;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.internal.core.auth.ProgrammaticPlainTextAuthProvider;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.datastax.oss.dsbulk.io.IOUtils;
import com.datastax.oss.dsbulk.workflow.commons.auth.BulkGssApiAuthProvider;
import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthProviderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthProviderFactory.class);

    @Nullable
    public static AuthProvider createAuthProvider(Config config) {
        String authProvider = config.getString("provider");
        if (authProvider.equals("None") && config.hasPath("username") && config.hasPath("password")) {
            LOGGER.info("Username and password provided but auth provider not specified, inferring PlainTextAuthProvider");
            authProvider = "PlainTextAuthProvider";
        }
        if (authProvider.equals("None")) {
            return null;
        }
        String authorizationId = "";
        if (config.hasPath("authorizationId")) {
            authorizationId = config.getString("authorizationId");
        }
        switch (authProvider.toLowerCase()) {
            case "plaintextauthprovider": {
                return AuthProviderFactory.createPlainTextAuthProvider(config, authProvider, authorizationId);
            }
            case "dseplaintextauthprovider": {
                LOGGER.warn("The DsePlainTextAuthProvider is deprecated. Please use PlainTextAuthProvider instead.");
                return AuthProviderFactory.createPlainTextAuthProvider(config, authProvider, authorizationId);
            }
            case "dsegssapiauthprovider": {
                return AuthProviderFactory.createGssApiAuthProvider(config, authProvider, authorizationId);
            }
        }
        throw new IllegalArgumentException(String.format("Invalid value for dsbulk.driver.auth.provider, expecting one of PlainTextAuthProvider, DsePlainTextAuthProvider, or DseGSSAPIAuthProvider, got: '%s'", authProvider));
    }

    private static AuthProvider createPlainTextAuthProvider(Config config, String authProvider, String authorizationId) {
        AuthProviderFactory.checkHasCredentials(config, authProvider);
        return new ProgrammaticPlainTextAuthProvider(config.getString("username"), config.getString("password"), authorizationId);
    }

    private static AuthProvider createGssApiAuthProvider(Config config, String authProvider, String authorizationId) {
        if (!config.hasPath("saslService")) {
            throw new IllegalArgumentException(String.format("dsbulk.driver.auth.saslService must be provided with %s. dsbulk.driver.auth.principal, dsbulk.driver.auth.keyTab, and dsbulk.driver.auth.authorizationId are optional.", authProvider));
        }
        String authSaslService = config.getString("saslService");
        String authPrincipal = null;
        if (config.hasPath("principal")) {
            authPrincipal = config.getString("principal");
        }
        Path authKeyTab = null;
        if (config.hasPath("keyTab")) {
            authKeyTab = ConfigUtils.getPath((Config)config, (String)"keyTab");
            IOUtils.assertAccessibleFile((Path)authKeyTab, (String)"Keytab file");
            if (authPrincipal == null) {
                try {
                    Class<?> keyTabClazz = Class.forName("sun.security.krb5.internal.ktab.KeyTab");
                    Class<?> keyTabEntryClazz = Class.forName("sun.security.krb5.internal.ktab.KeyTabEntry");
                    Class<?> principalNameClazz = Class.forName("sun.security.krb5.PrincipalName");
                    Method getInstanceMethod = keyTabClazz.getMethod("getInstance", String.class);
                    Method getEntriesMethod = keyTabClazz.getMethod("getEntries", new Class[0]);
                    Method getServiceMethod = keyTabEntryClazz.getMethod("getService", new Class[0]);
                    Method getNameMethod = principalNameClazz.getMethod("getName", new Class[0]);
                    Object keyTab = getInstanceMethod.invoke(null, authKeyTab.toString());
                    Object[] entries = (Object[])getEntriesMethod.invoke(keyTab, new Object[0]);
                    if (entries.length <= 0) {
                        throw new IllegalArgumentException(String.format("Could not find any principals in %s", authKeyTab));
                    }
                    authPrincipal = (String)getNameMethod.invoke(getServiceMethod.invoke(entries[0], new Object[0]), new Object[0]);
                    LOGGER.debug("Found Kerberos principal {} in {}", (Object)authPrincipal, (Object)authKeyTab);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Could not find any principals in %s", authKeyTab), e);
                }
            }
        }
        Configuration configuration = authKeyTab != null ? new KeyTabConfiguration(authPrincipal, authKeyTab.toString()) : new TicketCacheConfiguration(authPrincipal);
        DseGssApiAuthProviderBase.GssApiOptions options = DseGssApiAuthProviderBase.GssApiOptions.builder().withLoginConfiguration(configuration).withAuthorizationId(authorizationId).withSaslProtocol(authSaslService).build();
        return new BulkGssApiAuthProvider(options);
    }

    private static void checkHasCredentials(Config config, String authProvider) {
        if (!config.hasPath("username") || !config.hasPath("password")) {
            throw new IllegalArgumentException("Both dsbulk.driver.auth.username and dsbulk.driver.auth.password must be provided with " + authProvider);
        }
    }

    @VisibleForTesting
    public static class TicketCacheConfiguration
    extends Configuration {
        private final String principal;

        TicketCacheConfiguration(String principal) {
            this.principal = principal;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"useTicketCache", (Object)"true").put((Object)"refreshKrb5Config", (Object)"true").put((Object)"renewTGT", (Object)"true");
            if (this.principal != null) {
                builder.put((Object)"principal", (Object)this.principal);
            }
            ImmutableMap options = builder.build();
            return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, (Map<String, ?>)options)};
        }
    }

    @VisibleForTesting
    public static class KeyTabConfiguration
    extends Configuration {
        private final String principal;
        private final String keyTab;

        KeyTabConfiguration(String principal, String keyTab) {
            this.principal = principal;
            this.keyTab = keyTab;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            ImmutableMap options = ImmutableMap.builder().put((Object)"principal", (Object)this.principal).put((Object)"useKeyTab", (Object)"true").put((Object)"refreshKrb5Config", (Object)"true").put((Object)"keyTab", (Object)this.keyTab).build();
            return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, (Map<String, ?>)options)};
        }
    }
}

