/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.api.utils;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.datastax.oss.dsbulk.workflow.api.utils.ConsoleUtils;
import com.datastax.oss.dsbulk.workflow.api.utils.PlatformUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.UUID;

public class WorkflowUtils {
    public static final String BULK_LOADER_APPLICATION_NAME = "DataStax Bulk Loader";
    public static final UUID BULK_LOADER_NAMESPACE = UUID.fromString("2505c745-cedf-4714-bcab-0d580270ed95");
    private static final DateTimeFormatter DEFAULT_TIMESTAMP_PATTERN = DateTimeFormatter.ofPattern("uuuuMMdd-HHmmss-SSSSSS");

    @NonNull
    public static String newDefaultExecutionId(@NonNull String operationTitle) {
        return operationTitle.toUpperCase() + "_" + DEFAULT_TIMESTAMP_PATTERN.format(PlatformUtils.now());
    }

    @NonNull
    public static String newCustomExecutionId(@NonNull String template, @NonNull String operationTitle) {
        try {
            String executionId = String.format(template, operationTitle, PlatformUtils.now(), PlatformUtils.pid());
            if (executionId.isEmpty()) {
                throw new IllegalStateException("Generated execution ID is empty.");
            }
            return executionId;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not generate execution ID with template: '" + template + "': " + e.getMessage(), e);
        }
    }

    @NonNull
    public static UUID clientId(String executionId) {
        return Uuids.nameBased((UUID)BULK_LOADER_NAMESPACE, (String)executionId);
    }

    @NonNull
    public static String getBulkLoaderVersion() {
        String version = "UNKNOWN";
        try (InputStream versionStream = ConsoleUtils.class.getResourceAsStream("/com/datastax/oss/dsbulk/version.txt");){
            if (versionStream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(versionStream, StandardCharsets.UTF_8));
                version = reader.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    @NonNull
    public static String getBulkLoaderNameAndVersion() {
        String version = WorkflowUtils.getBulkLoaderVersion();
        return "DataStax Bulk Loader v" + version;
    }
}

