/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.api.utils;

import com.datastax.oss.driver.shaded.guava.common.base.Throwables;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileNotFoundException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.util.List;
import java.util.function.Predicate;

public class ThrowableUtils {
    private static final Predicate<Throwable> INCLUDE_ALL = t -> true;

    public static boolean isInterrupted(@NonNull Throwable throwable) {
        List chain = Throwables.getCausalChain((Throwable)throwable);
        for (Throwable t : chain) {
            Throwable[] suppressed;
            if (ThrowableUtils.checkInterrupted(t)) {
                return true;
            }
            for (Throwable s : suppressed = t.getSuppressed()) {
                if (!ThrowableUtils.checkInterrupted(s)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkInterrupted(Throwable t) {
        return t instanceof InterruptedException || t instanceof InterruptedIOException || t instanceof ClosedByInterruptException || t instanceof FileLockInterruptionException;
    }

    @NonNull
    public static String getSanitizedErrorMessage(@NonNull Throwable error) {
        return ThrowableUtils.getSanitizedErrorMessage(error, INCLUDE_ALL, 2);
    }

    @NonNull
    public static String getSanitizedErrorMessage(@NonNull Throwable error, @NonNull Predicate<Throwable> filter, int indentation) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ThrowableUtils.printErrorMessage(error, filter, pw, indentation, 0);
        return sw.toString();
    }

    private static void printErrorMessage(Throwable error, Predicate<Throwable> filter, PrintWriter pw, int indentation, int currentIndentation) {
        Throwable[] suppressed;
        pw.print(ThrowableUtils.sanitizedErrorMessage(error));
        for (Throwable s : suppressed = error.getSuppressed()) {
            if (!filter.test(s)) continue;
            ThrowableUtils.newLineAndIndent(pw, currentIndentation + indentation);
            pw.print(" Suppressed: ");
            ThrowableUtils.printErrorMessage(s, filter, pw, indentation, currentIndentation + indentation);
        }
        Throwable cause = error.getCause();
        if (cause != null && cause != error && filter.test(cause)) {
            ThrowableUtils.newLineAndIndent(pw, currentIndentation + indentation);
            pw.print(" Caused by: ");
            ThrowableUtils.printErrorMessage(cause, filter, pw, indentation, currentIndentation + indentation);
        }
    }

    private static String sanitizedErrorMessage(Throwable t) {
        StringBuilder sb = new StringBuilder();
        if (t instanceof FileNotFoundException) {
            sb.append("File not found: ").append(t.getMessage()).append('.');
        } else if (t instanceof MalformedURLException) {
            sb.append("Malformed URL: ").append(t.getMessage()).append('.');
        } else if (t instanceof UnknownHostException) {
            sb.append("Unknown host: ").append(t.getMessage()).append('.');
        } else if (t instanceof UnsupportedEncodingException) {
            sb.append("Unsupported encoding: ").append(t.getMessage()).append('.');
        } else if (t instanceof AccessDeniedException) {
            sb.append("Access denied: ").append(t.getMessage()).append('.');
        } else if (t instanceof DirectoryNotEmptyException) {
            sb.append("Directory is not empty: ").append(t.getMessage()).append('.');
        } else if (t instanceof FileAlreadyExistsException) {
            sb.append("File already exists: ").append(t.getMessage()).append('.');
        } else if (t instanceof NoSuchFileException) {
            sb.append("No such file: ").append(t.getMessage()).append('.');
        } else if (t instanceof NotDirectoryException) {
            sb.append("File is not a directory: ").append(t.getMessage()).append('.');
        } else if (t instanceof ClosedChannelException) {
            sb.append("Channel is closed.");
        } else if (t instanceof NonReadableChannelException) {
            sb.append("Channel is not readable.");
        } else if (t instanceof NonWritableChannelException) {
            sb.append("Channel is not writable.");
        } else if (t.getMessage() == null || t.getMessage().isEmpty() || t.getMessage().equals("null")) {
            sb.append(t.getClass().getSimpleName()).append(" (no message).");
        } else if (t.getMessage().matches("\\d+") || t.getMessage().length() < 10) {
            sb.append(t.getClass().getSimpleName()).append(": ");
            ThrowableUtils.appendMessage(t, sb);
        } else {
            ThrowableUtils.appendMessage(t, sb);
        }
        return sb.toString();
    }

    private static void appendMessage(Throwable t, StringBuilder sb) {
        String msg = t.getMessage();
        sb.append(msg.substring(0, 1).toUpperCase());
        if (msg.length() > 1) {
            sb.append(msg.substring(1));
        }
        if (!msg.endsWith(".")) {
            sb.append('.');
        }
    }

    private static void newLineAndIndent(PrintWriter pw, int spaces) {
        pw.println();
        for (int i = 0; i < spaces; ++i) {
            pw.print(' ');
        }
    }
}

