/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.api.utils;

import com.datastax.oss.driver.internal.core.os.Native;
import com.datastax.oss.driver.shaded.guava.common.base.Splitter;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Random;

public class PlatformUtils {
    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.startsWith("Windows");
    }

    public static int pid() {
        if (Native.isGetProcessIdAvailable()) {
            return Native.getProcessId();
        }
        try {
            String pidJmx = (String)Iterables.get((Iterable)Splitter.on((char)'@').split((CharSequence)ManagementFactory.getRuntimeMXBean().getName()), (int)0);
            return Integer.parseInt(pidJmx);
        }
        catch (Exception ignored) {
            return new Random(System.currentTimeMillis()).nextInt();
        }
    }

    @NonNull
    public static ZonedDateTime now() {
        if (Native.isCurrentTimeMicrosAvailable()) {
            return Instant.EPOCH.plus(Native.currentTimeMicros(), ChronoUnit.MICROS).atZone(ZoneOffset.UTC);
        }
        return Instant.now().atZone(ZoneOffset.UTC);
    }
}

