/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.api.utils;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DurationUtils {
    @NonNull
    public static Duration round(@NonNull Duration duration, @NonNull TimeUnit unit) {
        long nanos = duration.toNanos();
        long converted = unit.convert(nanos, TimeUnit.NANOSECONDS);
        return Duration.ofNanos(unit.toNanos(converted));
    }

    @NonNull
    public static String formatDuration(@NonNull Duration duration) {
        if (duration.isNegative()) {
            throw new IllegalArgumentException("Cannot format negative duration");
        }
        if (duration.isZero()) {
            throw new IllegalArgumentException("Cannot format zero duration");
        }
        long days = duration.toDays();
        duration = duration.minusDays(days);
        long hours = duration.toHours();
        duration = duration.minusHours(hours);
        long minutes = duration.toMinutes();
        duration = duration.minusMinutes(minutes);
        long seconds = duration.getSeconds();
        duration = duration.minusSeconds(seconds);
        long millis = duration.toMillis();
        duration = duration.minusMillis(millis);
        long nanos = duration.getNano();
        ArrayList<StringBuilder> segments = new ArrayList<StringBuilder>();
        DurationUtils.maybeAppendSegment(segments, days, "day");
        DurationUtils.maybeAppendSegment(segments, hours, "hour");
        DurationUtils.maybeAppendSegment(segments, minutes, "minute");
        DurationUtils.maybeAppendSegment(segments, seconds, "second");
        DurationUtils.maybeAppendSegment(segments, millis, "millisecond");
        DurationUtils.maybeAppendSegment(segments, nanos, "nanosecond");
        StringBuilder sb = new StringBuilder();
        Iterator it = segments.iterator();
        while (it.hasNext()) {
            StringBuilder segment = (StringBuilder)it.next();
            if (sb.length() > 0) {
                if (it.hasNext()) {
                    sb.append(", ");
                } else {
                    sb.append(" and ");
                }
            }
            sb.append((CharSequence)segment);
        }
        return sb.toString();
    }

    private static void maybeAppendSegment(List<StringBuilder> segments, long amount, String label) {
        if (amount > 0L) {
            StringBuilder sb = new StringBuilder().append(String.format("%,d", amount)).append(' ').append(label);
            if (amount > 1L) {
                sb.append('s');
            }
            segments.add(sb);
        }
    }
}

