/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.api.log;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class OperationDirectoryResolver {
    private final Path logDirectory;
    private final String executionId;

    public OperationDirectoryResolver(@NonNull Path logDirectory, @NonNull String executionId) {
        this.logDirectory = logDirectory;
        this.executionId = executionId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public Path resolve() throws IOException {
        Path operationDirectory;
        try {
            operationDirectory = this.logDirectory.resolve(this.executionId);
        }
        catch (InvalidPathException e) {
            throw new IllegalArgumentException(String.format("Execution ID '%s' is not a valid path name on the local filesytem", this.executionId), e);
        }
        if (Files.exists(operationDirectory, new LinkOption[0])) {
            if (!Files.isDirectory(operationDirectory, new LinkOption[0])) throw new IllegalStateException("Operation directory exists but is not a directory: " + operationDirectory);
            if (!Files.isWritable(operationDirectory)) throw new IllegalStateException("Operation directory exists but is not writable: " + operationDirectory);
            long count = Files.list(operationDirectory).count();
            if (count <= 0L) return operationDirectory;
            throw new IllegalStateException("Operation directory exists but is not empty: " + operationDirectory);
        }
        Files.createDirectories(operationDirectory, new FileAttribute[0]);
        return operationDirectory;
    }
}

