/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.api.error;

import com.datastax.oss.dsbulk.workflow.api.error.ErrorThreshold;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.text.DecimalFormat;

public class RatioErrorThreshold
implements ErrorThreshold {
    private final float maxErrorRatio;
    private final long minSample;

    RatioErrorThreshold(float maxErrorRatio, long minSample) {
        if (maxErrorRatio <= 0.0f || maxErrorRatio >= 1.0f) {
            throw new IllegalArgumentException("maxErrorRatio must be > 0 and < 1");
        }
        if (minSample < 1L) {
            throw new IllegalArgumentException("minSample must be >= 1");
        }
        this.maxErrorRatio = maxErrorRatio;
        this.minSample = minSample;
    }

    @Override
    public boolean checkThresholdExceeded(long errorCount, @NonNull Number totalItems) {
        long totalSoFar = totalItems.longValue();
        if (totalSoFar >= this.minSample) {
            float currentRatio = (float)errorCount / (float)totalSoFar;
            return currentRatio > this.maxErrorRatio;
        }
        return false;
    }

    @Override
    public String thresholdAsString() {
        return new DecimalFormat("#.##%").format(this.maxErrorRatio);
    }

    public float getMaxErrorRatio() {
        return this.maxErrorRatio;
    }

    public long getMinSample() {
        return this.minSample;
    }
}

