/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.workflow.api.error;

import com.datastax.oss.dsbulk.workflow.api.error.ErrorThreshold;
import edu.umd.cs.findbugs.annotations.NonNull;

public class AbsoluteErrorThreshold
implements ErrorThreshold {
    private final long maxErrors;

    AbsoluteErrorThreshold(long maxErrors) {
        if (maxErrors < 0L) {
            throw new IllegalArgumentException("maxErrors must be >= 0");
        }
        this.maxErrors = maxErrors;
    }

    @Override
    public boolean checkThresholdExceeded(long errorCount, @NonNull Number totalItems) {
        return errorCount > this.maxErrors;
    }

    @Override
    public String thresholdAsString() {
        return Long.toString(this.maxErrors);
    }

    public long getMaxErrors() {
        return this.maxErrors;
    }
}

