/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.url;

import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.dsbulk.url.URLStreamHandlerProvider;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkLoaderURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkLoaderURLStreamHandlerFactory.class);
    @VisibleForTesting
    static final BulkLoaderURLStreamHandlerFactory INSTANCE = new BulkLoaderURLStreamHandlerFactory();
    private static final AtomicBoolean INSTALLED = new AtomicBoolean(false);
    private final ImmutableList<URLStreamHandlerProvider> providers;

    public static void install() {
        if (INSTALLED.compareAndSet(false, true)) {
            URL.setURLStreamHandlerFactory(INSTANCE);
        }
    }

    private BulkLoaderURLStreamHandlerFactory() {
        ServiceLoader<URLStreamHandlerProvider> loader = ServiceLoader.load(URLStreamHandlerProvider.class);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (URLStreamHandlerProvider provider : loader) {
            LOGGER.debug("Found URL stream handler provider: {}", (Object)provider);
            builder.add((Object)provider);
        }
        this.providers = builder.build();
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        LOGGER.debug("Creating URL stream handler for protocol: {}", (Object)protocol);
        URLStreamHandler handler = null;
        if (protocol != null) {
            for (URLStreamHandlerProvider provider : this.providers) {
                Optional<URLStreamHandler> maybeHandler = provider.maybeCreateURLStreamHandler(protocol);
                if (!maybeHandler.isPresent()) continue;
                handler = maybeHandler.get();
                break;
            }
        }
        LOGGER.debug("Returning URL stream handler for protocol {}: {}", (Object)protocol, handler);
        return handler;
    }
}

