/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.sampler;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.GettableByIndex;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class DataSizes {
    public static long getDataSize(@NonNull Statement<?> stmt, @NonNull ProtocolVersion version, @NonNull CodecRegistry registry) {
        long dataSize = 0L;
        if (stmt instanceof BoundStatement) {
            BoundStatement bs = (BoundStatement)stmt;
            dataSize = DataSizes.getDataSize((GettableByIndex)bs, bs.getPreparedStatement().getVariableDefinitions());
        } else if (stmt instanceof SimpleStatement) {
            SimpleStatement rs = (SimpleStatement)stmt;
            if (!rs.getNamedValues().isEmpty()) {
                Map values = rs.getNamedValues();
                Map bbs = Conversions.encode((Map)values, (CodecRegistry)registry, (ProtocolVersion)version);
                for (ByteBuffer bb : bbs.values()) {
                    dataSize += bb == null ? 0L : (long)bb.remaining();
                }
            } else if (!rs.getPositionalValues().isEmpty()) {
                List values = rs.getPositionalValues();
                List bbs = Conversions.encode((List)values, (CodecRegistry)registry, (ProtocolVersion)version);
                for (ByteBuffer bb : bbs) {
                    dataSize += bb == null ? 0L : (long)bb.remaining();
                }
            }
        } else if (stmt instanceof BatchStatement) {
            BatchStatement bs = (BatchStatement)stmt;
            for (Statement st : bs) {
                dataSize += DataSizes.getDataSize(st, version, registry);
            }
        } else {
            throw new IllegalArgumentException("Unknown statement type: " + stmt.getClass().getName());
        }
        return dataSize;
    }

    public static long getDataSize(@NonNull Row row) {
        return DataSizes.getDataSize((GettableByIndex)row, row.getColumnDefinitions());
    }

    private static long getDataSize(GettableByIndex container, ColumnDefinitions metadata) {
        long dataSize = 0L;
        if (metadata.size() > 0) {
            for (int i = 0; i < metadata.size(); ++i) {
                ByteBuffer bb = container.getBytesUnsafe(i);
                if (bb == null) continue;
                dataSize += (long)bb.remaining();
            }
        }
        return dataSize;
    }
}

