/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.sampler;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.UniformReservoir;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.dsbulk.sampler.DataSizes;

public class DataSizeSampler {
    public static Histogram sampleWrites(AttachmentPoint attachmentPoint, Iterable<Statement<?>> statements) {
        Histogram histogram = new Histogram((Reservoir)new UniformReservoir());
        for (Statement<?> statement : statements) {
            long dataSize = DataSizes.getDataSize(statement, attachmentPoint.getProtocolVersion(), attachmentPoint.getCodecRegistry());
            histogram.update(dataSize);
        }
        return histogram;
    }

    public static Histogram sampleReads(Iterable<Row> rows) {
        Histogram histogram = new Histogram((Reservoir)new UniformReservoir());
        for (Row row : rows) {
            long dataSize = DataSizes.getDataSize(row);
            histogram.update(dataSize);
        }
        return histogram;
    }
}

