/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.runner.help;

import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.datastax.oss.dsbulk.runner.help.HelpEntry;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class HelpEntryFactory {
    public static final HelpEntry CONFIG_FILE_OPTION = new HelpEntry("f", null, null, "string", "Load options from the given file rather than from `<dsbulk_home>/conf/application.conf`.");
    static final HelpEntry HELP_OPTION = new HelpEntry(null, null, "help", null, "This help text. May be combined with -c <connectorName> to see short options for a particular connector.");
    static final HelpEntry VERSION_OPTION = new HelpEntry("v", null, "version", null, "Show program's version number and exit.");

    static List<HelpEntry> createEntries(Collection<String> settings, Map<String, String> longToShortOptions, Config referenceConfig) {
        ArrayList<HelpEntry> entries = new ArrayList<HelpEntry>();
        for (String longOptionName : settings) {
            String argumentType = ConfigUtils.getTypeString((Config)referenceConfig, (String)longOptionName).orElse("arg");
            ConfigValue value = ConfigUtils.getNullSafeValue((Config)referenceConfig, (String)longOptionName);
            String abbreviatedOptionName = HelpEntryFactory.createAbbreviatedOptionName(longOptionName);
            HelpEntry entry = new HelpEntry(longToShortOptions.get(longOptionName), abbreviatedOptionName, longOptionName, argumentType, HelpEntryFactory.getSanitizedDescription(value));
            entries.add(entry);
        }
        return entries;
    }

    @Nullable
    private static String createAbbreviatedOptionName(String setting) {
        if (setting.startsWith("datastax-java-driver.")) {
            return setting.replaceFirst("datastax-java-driver\\.", "driver.");
        }
        if (setting.startsWith("dsbulk.")) {
            return setting.replaceFirst("dsbulk\\.", "");
        }
        return null;
    }

    private static String getSanitizedDescription(ConfigValue value) {
        String desc = ConfigUtils.getComments((ConfigValue)value);
        desc = desc.replaceAll(" +", " ").replaceAll("([^\"])\\*\\*", "$1").replaceAll("```\n", "").replaceAll("`", "'").trim();
        String defaultValue = value.render(ConfigRenderOptions.concise());
        desc = desc + "\nDefault: " + defaultValue;
        return desc;
    }
}

