/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.runner.help;

import com.datastax.oss.driver.shaded.guava.common.base.CharMatcher;
import com.datastax.oss.driver.shaded.guava.common.collect.BiMap;
import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.datastax.oss.dsbulk.config.model.SettingsGroup;
import com.datastax.oss.dsbulk.config.model.SettingsGroupFactory;
import com.datastax.oss.dsbulk.config.shortcuts.ShortcutsFactory;
import com.datastax.oss.dsbulk.runner.help.HelpEntry;
import com.datastax.oss.dsbulk.runner.help.HelpEntryFactory;
import com.datastax.oss.dsbulk.runner.utils.StringUtils;
import com.datastax.oss.dsbulk.workflow.api.WorkflowProvider;
import com.datastax.oss.dsbulk.workflow.api.utils.ConsoleUtils;
import com.datastax.oss.dsbulk.workflow.api.utils.WorkflowUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.fusesource.jansi.Ansi;

public class HelpEmitter {
    private static final Pattern CONNECTOR_SETTINGS_PATTERN = Pattern.compile("dsbulk\\.connector\\.[^.]+\\..+");
    private static final int INDENT = 4;

    public static void emitGlobalHelp(@Nullable String connectorName) {
        List<HelpEntry> entries;
        Map groups = SettingsGroupFactory.createDSBulkConfigurationGroups((boolean)false);
        Config referenceConfig = ConfigUtils.standaloneDSBulkReference().withFallback((ConfigMergeable)ConfigUtils.standaloneDriverReference());
        BiMap longToShortOptions = ShortcutsFactory.createShortcutsMap((Config)referenceConfig, (String)connectorName).inverse();
        if (connectorName == null) {
            entries = HelpEntryFactory.createEntries(((SettingsGroup)groups.get("Common")).getSettings(), (Map<String, String>)longToShortOptions, referenceConfig);
        } else {
            List<String> commonSettings = ((SettingsGroup)groups.get("Common")).getSettings().stream().filter(name -> name.startsWith("dsbulk.connector." + connectorName + ".") || !CONNECTOR_SETTINGS_PATTERN.matcher((CharSequence)name).matches()).collect(Collectors.toList());
            entries = HelpEntryFactory.createEntries(commonSettings, (Map<String, String>)longToShortOptions, referenceConfig);
        }
        entries.add(0, HelpEntryFactory.VERSION_OPTION);
        entries.add(1, HelpEntryFactory.HELP_OPTION);
        entries.add(2, HelpEntryFactory.CONFIG_FILE_OPTION);
        System.out.println(WorkflowUtils.getBulkLoaderNameAndVersion());
        Ansi header = Ansi.ansi().a("Usage: ").fgRed().a("dsbulk <command> [options]").newline().a("       dsbulk help [section]").reset().newline();
        System.out.println(header);
        HelpEmitter.renderAvailableCommands();
        Ansi options = Ansi.ansi().a("Common options:").reset().newline();
        System.out.println(options);
        HelpEmitter.renderAbbreviatedDsbulkOptionNote();
        HelpEmitter.renderAbbreviatedDriverOptionNote();
        HelpEmitter.renderHelpEntries(entries);
        HelpEmitter.renderGettingMoreHelpFooter(groups);
    }

    public static void emitSectionHelp(@NonNull String sectionName, @Nullable String connectorName) {
        boolean driverSection = sectionName.equals("datastax-java-driver");
        Map groups = SettingsGroupFactory.createDSBulkConfigurationGroups((boolean)driverSection);
        if (!groups.containsKey(sectionName)) {
            throw new IllegalArgumentException(String.format("%s is not a valid section. Available sections include the following:%n    %s", sectionName, String.join((CharSequence)"\n    ", HelpEmitter.getSectionNames(groups))));
        }
        if (sectionName.startsWith("dsbulk.connector.")) {
            connectorName = sectionName.substring("dsbulk.connector.".length());
        }
        Config referenceConfig = ConfigUtils.standaloneDSBulkReference().withFallback((ConfigMergeable)ConfigUtils.standaloneDriverReference());
        BiMap longToShortOptions = ShortcutsFactory.createShortcutsMap((Config)referenceConfig, (String)connectorName).inverse();
        List<HelpEntry> entries = HelpEntryFactory.createEntries(((SettingsGroup)groups.get(sectionName)).getSettings(), (Map<String, String>)longToShortOptions, referenceConfig);
        System.out.println(WorkflowUtils.getBulkLoaderNameAndVersion());
        Ansi header = Ansi.ansi().a("Help for section: ").fgRed().a(sectionName).reset().a(" (run `dsbulk help` to get the global help).").newline();
        System.out.println(header);
        if (driverSection) {
            HelpEmitter.renderDriverSpecialInstructions();
        }
        Ansi options = Ansi.ansi().a("Options in this section:").reset().newline();
        System.out.println(options);
        if (driverSection) {
            HelpEmitter.renderAbbreviatedDriverOptionNote();
        } else {
            HelpEmitter.renderAbbreviatedDsbulkOptionNote();
        }
        HelpEmitter.renderHelpEntries(entries);
        HelpEmitter.renderAvailableSubSections(sectionName, groups);
        if (driverSection) {
            HelpEmitter.renderDriverFooter();
        }
    }

    private static void renderAvailableCommands() {
        Ansi commands = Ansi.ansi().a("Available commands:").reset().newline().newline();
        ServiceLoader<WorkflowProvider> loader = ServiceLoader.load(WorkflowProvider.class);
        for (WorkflowProvider workflowProvider : loader) {
            commands = commands.fgCyan().a(workflowProvider.getTitle()).reset().a(":").newline();
            commands = HelpEmitter.renderWrappedText(commands, workflowProvider.getDescription());
            commands = commands.newline();
        }
        System.out.println(commands);
    }

    private static void renderAbbreviatedDsbulkOptionNote() {
        Ansi note = HelpEmitter.renderWrappedText(Ansi.ansi(), "Note: on the command line, long options referring to DSBulk configuration settings can have their prefix 'dsbulk' omitted.");
        System.out.println(note);
    }

    private static void renderAbbreviatedDriverOptionNote() {
        Ansi note = HelpEmitter.renderWrappedText(Ansi.ansi(), "Note: on the command line, long options referring to driver configuration settings can be introduced by the prefix 'datastax-java-driver' or just 'driver'.");
        System.out.println(note);
    }

    private static void renderDriverSpecialInstructions() {
        HelpEmitter.renderWrappedTextPreformatted("Any valid driver setting can be specified on the command line. The options listed below are just a subset of all the configurable options of the driver.");
        System.out.println();
    }

    private static void renderDriverFooter() {
        HelpEmitter.renderWrappedTextPreformatted("See the Java Driver online documentation for more information:");
        HelpEmitter.renderWrappedTextPreformatted("https://docs.datastax.com/en/developer/java-driver/latest/");
        HelpEmitter.renderWrappedTextPreformatted("https://docs.datastax.com/en/developer/java-driver-dse/latest/");
    }

    private static void renderAvailableSubSections(@NonNull String sectionName, Map<String, SettingsGroup> groups) {
        HashSet<String> subSections = new HashSet<String>();
        for (String s : groups.keySet()) {
            if (!s.startsWith(sectionName + ".")) continue;
            subSections.add(s);
        }
        if (!subSections.isEmpty()) {
            String footer = "This section has the following subsections you may be interested in:\n    " + String.join((CharSequence)"\n    ", subSections);
            HelpEmitter.renderWrappedTextPreformatted(footer);
        }
    }

    private static void renderGettingMoreHelpFooter(Map<String, SettingsGroup> groups) {
        String footer = "GETTING MORE HELP\n\nThere are many more settings/options that may be used to customize behavior. Run the `help` command with one of the following section names for more details:\n    " + String.join((CharSequence)"\n    ", HelpEmitter.getSectionNames(groups)) + "\n\nYou can also find more help at https://docs.datastax.com/en/dsbulk/doc.";
        HelpEmitter.renderWrappedTextPreformatted(footer);
    }

    @NonNull
    private static Set<String> getSectionNames(Map<String, SettingsGroup> groups) {
        LinkedHashSet<String> groupNames = new LinkedHashSet<String>(groups.keySet());
        groupNames.remove("Common");
        groupNames.add("driver");
        return groupNames;
    }

    private static void renderHelpEntries(List<HelpEntry> entries) {
        for (HelpEntry option : entries) {
            String shortOpt = option.getShortOption();
            String abbreviatedLongOpt = option.getAbbreviatedOption();
            String longOpt = option.getLongOption();
            String argumentType = option.getArgumentType();
            Ansi message = Ansi.ansi();
            if (shortOpt != null) {
                message = message.fgCyan().a("-").a(shortOpt);
                if (abbreviatedLongOpt != null || longOpt != null) {
                    message = message.reset().a(",").newline();
                }
            }
            if (abbreviatedLongOpt != null) {
                message = message.fgGreen().a("--").a(abbreviatedLongOpt).reset();
                if (longOpt != null) {
                    message = message.reset().a(",").newline();
                }
            }
            if (longOpt != null) {
                message = message.fgGreen().a("--").a(longOpt).reset();
            }
            if (argumentType != null) {
                message = message.fgYellow().a(" <").a(argumentType).a(">").reset();
            }
            message = message.newline();
            message = HelpEmitter.renderWrappedText(message, option.getDescription());
            message = message.newline();
            System.out.print(message);
        }
    }

    private static int findWrapPos(String description) {
        char c;
        int pos = description.indexOf(10);
        if (pos != -1 && pos <= ConsoleUtils.LINE_LENGTH) {
            return pos + 1;
        }
        if (ConsoleUtils.LINE_LENGTH >= description.length()) {
            return -1;
        }
        for (pos = ConsoleUtils.LINE_LENGTH; pos >= 0 && (c = description.charAt(pos)) != ' ' && c != '\n' && c != '\r'; --pos) {
        }
        if (pos > 0) {
            return pos;
        }
        return ConsoleUtils.LINE_LENGTH;
    }

    private static Ansi renderWrappedText(Ansi message, String text) {
        int indent = 4;
        if (indent >= ConsoleUtils.LINE_LENGTH) {
            indent = 1;
        }
        String padding = StringUtils.nCopies(" ", indent);
        text = padding + text.trim();
        int pos = 0;
        while ((pos = HelpEmitter.findWrapPos(text = padding + text.substring(pos).trim())) != -1) {
            if (text.length() > ConsoleUtils.LINE_LENGTH && pos == indent - 1) {
                pos = ConsoleUtils.LINE_LENGTH;
            }
            String line = text.substring(0, pos);
            String trimmed = CharMatcher.whitespace().trimTrailingFrom((CharSequence)line);
            message = message.a(trimmed).newline();
        }
        return message.a(text).newline();
    }

    private static void renderWrappedTextPreformatted(String text) {
        int pos = 0;
        while (true) {
            if ((text = text.substring(pos)).charAt(0) == ' ' && text.charAt(1) != ' ') {
                text = text.trim();
            }
            if ((pos = HelpEmitter.findWrapPos(text)) == -1) {
                System.out.println(text);
                return;
            }
            System.out.println(CharMatcher.whitespace().trimTrailingFrom((CharSequence)text.substring(0, pos)));
        }
    }
}

