/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.runner.cli;

import com.datastax.oss.driver.shaded.guava.common.collect.BiMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import com.datastax.oss.dsbulk.config.ConfigUtils;
import com.datastax.oss.dsbulk.config.shortcuts.ShortcutsFactory;
import com.datastax.oss.dsbulk.io.IOUtils;
import com.datastax.oss.dsbulk.runner.cli.GlobalHelpRequestException;
import com.datastax.oss.dsbulk.runner.cli.ParseException;
import com.datastax.oss.dsbulk.runner.cli.ParsedCommandLine;
import com.datastax.oss.dsbulk.runner.cli.SectionHelpRequestException;
import com.datastax.oss.dsbulk.runner.cli.VersionRequestException;
import com.datastax.oss.dsbulk.runner.utils.StringUtils;
import com.datastax.oss.dsbulk.workflow.api.WorkflowProvider;
import com.datastax.oss.dsbulk.workflow.api.config.ConfigPostProcessor;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class CommandLineParser {
    private static final ConfigParseOptions COMMAND_LINE_ARGUMENTS = ConfigParseOptions.defaults().setOriginDescription("command line argument").setSyntax(ConfigSyntax.CONF);
    private static final Set<String> COMMON_DRIVER_LIST_TYPE_SETTINGS = ImmutableSet.of((Object)"datastax-java-driver.basic.contact-points", (Object)"datastax-java-driver.advanced.ssl-engine-factory.cipher-suites", (Object)"datastax-java-driver.advanced.metrics.session.enabled", (Object)"datastax-java-driver.advanced.metrics.node.enabled", (Object)"datastax-java-driver.advanced.metadata.schema.refreshed-keyspaces");
    private final List<String> args;

    public CommandLineParser(String ... args) {
        this.args = Lists.newArrayList((Object[])args);
    }

    public ParsedCommandLine parse() throws ParseException, GlobalHelpRequestException, SectionHelpRequestException, VersionRequestException {
        if (this.args.isEmpty()) {
            throw new GlobalHelpRequestException();
        }
        this.checkVersionRequest();
        Path applicationPath = this.resolveApplicationPath();
        String connectorName = this.resolveConnectorName();
        this.checkHelpRequest(connectorName);
        ConfigFactory.invalidateCaches();
        Config referenceConfig = ConfigUtils.createReferenceConfig();
        Config applicationConfig = ConfigUtils.createApplicationConfig((Path)applicationPath);
        BiMap shortcuts = ShortcutsFactory.createShortcutsMap((Config)referenceConfig, (String)(connectorName == null ? "csv" : connectorName));
        WorkflowProvider workflowProvider = this.resolveWorkflowType();
        Config finalConfig = this.parseArguments(referenceConfig, applicationConfig, (Map<String, String>)shortcuts).resolve();
        finalConfig = this.postProcess(finalConfig);
        return new ParsedCommandLine(workflowProvider, finalConfig);
    }

    @Nullable
    private Path resolveApplicationPath() throws ParseException {
        Iterator<String> iterator = this.args.iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            if (!arg.equals("-f")) continue;
            if (iterator.hasNext()) {
                iterator.remove();
                Path applicationPath = ConfigUtils.resolvePath((String)iterator.next());
                iterator.remove();
                IOUtils.assertAccessibleFile((Path)applicationPath, (String)"Application file");
                return applicationPath;
            }
            throw new ParseException("Expecting application configuration path after -f");
        }
        return null;
    }

    @Nullable
    private String resolveConnectorName() throws ParseException {
        Iterator<String> iterator = this.args.iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            if (!arg.equals("-c") && !arg.equals("--connector.name")) continue;
            if (iterator.hasNext()) {
                return iterator.next();
            }
            throw new ParseException("Expecting connector name after " + arg);
        }
        return null;
    }

    private void checkVersionRequest() throws VersionRequestException {
        if (!this.args.isEmpty() && ("-v".equals(this.args.get(0)) || "--version".equals(this.args.get(0)))) {
            throw new VersionRequestException();
        }
    }

    private void checkHelpRequest(@Nullable String connectorName) throws GlobalHelpRequestException, SectionHelpRequestException {
        ListIterator<String> it = this.args.listIterator();
        boolean firstArg = true;
        while (this.skipConnector(it)) {
            String arg = it.next();
            boolean helpAsCommand = "help".equals(arg) && firstArg;
            boolean helpAsLongOption = "--help".equals(arg);
            if (helpAsCommand || helpAsLongOption) {
                if (this.skipConnector(it)) {
                    String sectionName = this.sanitizeSectionName(it.next());
                    throw new SectionHelpRequestException(sectionName, connectorName);
                }
                throw new GlobalHelpRequestException(connectorName);
            }
            firstArg = false;
        }
    }

    private boolean skipConnector(ListIterator<String> it) {
        if (it.hasNext()) {
            String arg = it.next();
            if (arg.equals("-c") || arg.equals("--connector.name")) {
                it.next();
            } else {
                it.previous();
            }
        }
        return it.hasNext();
    }

    @NonNull
    private String sanitizeSectionName(@NonNull String sectionName) {
        if (sectionName.startsWith("driver")) {
            sectionName = sectionName.replaceFirst("driver", "datastax-java-driver");
        } else if (!sectionName.startsWith("datastax-java-driver") && !sectionName.startsWith("dsbulk")) {
            sectionName = "dsbulk." + sectionName;
        }
        return sectionName;
    }

    @NonNull
    private WorkflowProvider resolveWorkflowType() throws ParseException {
        if (!this.args.isEmpty()) {
            String workflowTypeStr = this.args.remove(0);
            ServiceLoader<WorkflowProvider> loader = ServiceLoader.load(WorkflowProvider.class);
            for (WorkflowProvider workflowProvider : loader) {
                if (!workflowProvider.getTitle().equals(workflowTypeStr.toLowerCase())) continue;
                return workflowProvider;
            }
        }
        throw new ParseException(String.format("First argument must be subcommand \"%s\", or \"help\"", this.getAvailableCommands()));
    }

    @NonNull
    private Config postProcess(Config config) {
        ServiceLoader<ConfigPostProcessor> loader = ServiceLoader.load(ConfigPostProcessor.class);
        for (ConfigPostProcessor processor : loader) {
            config = processor.postProcess(config);
        }
        return config;
    }

    @NonNull
    private String getAvailableCommands() {
        ServiceLoader<WorkflowProvider> loader = ServiceLoader.load(WorkflowProvider.class);
        ArrayList<String> commands = new ArrayList<String>();
        for (WorkflowProvider workflowProvider : loader) {
            commands.add(workflowProvider.getTitle().toLowerCase());
        }
        return String.join((CharSequence)"\", \"", commands);
    }

    @NonNull
    private Config parseArguments(Config referenceConfig, Config currentConfig, Map<String, String> shortcuts) throws ParseException {
        Iterator<String> iterator = this.args.iterator();
        int argumentIndex = 0;
        while (iterator.hasNext()) {
            String arg = iterator.next();
            ++argumentIndex;
            try {
                ConfigValueType optionType;
                String optionName = null;
                String optionValue = null;
                boolean wasLongOptionWithValue = false;
                try {
                    if (arg.startsWith("--")) {
                        Config config = ConfigFactory.parseString((String)arg.substring(2));
                        Map.Entry entry = (Map.Entry)config.entrySet().iterator().next();
                        optionName = this.longNameToOptionName((String)entry.getKey(), referenceConfig);
                        optionValue = ((ConfigValue)entry.getValue()).unwrapped().toString();
                        wasLongOptionWithValue = true;
                    }
                }
                catch (ConfigException.Parse config) {
                    // empty catch block
                }
                if (!wasLongOptionWithValue) {
                    optionName = this.parseLongOrShortOptionName(arg, shortcuts, referenceConfig);
                    if (iterator.hasNext()) {
                        optionValue = iterator.next();
                        ++argumentIndex;
                    } else {
                        throw new ParseException("Expecting value after: " + arg);
                    }
                }
                if ((optionType = this.getOptionType(optionName, referenceConfig)) == ConfigValueType.OBJECT) {
                    currentConfig = currentConfig.withoutPath(optionName);
                }
                String sanitizedOptionValue = this.sanitizeValue(optionValue, optionType);
                try {
                    String paddingBeforeOptionName = StringUtils.nCopies("\n", argumentIndex - (wasLongOptionWithValue ? 0 : 1));
                    String paddingBeforeOptionValue = wasLongOptionWithValue ? "" : "\n";
                    currentConfig = ConfigFactory.parseString((String)(paddingBeforeOptionName + optionName + '=' + paddingBeforeOptionValue + sanitizedOptionValue), (ConfigParseOptions)COMMAND_LINE_ARGUMENTS).withFallback((ConfigMergeable)currentConfig);
                }
                catch (ConfigException e) {
                    IllegalArgumentException cause = ConfigUtils.convertConfigException((ConfigException)e, (String)"");
                    if (optionType == null) {
                        throw new ParseException(String.format("Invalid value for %s: '%s'", optionName, optionValue), cause);
                    }
                    throw new ParseException(String.format("Invalid value for %s, expecting %s, got: '%s'", optionName, optionType, optionValue), cause);
                }
            }
            catch (RuntimeException e) {
                throw new ParseException("Could not parse argument: " + arg, e);
            }
        }
        return currentConfig;
    }

    @Nullable
    private ConfigValueType getOptionType(String path, Config referenceConfig) {
        if (COMMON_DRIVER_LIST_TYPE_SETTINGS.contains(path)) {
            return ConfigValueType.LIST;
        }
        ConfigValueType type = null;
        try {
            type = ConfigUtils.getValueType((Config)referenceConfig, (String)path);
        }
        catch (ConfigException.Missing missing) {
            // empty catch block
        }
        return type;
    }

    @NonNull
    private String parseLongOrShortOptionName(String arg, Map<String, String> shortcuts, Config referenceConfig) throws ParseException {
        String optionName;
        if (arg.startsWith("--") && arg.length() > 2) {
            String longName = arg.substring(2);
            optionName = this.longNameToOptionName(longName, referenceConfig);
        } else if (arg.startsWith("-") && arg.length() > 1) {
            String shortcut = arg.substring(1);
            optionName = this.shortcutToOptionName(arg, shortcut, shortcuts);
        } else {
            throw new ParseException(String.format("Expecting long or short option, got: '%s'", arg));
        }
        return optionName;
    }

    @NonNull
    private String longNameToOptionName(String longName, Config referenceConfig) {
        String optionName = longName.startsWith("dsbulk.") ? longName : (longName.startsWith("datastax-java-driver.") ? longName : (longName.startsWith("driver.") ? (this.isDeprecatedDriverSetting(referenceConfig, longName) ? "dsbulk." + longName : longName.replaceFirst("driver\\.", "datastax-java-driver.")) : "dsbulk." + longName));
        return optionName;
    }

    @NonNull
    private String shortcutToOptionName(String arg, String shortcut, Map<String, String> shortcuts) throws ParseException {
        if (!shortcuts.containsKey(shortcut)) {
            throw new ParseException("Unknown short option: " + arg);
        }
        return shortcuts.get(shortcut);
    }

    private boolean isDeprecatedDriverSetting(Config referenceConfig, String settingName) {
        return referenceConfig.getConfig("dsbulk").hasPathOrNull(settingName);
    }

    @NonNull
    private String sanitizeValue(String optionValue, ConfigValueType optionType) {
        String formatted = optionValue;
        if (optionType == ConfigValueType.STRING) {
            formatted = StringUtils.ensureQuoted(optionValue);
        } else if (optionType == ConfigValueType.LIST) {
            formatted = StringUtils.ensureBrackets(optionValue);
        } else if (optionType == ConfigValueType.OBJECT) {
            formatted = StringUtils.ensureBraces(optionValue);
        }
        return formatted;
    }
}

