/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.runner;

import com.datastax.oss.dsbulk.runner.ErrorHandler;
import com.datastax.oss.dsbulk.runner.ExitStatus;
import com.datastax.oss.dsbulk.workflow.api.Workflow;
import com.datastax.oss.dsbulk.workflow.api.error.TooManyErrorsException;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowThread.class);
    private final Workflow workflow;
    private volatile ExitStatus exitStatus;

    public WorkflowThread(@NonNull Workflow workflow) {
        super("workflow-runner");
        this.workflow = workflow;
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block14: {
            this.workflow.init();
            this.exitStatus = this.workflow.execute() ? ExitStatus.STATUS_OK : ExitStatus.STATUS_COMPLETED_WITH_ERRORS;
            try {
                System.out.flush();
                System.err.flush();
                this.workflow.close();
            }
            catch (Exception e) {
                LOGGER.error(String.format("%s could not be closed.", this.workflow), (Throwable)e);
            }
            break block14;
            catch (TooManyErrorsException e) {
                LOGGER.error(this.workflow + " aborted: " + e.getMessage(), (Throwable)e);
                this.exitStatus = ExitStatus.STATUS_ABORTED_TOO_MANY_ERRORS;
                try {
                    System.out.flush();
                    System.err.flush();
                    this.workflow.close();
                }
                catch (Exception e2) {
                    LOGGER.error(String.format("%s could not be closed.", this.workflow), (Throwable)e2);
                }
            }
            catch (Throwable error) {
                this.exitStatus = ErrorHandler.handleUnexpectedError(this.workflow, error);
                {
                    catch (Throwable throwable) {
                        try {
                            System.out.flush();
                            System.err.flush();
                            this.workflow.close();
                        }
                        catch (Exception e2) {
                            LOGGER.error(String.format("%s could not be closed.", this.workflow), (Throwable)e2);
                        }
                        throw throwable;
                    }
                }
                try {
                    System.out.flush();
                    System.err.flush();
                    this.workflow.close();
                }
                catch (Exception e3) {
                    LOGGER.error(String.format("%s could not be closed.", this.workflow), (Throwable)e3);
                }
            }
        }
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public void setExitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
    }
}

