/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.runner;

import com.datastax.oss.dsbulk.runner.ExitStatus;
import com.datastax.oss.dsbulk.workflow.api.Workflow;
import com.datastax.oss.dsbulk.workflow.api.utils.ThrowableUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandler.class);
    private static final Predicate<Throwable> THROWABLE_PREDICATE = t -> {
        if (t.getClass().getName().startsWith("reactor.")) {
            return false;
        }
        if (t.getMessage() != null) {
            return !t.getMessage().contains("#block terminated");
        }
        return true;
    };

    @NonNull
    public static ExitStatus handleUnexpectedError(@Nullable Workflow workflow, @NonNull Throwable error) {
        String operationName;
        if (ThrowableUtils.isInterrupted((Throwable)error)) {
            return ExitStatus.STATUS_INTERRUPTED;
        }
        String errorMessage = ThrowableUtils.getSanitizedErrorMessage((Throwable)error, THROWABLE_PREDICATE, (int)2);
        String string = operationName = workflow == null ? "Operation" : workflow.toString();
        if (error instanceof Exception) {
            LOGGER.error(operationName + " failed: " + errorMessage, error);
            return ExitStatus.STATUS_ABORTED_FATAL_ERROR;
        }
        LOGGER.error(operationName + " failed unexpectedly: " + errorMessage, error);
        return ExitStatus.STATUS_CRASHED;
    }
}

