/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.runner;

import com.datastax.oss.dsbulk.runner.CleanupThread;
import com.datastax.oss.dsbulk.runner.ErrorHandler;
import com.datastax.oss.dsbulk.runner.ExitStatus;
import com.datastax.oss.dsbulk.runner.WorkflowThread;
import com.datastax.oss.dsbulk.runner.cli.AnsiConfigurator;
import com.datastax.oss.dsbulk.runner.cli.CommandLineParser;
import com.datastax.oss.dsbulk.runner.cli.GlobalHelpRequestException;
import com.datastax.oss.dsbulk.runner.cli.ParsedCommandLine;
import com.datastax.oss.dsbulk.runner.cli.SectionHelpRequestException;
import com.datastax.oss.dsbulk.runner.cli.VersionRequestException;
import com.datastax.oss.dsbulk.runner.help.HelpEmitter;
import com.datastax.oss.dsbulk.url.BulkLoaderURLStreamHandlerFactory;
import com.datastax.oss.dsbulk.workflow.api.Workflow;
import com.datastax.oss.dsbulk.workflow.api.utils.WorkflowUtils;
import com.typesafe.config.Config;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStaxBulkLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataStaxBulkLoader.class);
    private final String[] args;

    public static void main(String[] args) {
        BulkLoaderURLStreamHandlerFactory.install();
        ExitStatus status = new DataStaxBulkLoader(args).run();
        System.exit(status.exitCode());
    }

    public DataStaxBulkLoader(String ... args) {
        this.args = args;
    }

    @NonNull
    public ExitStatus run() {
        Workflow workflow = null;
        try {
            AnsiConfigurator.configureAnsi(this.args);
            CommandLineParser parser = new CommandLineParser(this.args);
            ParsedCommandLine result = parser.parse();
            Config config = result.getConfig();
            workflow = result.getWorkflowProvider().newWorkflow(config);
            WorkflowThread workflowThread = new WorkflowThread(workflow);
            Runtime.getRuntime().addShutdownHook(new CleanupThread(workflow, workflowThread));
            workflowThread.start();
            workflowThread.join();
            return workflowThread.getExitStatus();
        }
        catch (GlobalHelpRequestException e) {
            HelpEmitter.emitGlobalHelp(e.getConnectorName());
            return ExitStatus.STATUS_OK;
        }
        catch (SectionHelpRequestException e) {
            try {
                HelpEmitter.emitSectionHelp(e.getSectionName(), e.getConnectorName());
                return ExitStatus.STATUS_OK;
            }
            catch (Exception e2) {
                LOGGER.error(e2.getMessage(), (Throwable)e2);
                return ExitStatus.STATUS_CRASHED;
            }
        }
        catch (VersionRequestException e) {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset())));
            pw.println(WorkflowUtils.getBulkLoaderNameAndVersion());
            pw.flush();
            return ExitStatus.STATUS_OK;
        }
        catch (Throwable t) {
            return ErrorHandler.handleUnexpectedError(workflow, t);
        }
    }
}

