/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.runner;

import com.datastax.oss.dsbulk.runner.ExitStatus;
import com.datastax.oss.dsbulk.runner.WorkflowThread;
import com.datastax.oss.dsbulk.workflow.api.Workflow;
import com.datastax.oss.dsbulk.workflow.api.utils.DurationUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanupThread.class);
    private static final Duration SHUTDOWN_GRACE_PERIOD = Duration.ofSeconds(10L);
    private final Workflow workflow;
    private final WorkflowThread workflowThread;

    public CleanupThread(@NonNull Workflow workflow, @NonNull WorkflowThread workflowThread) {
        super("cleanup-thread");
        this.workflow = workflow;
        this.workflowThread = workflowThread;
    }

    @Override
    public void run() {
        try {
            if (this.workflowThread.isAlive()) {
                LOGGER.error(this.workflow + " interrupted, waiting for termination.");
                this.workflowThread.interrupt();
                this.workflowThread.join(SHUTDOWN_GRACE_PERIOD.toMillis());
                if (this.workflowThread.isAlive()) {
                    this.workflowThread.setExitStatus(ExitStatus.STATUS_CRASHED);
                    LOGGER.error(String.format("%s did not terminate within %s, forcing termination.", this.workflow, DurationUtils.formatDuration((Duration)SHUTDOWN_GRACE_PERIOD)));
                }
            }
            System.out.flush();
            System.err.flush();
            this.workflow.close();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s could not be closed.", this.workflow), (Throwable)e);
        }
    }
}

