/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.partitioner.random;

import com.datastax.oss.driver.internal.core.metadata.token.RandomToken;
import com.datastax.oss.driver.internal.core.metadata.token.RandomTokenFactory;
import com.datastax.oss.dsbulk.partitioner.BulkTokenRange;
import com.datastax.oss.dsbulk.partitioner.TokenRangeSplitter;
import com.datastax.oss.dsbulk.partitioner.random.RandomBulkTokenRange;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class RandomTokenRangeSplitter
implements TokenRangeSplitter {
    @Override
    @NonNull
    public List<BulkTokenRange> split(@NonNull BulkTokenRange tokenRange, int splitCount) {
        BigInteger val;
        BigInteger rangeSize = tokenRange.size();
        BigInteger splitPointsCount = rangeSize.compareTo(val = BigInteger.valueOf(splitCount)) < 0 ? rangeSize : val;
        BigInteger start = ((RandomToken)tokenRange.getStart()).getValue();
        ArrayList<RandomToken> splitPoints = new ArrayList<RandomToken>();
        BigInteger i = BigInteger.ZERO;
        while (i.compareTo(splitPointsCount) < 0) {
            BigInteger increment = rangeSize.multiply(i).divide(splitPointsCount);
            RandomToken splitPoint = new RandomToken(this.wrap(start.add(increment)));
            splitPoints.add(splitPoint);
            i = i.add(BigInteger.ONE);
        }
        splitPoints.add((RandomToken)tokenRange.getEnd());
        ArrayList<BulkTokenRange> splits = new ArrayList<BulkTokenRange>();
        for (int i2 = 0; i2 < splitPoints.size() - 1; ++i2) {
            List window = splitPoints.subList(i2, i2 + 2);
            RandomBulkTokenRange split = new RandomBulkTokenRange((RandomToken)window.get(0), (RandomToken)window.get(1), tokenRange.replicas());
            splits.add(split);
        }
        return splits;
    }

    private BigInteger wrap(BigInteger token) {
        return token.compareTo(RandomTokenFactory.MAX_TOKEN.getValue()) <= 0 ? token : token.subtract(RandomTokenFactory.MAX_TOKEN.getValue());
    }
}

