/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.partitioner.random;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.metadata.token.RandomToken;
import com.datastax.oss.driver.internal.core.metadata.token.RandomTokenRange;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.dsbulk.partitioner.BulkTokenRange;
import com.datastax.oss.dsbulk.partitioner.random.RandomBulkTokenFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Set;

public class RandomBulkTokenRange
extends RandomTokenRange
implements BulkTokenRange {
    private final Set<EndPoint> replicas;

    public RandomBulkTokenRange(@NonNull RandomToken start, @NonNull RandomToken end, @NonNull Set<EndPoint> replicas) {
        super(start, end);
        this.replicas = ImmutableSet.copyOf(replicas);
    }

    @NonNull
    public RandomToken getStart() {
        return (RandomToken)super.getStart();
    }

    @NonNull
    public RandomToken getEnd() {
        return (RandomToken)super.getEnd();
    }

    @Override
    @NonNull
    public Set<EndPoint> replicas() {
        return this.replicas;
    }

    @Override
    @NonNull
    public BigInteger size() {
        BigInteger left = this.getStart().getValue();
        BigInteger right = this.getEnd().getValue();
        if (right.compareTo(left) > 0) {
            return right.subtract(left);
        }
        return right.subtract(left).add(RandomBulkTokenFactory.TOTAL_TOKEN_COUNT);
    }

    @Override
    public double fraction() {
        return this.size().doubleValue() / RandomBulkTokenFactory.TOTAL_TOKEN_COUNT.doubleValue();
    }
}

