/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.partitioner.murmur3;

import com.datastax.oss.driver.internal.core.metadata.token.Murmur3Token;
import com.datastax.oss.dsbulk.partitioner.BulkTokenRange;
import com.datastax.oss.dsbulk.partitioner.TokenRangeSplitter;
import com.datastax.oss.dsbulk.partitioner.murmur3.Murmur3BulkTokenRange;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class Murmur3TokenRangeSplitter
implements TokenRangeSplitter {
    @Override
    @NonNull
    public List<BulkTokenRange> split(@NonNull BulkTokenRange tokenRange, int splitCount) {
        BigInteger val;
        BigInteger rangeSize = tokenRange.size();
        BigInteger splitPointsCount = rangeSize.compareTo(val = BigInteger.valueOf(splitCount)) < 0 ? rangeSize : val;
        BigInteger start = BigInteger.valueOf(((Murmur3Token)tokenRange.getStart()).getValue());
        ArrayList<Murmur3Token> splitPoints = new ArrayList<Murmur3Token>();
        BigInteger i = BigInteger.ZERO;
        while (i.compareTo(splitPointsCount) < 0) {
            BigInteger increment = rangeSize.multiply(i).divide(splitPointsCount);
            Murmur3Token splitPoint = new Murmur3Token(start.add(increment).longValue());
            splitPoints.add(splitPoint);
            i = i.add(BigInteger.ONE);
        }
        splitPoints.add((Murmur3Token)tokenRange.getEnd());
        ArrayList<BulkTokenRange> splits = new ArrayList<BulkTokenRange>();
        for (int i2 = 0; i2 < splitPoints.size() - 1; ++i2) {
            List window = splitPoints.subList(i2, i2 + 2);
            Murmur3BulkTokenRange split = new Murmur3BulkTokenRange((Murmur3Token)window.get(0), (Murmur3Token)window.get(1), tokenRange.replicas());
            splits.add(split);
        }
        return splits;
    }
}

