/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.partitioner.murmur3;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3Token;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3TokenRange;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.dsbulk.partitioner.BulkTokenRange;
import com.datastax.oss.dsbulk.partitioner.murmur3.Murmur3BulkTokenFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Set;

public class Murmur3BulkTokenRange
extends Murmur3TokenRange
implements BulkTokenRange {
    private final Set<EndPoint> replicas;

    public Murmur3BulkTokenRange(@NonNull Murmur3Token start, @NonNull Murmur3Token end, @NonNull Set<EndPoint> replicas) {
        super(start, end);
        this.replicas = ImmutableSet.copyOf(replicas);
    }

    @NonNull
    public Murmur3Token getStart() {
        return (Murmur3Token)super.getStart();
    }

    @NonNull
    public Murmur3Token getEnd() {
        return (Murmur3Token)super.getEnd();
    }

    @Override
    @NonNull
    public Set<EndPoint> replicas() {
        return this.replicas;
    }

    @Override
    @NonNull
    public BigInteger size() {
        BigInteger left = BigInteger.valueOf(this.getStart().getValue());
        BigInteger right = BigInteger.valueOf(this.getEnd().getValue());
        if (right.compareTo(left) > 0) {
            return right.subtract(left);
        }
        return right.subtract(left).add(Murmur3BulkTokenFactory.TOTAL_TOKEN_COUNT);
    }

    @Override
    public double fraction() {
        return this.size().doubleValue() / Murmur3BulkTokenFactory.TOTAL_TOKEN_COUNT.doubleValue();
    }
}

