/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.partitioner;

import com.datastax.oss.dsbulk.partitioner.BulkTokenRange;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public interface TokenRangeSplitter {
    @NonNull
    default public List<BulkTokenRange> split(@NonNull Iterable<BulkTokenRange> tokenRanges, int splitCount) {
        double ringFractionPerSplit = 1.0 / (double)splitCount;
        return StreamSupport.stream(tokenRanges.spliterator(), false).flatMap(range -> {
            int splits = (int)Math.max(1.0, Math.rint(range.fraction() / ringFractionPerSplit));
            List<BulkTokenRange> split = splits == 1 ? Collections.singletonList(range) : this.split((BulkTokenRange)range, splits);
            return split.stream();
        }).collect(Collectors.toList());
    }

    @NonNull
    public List<BulkTokenRange> split(@NonNull BulkTokenRange var1, int var2);
}

