/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.partitioner;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.DefaultTokenMap;
import com.datastax.oss.dsbulk.partitioner.BulkTokenFactory;
import com.datastax.oss.dsbulk.partitioner.BulkTokenRange;
import com.datastax.oss.dsbulk.partitioner.PartitionGenerator;
import com.datastax.oss.dsbulk.partitioner.utils.TokenUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TokenRangeReadStatementGenerator {
    private final RelationMetadata table;
    private final TokenMap tokenMap;

    public TokenRangeReadStatementGenerator(@NonNull RelationMetadata table, @NonNull Metadata metadata) {
        this.table = table;
        this.tokenMap = (TokenMap)metadata.getTokenMap().orElseThrow(() -> new IllegalStateException("Token metadata not present"));
    }

    @NonNull
    public List<Statement<?>> generate(int splitCount) {
        return this.generate(splitCount, this::generateSimpleStatement);
    }

    @NonNull
    public List<Statement<?>> generate(int splitCount, @NonNull Function<TokenRange, Statement<?>> statementFactory) {
        BulkTokenFactory tokenFactory = BulkTokenFactory.forPartitioner(((DefaultTokenMap)this.tokenMap).getTokenFactory().getPartitionerName());
        PartitionGenerator generator = new PartitionGenerator(this.table.getKeyspace(), this.tokenMap, tokenFactory);
        List<BulkTokenRange> partitions = generator.partition(splitCount);
        ArrayList statements = new ArrayList();
        for (TokenRange tokenRange : partitions) {
            Statement stmt = statementFactory.apply(tokenRange);
            if (stmt.getKeyspace() != null) {
                if (!stmt.getKeyspace().equals((Object)this.table.getKeyspace())) {
                    throw new IllegalStateException(String.format("Statement has different keyspace, expecting %s but got %s", this.table.getKeyspace(), stmt.getKeyspace()));
                }
            } else {
                stmt = stmt.setRoutingKeyspace(this.table.getKeyspace());
            }
            stmt = stmt.setRoutingToken(tokenRange.getEnd());
            statements.add(stmt);
        }
        return statements;
    }

    private Statement<?> generateSimpleStatement(TokenRange range) {
        String all = this.table.getColumns().keySet().stream().map(id -> id.asCql(true)).collect(Collectors.joining(","));
        String pks = this.table.getPartitionKey().stream().map(ColumnMetadata::getName).map(id -> id.asCql(true)).collect(Collectors.joining(","));
        String query = String.format("SELECT %s FROM %s.%s WHERE token(%s) > %s AND token(%s) <= %s", all, this.table.getKeyspace().asCql(true), this.table.getName().asCql(true), pks, TokenUtils.getTokenValue(range.getStart()), pks, TokenUtils.getTokenValue(range.getEnd()));
        return SimpleStatement.newInstance((String)query);
    }
}

