/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.partitioner;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.dsbulk.partitioner.BulkTokenFactory;
import com.datastax.oss.dsbulk.partitioner.BulkTokenRange;
import com.datastax.oss.dsbulk.partitioner.TokenRangeClusterer;
import com.datastax.oss.dsbulk.partitioner.TokenRangeSplitter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PartitionGenerator {
    private final CqlIdentifier keyspace;
    private final BulkTokenFactory tokenFactory;
    private final TokenMap tokenMap;

    public PartitionGenerator(CqlIdentifier keyspace, TokenMap tokenMap, BulkTokenFactory tokenFactory) {
        this.keyspace = keyspace;
        this.tokenMap = tokenMap;
        this.tokenFactory = tokenFactory;
    }

    @NonNull
    public List<BulkTokenRange> partition(int splitCount) {
        List<BulkTokenRange> tokenRanges = this.describeRing(splitCount);
        int endpointCount = (int)tokenRanges.stream().map(BulkTokenRange::replicas).distinct().count();
        int maxGroupSize = tokenRanges.size() / endpointCount;
        TokenRangeSplitter splitter = this.tokenFactory.splitter();
        List<BulkTokenRange> splits = splitter.split(tokenRanges, splitCount);
        this.checkRing(splits);
        TokenRangeClusterer clusterer = this.tokenFactory.clusterer();
        List<BulkTokenRange> groups = clusterer.group(splits, splitCount, maxGroupSize);
        this.checkRing(groups);
        return groups;
    }

    private List<BulkTokenRange> describeRing(int splitCount) {
        List<BulkTokenRange> ranges = this.tokenMap.getTokenRanges().stream().map(this::toBulkRange).collect(Collectors.toList());
        if (splitCount == 1) {
            BulkTokenRange r = ranges.get(0);
            return Collections.singletonList(this.tokenFactory.range(this.tokenFactory.minToken(), this.tokenFactory.minToken(), r.replicas()));
        }
        return ranges;
    }

    private BulkTokenRange toBulkRange(TokenRange range) {
        Set<EndPoint> replicas = this.tokenMap.getReplicas(this.keyspace, range).stream().map(Node::getEndPoint).collect(Collectors.toSet());
        return this.tokenFactory.range(range.getStart(), range.getEnd(), replicas);
    }

    private void checkRing(List<BulkTokenRange> splits) {
        double sum = splits.stream().map(BulkTokenRange::fraction).reduce(0.0, Double::sum);
        if (Math.rint(sum) != 1.0) {
            throw new IllegalStateException(String.format("Incomplete ring partition detected: %1.3f. This is likely a bug in DSBulk, please report. Generated splits: %s.", sum, splits));
        }
    }
}

