/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.partitioner;

import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.dsbulk.partitioner.BulkTokenRange;
import com.datastax.oss.dsbulk.partitioner.TokenRangeClusterer;
import com.datastax.oss.dsbulk.partitioner.TokenRangeSplitter;
import com.datastax.oss.dsbulk.partitioner.murmur3.Murmur3BulkTokenFactory;
import com.datastax.oss.dsbulk.partitioner.random.RandomBulkTokenFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Set;

public interface BulkTokenFactory
extends TokenFactory {
    @NonNull
    public static BulkTokenFactory forPartitioner(@NonNull String partitioner) {
        if (partitioner.equals("org.apache.cassandra.dht.Murmur3Partitioner")) {
            return new Murmur3BulkTokenFactory();
        }
        if (partitioner.equals("org.apache.cassandra.dht.RandomPartitioner")) {
            return new RandomBulkTokenFactory();
        }
        throw new IllegalArgumentException("Unknown partitioner: " + partitioner);
    }

    @NonNull
    public BigInteger totalTokenCount();

    @NonNull
    public BulkTokenRange range(@NonNull Token var1, @NonNull Token var2, @NonNull Set<EndPoint> var3);

    @NonNull
    public TokenRangeSplitter splitter();

    @NonNull
    public TokenRangeClusterer clusterer();
}

