/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.mapping;

import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableCollection;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.LinkedHashMultimap;
import com.datastax.oss.driver.shaded.guava.common.collect.Multimap;
import com.datastax.oss.dsbulk.generated.mapping.MappingBaseVisitor;
import com.datastax.oss.dsbulk.generated.mapping.MappingLexer;
import com.datastax.oss.dsbulk.generated.mapping.MappingParser;
import com.datastax.oss.dsbulk.mapping.CQLFragment;
import com.datastax.oss.dsbulk.mapping.CQLLiteral;
import com.datastax.oss.dsbulk.mapping.CQLRenderMode;
import com.datastax.oss.dsbulk.mapping.CQLWord;
import com.datastax.oss.dsbulk.mapping.FunctionCall;
import com.datastax.oss.dsbulk.mapping.IndexedMappingField;
import com.datastax.oss.dsbulk.mapping.MappedMappingField;
import com.datastax.oss.dsbulk.mapping.MappingField;
import com.datastax.oss.dsbulk.mapping.MappingPreference;
import com.datastax.oss.dsbulk.mapping.MappingToken;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingInspector
extends MappingBaseVisitor<MappingToken> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingInspector.class);
    private static final String EXTERNAL_TTL_VARNAME = "__ttl";
    private static final String EXTERNAL_TIMESTAMP_VARNAME = "__timestamp";
    public static final CQLWord WRITETIME = CQLWord.fromInternal("writetime");
    public static final CQLWord TTL = CQLWord.fromInternal("ttl");
    public static final CQLWord STAR = CQLWord.fromInternal("*");
    private final MappingPreference mappingPreference;
    private final boolean write;
    private final Supplier<CQLWord> usingTimestampVariable;
    private final Supplier<CQLWord> usingTTLVariable;
    private final LinkedHashMultimap<MappingField, CQLFragment> explicitMappingsBuilder;
    private final ImmutableMultimap<MappingField, CQLFragment> explicitMappings;
    private final List<CQLWord> excludedVariables;
    private int currentIndex;
    private boolean inferring;
    private boolean indexed;
    private boolean hasRegularMappedEntry = false;

    public MappingInspector(@NonNull String mapping, boolean write, @NonNull MappingPreference mappingPreference) {
        this(mapping, write, mappingPreference, null, null);
    }

    @Deprecated
    public MappingInspector(@NonNull String mapping, boolean write, @NonNull MappingPreference mappingPreference, @Nullable Supplier<CQLWord> usingTimestampVariable, @Nullable Supplier<CQLWord> usingTTLVariable) {
        this.write = write;
        this.mappingPreference = mappingPreference;
        this.usingTimestampVariable = usingTimestampVariable;
        this.usingTTLVariable = usingTTLVariable;
        CodePointCharStream input = CharStreams.fromString((String)mapping);
        MappingLexer lexer = new MappingLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        MappingParser parser = new MappingParser((TokenStream)tokens);
        BaseErrorListener listener = new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int col, String msg, RecognitionException e) {
                throw new IllegalArgumentException(String.format("Invalid mapping: mapping could not be parsed at line %d:%d: %s", line, col, msg), e);
            }
        };
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)listener);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)listener);
        MappingParser.MappingContext ctx = parser.mapping();
        this.explicitMappingsBuilder = LinkedHashMultimap.create();
        this.excludedVariables = new ArrayList<CQLWord>();
        this.visit((ParseTree)ctx);
        this.explicitMappings = this.indexed ? ImmutableMultimap.copyOf(MappingInspector.sortFieldsByIndex(this.explicitMappingsBuilder)) : ImmutableMultimap.copyOf(this.explicitMappingsBuilder);
        this.checkDuplicates();
    }

    public ImmutableMultimap<MappingField, CQLFragment> getExplicitMappings() {
        return this.explicitMappings;
    }

    public boolean isInferring() {
        return this.inferring;
    }

    public List<CQLWord> getExcludedVariables() {
        return this.excludedVariables;
    }

    @Override
    public MappingToken visitMapping(MappingParser.MappingContext ctx) {
        this.currentIndex = 0;
        if (!ctx.simpleEntry().isEmpty()) {
            this.indexed = this.mappingPreference == MappingPreference.INDEXED_ONLY;
            for (MappingParser.SimpleEntryContext entry : ctx.simpleEntry()) {
                this.visitSimpleEntry(entry);
            }
        } else if (!ctx.indexedEntry().isEmpty()) {
            this.indexed = this.mappingPreference != MappingPreference.MAPPED_ONLY;
            for (MappingParser.IndexedEntryContext entry : ctx.indexedEntry()) {
                this.visitIndexedEntry(entry);
            }
        } else if (!ctx.mappedEntry().isEmpty()) {
            this.indexed = false;
            for (MappingParser.MappedEntryContext entry : ctx.mappedEntry()) {
                this.visitMappedEntry(entry);
            }
            if (this.hasRegularMappedEntry && this.mappingPreference == MappingPreference.INDEXED_ONLY) {
                throw new IllegalArgumentException("Schema mapping contains named fields, but connector only supports indexed fields, please enable support for named fields in the connector, or alternatively, provide an indexed mapping of the form: '0=col1,1=col2,...'");
            }
        }
        return null;
    }

    @Override
    public MappingToken visitSimpleEntry(MappingParser.SimpleEntryContext ctx) {
        CQLFragment variable = this.visitVariableOrFunction(ctx.variableOrFunction());
        if (this.write && variable instanceof FunctionCall) {
            throw new IllegalArgumentException("Invalid mapping: simple entries cannot contain function calls when loading, please use mapped entries instead.");
        }
        if (this.mappingPreference == MappingPreference.INDEXED_ONLY) {
            this.explicitMappingsBuilder.put((Object)new IndexedMappingField(this.currentIndex++), (Object)variable);
        } else {
            String fieldName = variable.render(CQLRenderMode.INTERNAL);
            this.explicitMappingsBuilder.put((Object)new MappedMappingField(fieldName), (Object)variable);
        }
        return null;
    }

    @Override
    public MappingToken visitRegularMappedEntry(MappingParser.RegularMappedEntryContext ctx) {
        this.hasRegularMappedEntry = true;
        MappingField field = this.visitFieldOrFunction(ctx.fieldOrFunction());
        CQLFragment variable = this.visitVariableOrFunction(ctx.variableOrFunction());
        this.explicitMappingsBuilder.put((Object)field, (Object)variable);
        return null;
    }

    @Override
    public MappingToken visitIndexedEntry(MappingParser.IndexedEntryContext ctx) {
        MappingField field = this.visitIndexOrFunction(ctx.indexOrFunction());
        CQLFragment variable = this.visitVariableOrFunction(ctx.variableOrFunction());
        this.explicitMappingsBuilder.put((Object)field, (Object)variable);
        return null;
    }

    @Override
    public MappingToken visitInferredMappedEntry(MappingParser.InferredMappedEntryContext ctx) {
        this.checkInferring();
        this.inferring = true;
        for (MappingParser.VariableContext variableContext : ctx.variable()) {
            CQLWord variable = this.visitVariable(variableContext);
            this.excludedVariables.add(variable);
        }
        return null;
    }

    @Override
    public MappingField visitIndexOrFunction(MappingParser.IndexOrFunctionContext ctx) {
        if (ctx.index() != null) {
            return this.visitIndex(ctx.index());
        }
        return this.visitFunction(ctx.function());
    }

    @Override
    @NonNull
    public MappingField visitFieldOrFunction(MappingParser.FieldOrFunctionContext ctx) {
        if (ctx.field() != null) {
            return this.visitField(ctx.field());
        }
        return this.visitFunction(ctx.function());
    }

    @Override
    @NonNull
    public CQLFragment visitVariableOrFunction(MappingParser.VariableOrFunctionContext ctx) {
        if (ctx.variable() != null) {
            if (ctx.variable().getText().equals(EXTERNAL_TTL_VARNAME)) {
                if (!this.write) {
                    throw new IllegalArgumentException(String.format("Invalid mapping: %s mapping token not allowed when unloading.", EXTERNAL_TTL_VARNAME));
                }
                if (this.usingTTLVariable == null) {
                    LOGGER.warn("The special {} mapping token has been deprecated; please use a ttl(*) function call instead.", (Object)EXTERNAL_TTL_VARNAME);
                    return new FunctionCall(null, TTL, Collections.singletonList(STAR));
                }
                CQLWord variable = this.usingTTLVariable.get();
                if (variable == null) {
                    throw new IllegalArgumentException(String.format("Invalid mapping: %s mapping token is not allowed when the companion query does not contain a USING TTL clause", EXTERNAL_TTL_VARNAME));
                }
                LOGGER.warn("The special {} mapping token has been deprecated; since a companion query is provided, please use instead the bound variable name assigned to the USING TTL clause: {}.", (Object)EXTERNAL_TTL_VARNAME, (Object)variable.render(CQLRenderMode.VARIABLE));
                return variable;
            }
            if (ctx.variable().getText().equals(EXTERNAL_TIMESTAMP_VARNAME)) {
                if (!this.write) {
                    throw new IllegalArgumentException(String.format("Invalid mapping: %s mapping token not allowed when unloading.", EXTERNAL_TIMESTAMP_VARNAME));
                }
                if (this.usingTimestampVariable == null) {
                    LOGGER.warn("The special {} mapping token has been deprecated; please use a writetime(*) function call instead.", (Object)EXTERNAL_TIMESTAMP_VARNAME);
                    return new FunctionCall(null, WRITETIME, Collections.singletonList(STAR));
                }
                CQLWord variable = this.usingTimestampVariable.get();
                if (variable == null) {
                    throw new IllegalArgumentException(String.format("Invalid mapping: %s mapping token is not allowed when the companion query does not contain a USING TIMESTAMP clause", EXTERNAL_TIMESTAMP_VARNAME));
                }
                LOGGER.warn("The special {} mapping token has been deprecated; since a companion query is provided, please use instead the bound variable name assigned to the USING TIMESTAMP clause: {}.", (Object)EXTERNAL_TIMESTAMP_VARNAME, (Object)variable.render(CQLRenderMode.VARIABLE));
                return variable;
            }
            return this.visitVariable(ctx.variable());
        }
        return this.visitFunction(ctx.function());
    }

    @Override
    public MappingField visitIndex(MappingParser.IndexContext ctx) {
        String index = ctx.INTEGER().getText();
        if (this.mappingPreference == MappingPreference.MAPPED_ONLY) {
            return new MappedMappingField(index);
        }
        return new IndexedMappingField(Integer.parseInt(index));
    }

    @Override
    @NonNull
    public MappedMappingField visitField(MappingParser.FieldContext ctx) {
        CQLWord identifier = this.visitIdentifier(ctx.identifier());
        return new MappedMappingField(identifier.render(CQLRenderMode.INTERNAL));
    }

    @Override
    @NonNull
    public CQLWord visitVariable(MappingParser.VariableContext ctx) {
        return this.visitIdentifier(ctx.identifier());
    }

    @Override
    @NonNull
    public FunctionCall visitFunction(MappingParser.FunctionContext ctx) {
        if (ctx.writetime() != null) {
            return this.visitWritetime(ctx.writetime());
        }
        if (ctx.ttl() != null) {
            return this.visitTtl(ctx.ttl());
        }
        CQLWord keyspaceName = null;
        MappingParser.QualifiedFunctionNameContext name = ctx.qualifiedFunctionName();
        if (name.keyspaceName() != null) {
            keyspaceName = this.visitKeyspaceName(name.keyspaceName());
        }
        CQLWord functionName = this.visitFunctionName(name.functionName());
        ArrayList<CQLFragment> args = new ArrayList<CQLFragment>();
        if (ctx.functionArgs() != null) {
            for (MappingParser.FunctionArgContext arg : ctx.functionArgs().functionArg()) {
                args.add(this.visitFunctionArg(arg));
            }
        }
        return new FunctionCall(keyspaceName, functionName, args);
    }

    @Override
    public FunctionCall visitWritetime(MappingParser.WritetimeContext ctx) {
        if (!(ctx.getParent().getParent() instanceof MappingParser.VariableOrFunctionContext)) {
            throw new IllegalArgumentException("Invalid mapping: writetime() function calls not allowed on the left side of a mapping entry.");
        }
        ArrayList<CQLFragment> args = new ArrayList();
        if (ctx.STAR() != null) {
            if (!this.write) {
                throw new IllegalArgumentException("Invalid mapping: writetime(*) function calls not allowed when unloading.");
            }
            args = Collections.singletonList(STAR);
        } else {
            assert (ctx.columnName() != null);
            if (!this.write && ctx.columnName().size() > 1) {
                throw new IllegalArgumentException("Invalid mapping: writetime() function calls must have exactly one argument when unloading.");
            }
            for (MappingParser.ColumnNameContext col : ctx.columnName()) {
                args.add(this.visitColumnName(col));
            }
        }
        return new FunctionCall(null, WRITETIME, args);
    }

    @Override
    public FunctionCall visitTtl(MappingParser.TtlContext ctx) {
        if (!(ctx.getParent().getParent() instanceof MappingParser.VariableOrFunctionContext)) {
            throw new IllegalArgumentException("Invalid mapping: ttl() function calls not allowed on the left side of a mapping entry.");
        }
        ArrayList<CQLFragment> args = new ArrayList();
        if (ctx.STAR() != null) {
            if (!this.write) {
                throw new IllegalArgumentException("Invalid mapping: ttl(*) function calls not allowed when unloading.");
            }
            args = Collections.singletonList(STAR);
        } else {
            assert (ctx.columnName() != null);
            if (!this.write && ctx.columnName().size() > 1) {
                throw new IllegalArgumentException("Invalid mapping: ttl() function calls must have exactly one argument when unloading.");
            }
            for (MappingParser.ColumnNameContext col : ctx.columnName()) {
                args.add(this.visitColumnName(col));
            }
        }
        return new FunctionCall(null, TTL, args);
    }

    @Override
    public CQLWord visitKeyspaceName(MappingParser.KeyspaceNameContext ctx) {
        return this.visitIdentifier(ctx.identifier());
    }

    @Override
    @NonNull
    public CQLWord visitFunctionName(MappingParser.FunctionNameContext ctx) {
        return this.visitIdentifier(ctx.identifier());
    }

    @Override
    public CQLWord visitColumnName(MappingParser.ColumnNameContext ctx) {
        return this.visitIdentifier(ctx.identifier());
    }

    @Override
    public CQLWord visitIdentifier(MappingParser.IdentifierContext ctx) {
        if (ctx.QUOTED_IDENTIFIER() != null) {
            return CQLWord.fromCql(ctx.QUOTED_IDENTIFIER().getText());
        }
        if (ctx.WRITETIME() != null) {
            return WRITETIME;
        }
        if (ctx.TTL() != null) {
            return TTL;
        }
        assert (ctx.UNQUOTED_IDENTIFIER() != null);
        return CQLWord.fromInternal(ctx.UNQUOTED_IDENTIFIER().getText());
    }

    @Override
    @NonNull
    public CQLFragment visitFunctionArg(MappingParser.FunctionArgContext ctx) {
        if (ctx.columnName() != null) {
            return this.visitColumnName(ctx.columnName());
        }
        assert (ctx.literal() != null);
        return this.visitLiteral(ctx.literal());
    }

    @Override
    public CQLLiteral visitLiteral(MappingParser.LiteralContext ctx) {
        return new CQLLiteral(ctx.getText());
    }

    private void checkInferring() {
        if (this.inferring) {
            throw new IllegalArgumentException("Invalid mapping: inferred mapping entry (* = *) can be supplied at most once.");
        }
    }

    public static LinkedHashMultimap<MappingField, CQLFragment> sortFieldsByIndex(Multimap<MappingField, CQLFragment> unsorted) {
        LinkedHashMultimap sorted = LinkedHashMultimap.create();
        unsorted.entries().stream().sorted(Map.Entry.comparingByKey(Comparator.comparingInt(MappingInspector::compareIndexedFields))).forEachOrdered(entry -> sorted.put((Object)((MappingField)entry.getKey()), (Object)((CQLFragment)entry.getValue())));
        return sorted;
    }

    private static int compareIndexedFields(MappingField field) {
        if (field instanceof IndexedMappingField) {
            return ((IndexedMappingField)field).getFieldIndex();
        }
        assert (field instanceof FunctionCall);
        return Integer.MAX_VALUE;
    }

    private void checkDuplicates() {
        ImmutableCollection toCheck = this.write ? this.explicitMappings.values() : this.explicitMappings.inverse().values();
        List duplicates = toCheck.stream().collect(Collectors.groupingBy(v -> v, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!duplicates.isEmpty()) {
            String msg = this.write ? "the following variables are mapped to more than one field" : "the following fields are mapped to more than one variable";
            String offending = duplicates.stream().map(Object::toString).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.format("Invalid mapping: %s: %s. Please review mapping entries for duplicates.", msg, offending));
        }
    }
}

